/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;

public class ItemSword
extends Item {
    private int weaponDamage;
    private static Block[] swordBreakList = new Block[]{Block.sponge, Block.leaves, Block.cactus, Block.cloth, Block.cloth_red, Block.cloth_orange, Block.cloth_yellow, Block.cloth_lime, Block.cloth_green, Block.cloth_teal, Block.cloth_cyan, Block.cloth_blue, Block.cloth_indigo, Block.cloth_violet, Block.cloth_lilac, Block.cloth_pink, Block.cloth_magenta, Block.cloth_darkgray, Block.cloth_lightgray, Block.web};

    public ItemSword(int i, int j) {
        super(i);
        this.maxStackSize = 1;
        int maxDmg = 32 << j;
        if (j == 3) {
            maxDmg *= 4;
        }
        this.setMaxDamage(maxDmg *= 2);
        this.weaponDamage = 4 + j * 2;
    }

    public float getStrVsBlock(ItemStack itemstack, Block block) {
        int i = 0;
        while (i < swordBreakList.length) {
            if (swordBreakList[i] == block) {
                return 0.02f * (float)this.getMaxDamage();
            }
            ++i;
        }
        return 1.5f;
    }

    public boolean damageItemHit(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.damageItem(1, entityliving1);
        return true;
    }

    public boolean damageItemMine(ItemStack itemstack, int i, int j, int k, int l, EntityLiving entityliving) {
        itemstack.damageItem(2, entityliving);
        return true;
    }

    public int getDamageVsEntity(Entity entity) {
        return this.weaponDamage;
    }

    public boolean canHarvestBlock(Block block) {
        return true;
    }
}

