/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.path;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.path.PathPoint;
import com.mojang.minecraft.render.Vec3D;

public class PathEntity {
    private final PathPoint[] points;
    public final int pathLength;
    private int pathIndex;

    public PathEntity(PathPoint[] apathpoint) {
        this.points = apathpoint;
        this.pathLength = apathpoint.length;
    }

    public void incrementPathIndex() {
        ++this.pathIndex;
    }

    public boolean isFinished() {
        return this.pathIndex >= this.points.length;
    }

    public PathPoint func_22211_c() {
        if (this.pathLength > 0) {
            return this.points[this.pathLength - 1];
        }
        return null;
    }

    public Vec3D getPosition(Entity entity) {
        double d = (double)this.points[this.pathIndex].xCoord + (double)((int)(entity.width + 1.0f)) * 0.5;
        double d1 = this.points[this.pathIndex].yCoord;
        double d2 = (double)this.points[this.pathIndex].zCoord + (double)((int)(entity.width + 1.0f)) * 0.5;
        return Vec3D.createVector(d, d1, d2);
    }
}

