/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.spawn;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.PathPoint;
import com.mojang.minecraft.entity.path.Pathfinder;
import com.mojang.minecraft.enums.EnumCreatureType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.server.BiomeGenBase;
import com.mojang.minecraft.server.SpawnListEntry;
import com.mojang.minecraft.util.MathHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class SpawnerAnimals {
    private static Set nearbyChunkSet = new HashSet();
    protected static final Class[] spawnClasses = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class};

    protected static ChunkPosition randomPosWithinChunk(World world, int i, int j) {
        int k = i + world.rand.nextInt(16);
        int l = world.rand.nextInt(128);
        int i1 = j + world.rand.nextInt(16);
        return new ChunkPosition(k, l, i1);
    }

    public static final int rollForMobSpawn(World world, boolean doHostiles, boolean doPassives) {
        int mobs_count;
        if (!doHostiles && !doPassives) {
            return 0;
        }
        nearbyChunkSet.clear();
        int player = 0;
        while (player < world.playerEntities.size()) {
            EntityPlayer var4 = (EntityPlayer)world.playerEntities.get(player);
            int var5 = MathHelper.floor_double(var4.posX / 16.0);
            mobs_count = MathHelper.floor_double(var4.posZ / 16.0);
            int var7 = 8;
            int var8 = -var7;
            while (var8 <= var7) {
                int var9 = -var7;
                while (var9 <= var7) {
                    nearbyChunkSet.add(new ChunkCoordIntPair(var8 + var5, var9 + mobs_count));
                    ++var9;
                }
                ++var8;
            }
            ++player;
        }
        player = 0;
        ChunkCoordinates coords = world.getSpawnPoint();
        EnumCreatureType[] types = EnumCreatureType.values();
        mobs_count = types.length;
        int mobs_type = 0;
        while (mobs_type < mobs_count) {
            EnumCreatureType spawnedCreature = types[mobs_type];
            if ((!spawnedCreature.getHostility() || doPassives) && (spawnedCreature.getHostility() || doHostiles) && world.countEntities(spawnedCreature.getCreatureClass()) <= spawnedCreature.getMaxNumberOfCreature() * nearbyChunkSet.size() / 256) {
                Iterator chunks = nearbyChunkSet.iterator();
                int hostileAttempts = world.difficultySetting;
                block6: while (chunks.hasNext()) {
                    SpawnListEntry var152;
                    ChunkCoordIntPair chunkXZ = (ChunkCoordIntPair)chunks.next();
                    BiomeGenBase biomeshit = world.getWorldChunkManager().getBiomeTypeAt(chunkXZ);
                    List biomelist = biomeshit.getSpawnableList(spawnedCreature);
                    if (biomelist == null || biomelist.isEmpty()) continue;
                    int var13 = 0;
                    for (SpawnListEntry var152 : biomelist) {
                        var13 += var152.spawnRarityRate;
                    }
                    int var40 = world.rand.nextInt(var13);
                    var152 = (SpawnListEntry)biomelist.get(0);
                    for (SpawnListEntry var17 : biomelist) {
                        if ((var40 -= var17.spawnRarityRate) >= 0) continue;
                        var152 = var17;
                        break;
                    }
                    ChunkPosition var41 = SpawnerAnimals.randomPosWithinChunk(world, chunkXZ.chunkXPos * 16, chunkXZ.chunkZPos * 16);
                    int var42 = var41.x;
                    int var18 = var41.y;
                    int var19 = var41.z;
                    if (world.isBlockNormalCube(var42, var18, var19) || world.getMaterialXYZ(var42, var18, var19) != spawnedCreature.getCreatureMaterial()) continue;
                    int var20 = 0;
                    int var21 = 0;
                    while (var21 < 3) {
                        int var22 = var42;
                        int var23 = var18;
                        int var24 = var19;
                        int var25 = 6;
                        int var26 = 0;
                        while (var26 < 4) {
                            float var32;
                            float var31;
                            float var30;
                            float var33;
                            float var29;
                            float var28;
                            float var27;
                            if (SpawnerAnimals.validSpawningBlock(spawnedCreature, world, var22 += world.rand.nextInt(var25) - world.rand.nextInt(var25), var23 += world.rand.nextInt(1) - world.rand.nextInt(1), var24 += world.rand.nextInt(var25) - world.rand.nextInt(var25)) && world.getClosestPlayer(var27 = (float)var22 + 0.5f, var28 = (float)var23, var29 = (float)var24 + 0.5f, 24.0) == null && (var33 = (var30 = var27 - (float)coords.posX) * var30 + (var31 = var28 - (float)coords.posY) * var31 + (var32 = var29 - (float)coords.posZ) * var32) >= 576.0f) {
                                EntityLiving var43;
                                try {
                                    var43 = (EntityLiving)var152.entityClass.getConstructor(World.class).newInstance(world);
                                }
                                catch (Exception var34) {
                                    var34.printStackTrace();
                                    return player;
                                }
                                var43.setLocationAndAngles(var27, var28, var29, world.rand.nextFloat() * 360.0f, 0.0f);
                                if (var43.shouldSpawnOnTile()) {
                                    world.entityJoinedWorld(var43);
                                    SpawnerAnimals.setMobVariant(var43, world, var27, var28, var29);
                                    if (++var20 >= var43.getMaxSpawnedInChunk()) continue block6;
                                }
                                player += var20;
                            }
                            ++var26;
                        }
                        ++var21;
                    }
                }
            }
            ++mobs_type;
        }
        return player;
    }

    private static boolean validSpawningBlock(EnumCreatureType enumcreaturetype, World world, int i, int j, int k) {
        if (enumcreaturetype.getCreatureMaterial() == Material.water) {
            return world.getMaterialXYZ(i, j, k).getIsLiquid() && !world.isBlockNormalCube(i, j + 1, k);
        }
        return world.isBlockNormalCube(i, j - 1, k) && !world.isBlockNormalCube(i, j, k) && !world.getMaterialXYZ(i, j, k).getIsLiquid() && !world.isBlockNormalCube(i, j + 1, k);
    }

    private static void setMobVariant(EntityLiving entityliving, World world, float f, float f1, float f2) {
        if (entityliving instanceof EntitySpider && world.rand.nextInt(100) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(world);
            entityskeleton.setLocationAndAngles(f, f1, f2, entityliving.rotationYaw, 0.0f);
            world.entityJoinedWorld(entityskeleton);
            entityskeleton.mountEntity(entityliving);
        } else if (entityliving instanceof EntitySheep) {
            ((EntitySheep)entityliving).setFleeceColor(EntitySheep.func_21066_a(world.rand));
        }
    }

    public static boolean performSleepSpawning(World world, List list) {
        boolean flag = false;
        Pathfinder pathfinder = new Pathfinder(world);
        for (EntityPlayer entityplayer : list) {
            Class[] aclass = spawnClasses;
            if (aclass == null || aclass.length == 0) continue;
            boolean flag1 = false;
            int i = 0;
            while (i < 20 && !flag1) {
                int j = MathHelper.floor_double(entityplayer.posX) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int k = MathHelper.floor_double(entityplayer.posZ) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int l = MathHelper.floor_double(entityplayer.posY) + world.rand.nextInt(16) - world.rand.nextInt(16);
                if (l < 1) {
                    l = 1;
                } else if (l > 128) {
                    l = 128;
                }
                int i1 = world.rand.nextInt(aclass.length);
                int j1 = l;
                while (j1 > 2 && !world.isBlockNormalCube(j, j1 - 1, k)) {
                    --j1;
                }
                while (!SpawnerAnimals.validSpawningBlock(EnumCreatureType.monster, world, j, j1, k) && j1 < l + 16 && j1 < 128) {
                    ++j1;
                }
                if (j1 >= l + 16 || j1 >= 128) {
                    j1 = l;
                } else {
                    PathEntity pathentity;
                    EntityLiving entityliving;
                    float f = (float)j + 0.5f;
                    float f1 = j1;
                    float f2 = (float)k + 0.5f;
                    try {
                        entityliving = (EntityLiving)aclass[i1].getConstructor(World.class).newInstance(world);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return flag;
                    }
                    entityliving.setLocationAndAngles(f, f1, f2, world.rand.nextFloat() * 360.0f, 0.0f);
                    if (entityliving.shouldSpawnOnTile() && (pathentity = pathfinder.createEntityPathTo(entityliving, entityplayer, 32.0f)) != null && pathentity.pathLength > 1) {
                        PathPoint pathpoint = pathentity.func_22211_c();
                        if (Math.abs((double)pathpoint.xCoord - entityplayer.posX) < 1.5 && Math.abs((double)pathpoint.zCoord - entityplayer.posZ) < 1.5) {
                            Math.abs((double)pathpoint.yCoord - entityplayer.posY);
                        }
                    }
                }
                ++i;
            }
        }
        return flag;
    }
}

