/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import java.util.Random;

public class TileEntityDispenser
extends TileEntity
implements IInventory {
    private ItemStack[] dispenserContents = new ItemStack[9];
    private Random dispenserRandom = new Random();

    public int getSizeInventory() {
        return 9;
    }

    public ItemStack getStackInSlot(int i) {
        return this.dispenserContents[i];
    }

    public ItemStack decrStackSize(int i, int j) {
        if (this.dispenserContents[i] != null) {
            if (this.dispenserContents[i].stackSize <= j) {
                ItemStack itemstack = this.dispenserContents[i];
                this.dispenserContents[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.dispenserContents[i].splitStack(j);
            if (this.dispenserContents[i].stackSize == 0) {
                this.dispenserContents[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    public ItemStack getRandomStackFromInventory() {
        int i = -1;
        int j = 1;
        int k = 0;
        while (k < this.dispenserContents.length) {
            if (this.dispenserContents[k] != null && this.dispenserRandom.nextInt(j++) == 0) {
                i = k;
            }
            ++k;
        }
        if (i >= 0) {
            return this.decrStackSize(i, 1);
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.dispenserContents[i] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    public String getInvName() {
        return "Trap";
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.dispenserContents = new ItemStack[this.getSizeInventory()];
        int i = 0;
        while (i < nbttaglist.tagCount()) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= 0 && j < this.dispenserContents.length) {
                this.dispenserContents[j] = new ItemStack(nbttagcompound1);
            }
            ++i;
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < this.dispenserContents.length) {
            if (this.dispenserContents[i] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.dispenserContents[i].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            ++i;
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }
}

