/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet130UpdateSign;

public class TileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    public String entityID = "Pig";
    public double yaw;
    public double yaw2 = 0.0;

    public void setMobID(String s) {
        this.entityID = s;
    }

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    public void updateEntity() {
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        double d = (float)this.xCoord + this.worldObj.rand.nextFloat();
        double d2 = (float)this.yCoord + this.worldObj.rand.nextFloat();
        double d4 = (float)this.zCoord + this.worldObj.rand.nextFloat();
        this.worldObj.spawnParticle("smoke", d, d2, d4, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("flame", d, d2, d4, 0.0, 0.0, 0.0);
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        if (!this.worldObj.singleplayerWorld) {
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            int byte0 = 4;
            int i = 0;
            while (i < byte0) {
                EntityLiving entityliving = (EntityLiving)EntityList.createEntityByIdFromName(this.entityID, this.worldObj);
                if (entityliving == null) {
                    return;
                }
                int j = this.worldObj.getEntitiesWithinAABB(entityliving.getClass(), AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(8.0, 4.0, 8.0)).size();
                if (j >= 6) {
                    this.updateDelay();
                    return;
                }
                if (entityliving != null) {
                    double d6 = (double)this.xCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                    double d7 = this.yCoord + this.worldObj.rand.nextInt(3) - 1;
                    double d8 = (double)this.zCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                    entityliving.setLocationAndAngles(d6, d7, d8, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                    if (entityliving instanceof EntityPig) {
                        ((EntityPig)entityliving).setReal(false);
                    }
                    if (entityliving.shouldSpawnOnTile()) {
                        this.worldObj.entityJoinedWorld(entityliving);
                        int k = 0;
                        while (k < 20) {
                            double d1 = (double)this.xCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                            double d3 = (double)this.yCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                            double d5 = (double)this.zCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                            this.worldObj.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0);
                            this.worldObj.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0);
                            ++k;
                        }
                        entityliving.spawnExplosionParticle();
                        this.updateDelay();
                    }
                }
                ++i;
            }
        }
        super.updateEntity();
    }

    private void updateDelay() {
        this.delay = 200 + this.worldObj.rand.nextInt(600);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.entityID = nbttagcompound.getString("EntityId");
        this.delay = nbttagcompound.getShort("Delay");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setString("EntityId", this.entityID);
        nbttagcompound.setShort("Delay", (short)this.delay);
    }

    public Packet getDescriptionPacket() {
        String[] as = new String[4];
        as[0] = this.entityID;
        int i = 1;
        while (i < 4) {
            as[i] = "";
            ++i;
        }
        return new Packet130UpdateSign(this.xCoord, this.yCoord, this.zCoord, as);
    }
}

