/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.ArrayList;
import java.util.List;

public class TileEntityPiston
extends TileEntity {
    private int storedBlockID;
    private int storedMetadata;
    private int storedOrientation;
    private boolean isExtending;
    private boolean field_31018_j;
    private float progress;
    private float lastProgress;
    private static List field_31013_m = new ArrayList();

    public TileEntityPiston() {
    }

    public TileEntityPiston(int i, int j, int k, boolean flag, boolean flag1) {
        this.storedBlockID = i;
        this.storedMetadata = j;
        this.storedOrientation = k;
        this.isExtending = flag;
        this.field_31018_j = flag1;
    }

    public int getStoredBlockID() {
        return this.storedBlockID;
    }

    public int func_31005_e() {
        return this.storedMetadata;
    }

    public boolean func_31010_c() {
        return this.isExtending;
    }

    public int func_31008_d() {
        return this.storedOrientation;
    }

    public float func_31007_a(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * f;
    }

    private void func_31009_a(float f, float f1) {
        f = !this.isExtending ? (f -= 1.0f) : 1.0f - f;
    }

    public void clearPistonTileEntity() {
    }

    public void updateEntity() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.storedBlockID = nbttagcompound.getInteger("blockId");
        this.storedMetadata = nbttagcompound.getInteger("blockData");
        this.storedOrientation = nbttagcompound.getInteger("facing");
        this.lastProgress = this.progress = nbttagcompound.getFloat("progress");
        this.isExtending = nbttagcompound.getBoolean("extending");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("blockId", this.storedBlockID);
        nbttagcompound.setInteger("blockData", this.storedMetadata);
        nbttagcompound.setInteger("facing", this.storedOrientation);
        nbttagcompound.setFloat("progress", this.lastProgress);
        nbttagcompound.setBoolean("extending", this.isExtending);
    }
}

