/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.gui.ICommandListener;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.ServerCommand;
import com.mojang.minecraft.server.ServerConfigurationManager;
import com.mojang.minecraft.server.WorldServer;
import com.mojang.minecraft.util.IdMap;
import java.util.Set;
import java.util.logging.Logger;

public class ConsoleCommandHandler {
    private static Logger minecraftLogger = Logger.getLogger("Minecraft");
    private MinecraftServer minecraftServer;

    public ConsoleCommandHandler(MinecraftServer minecraftserver) {
        this.minecraftServer = minecraftserver;
    }

    public void handleCommand(ServerCommand servercommand) {
        block90: {
            ServerConfigurationManager serverconfigurationmanager;
            String s1;
            ICommandListener icommandlistener;
            String s;
            block88: {
                s = servercommand.command;
                icommandlistener = servercommand.commandListener;
                s1 = icommandlistener.getUsername();
                serverconfigurationmanager = this.minecraftServer.configManager;
                if (s.toLowerCase().startsWith("help") || s.toLowerCase().startsWith("?")) {
                    this.printHelp(icommandlistener);
                } else if (s.toLowerCase().startsWith("list")) {
                    icommandlistener.log("Connected players: " + serverconfigurationmanager.getPlayerList());
                } else if (s.toLowerCase().startsWith("stop")) {
                    this.sendNoticeToOps(s1, "Stopping the server..");
                    this.minecraftServer.initiateShutdown();
                } else if (s.toLowerCase().startsWith("save-all")) {
                    this.sendNoticeToOps(s1, "Forcing save..");
                    if (serverconfigurationmanager != null) {
                        serverconfigurationmanager.savePlayerStates();
                    }
                    int i = 0;
                    while (i < this.minecraftServer.worldMngr.length) {
                        WorldServer worldserver = this.minecraftServer.worldMngr[i];
                        worldserver.saveWorld(true, null);
                        ++i;
                    }
                    this.sendNoticeToOps(s1, "Save complete.");
                } else if (s.toLowerCase().startsWith("save-off")) {
                    this.sendNoticeToOps(s1, "Disabling level saving..");
                    int j = 0;
                    while (j < this.minecraftServer.worldMngr.length) {
                        WorldServer worldserver1 = this.minecraftServer.worldMngr[j];
                        worldserver1.levelSaving = true;
                        ++j;
                    }
                } else if (s.toLowerCase().startsWith("save-on")) {
                    this.sendNoticeToOps(s1, "Enabling level saving..");
                    int k = 0;
                    while (k < this.minecraftServer.worldMngr.length) {
                        WorldServer worldserver2 = this.minecraftServer.worldMngr[k];
                        worldserver2.levelSaving = false;
                        ++k;
                    }
                } else if (s.toLowerCase().startsWith("op ")) {
                    String s2 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.opPlayer(s2);
                    this.sendNoticeToOps(s1, "Opping " + s2);
                    serverconfigurationmanager.sendChatMessageToPlayer(s2, "\u00a7eYou are now op!");
                } else if (s.toLowerCase().startsWith("deop ")) {
                    String s3 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.deopPlayer(s3);
                    serverconfigurationmanager.sendChatMessageToPlayer(s3, "\u00a7eYou are no longer op!");
                    this.sendNoticeToOps(s1, "De-opping " + s3);
                } else if (s.toLowerCase().startsWith("ban-ip ")) {
                    String s4 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.banIP(s4);
                    this.sendNoticeToOps(s1, "Banning ip " + s4);
                } else if (s.toLowerCase().startsWith("pardon-ip ")) {
                    String s5 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.pardonIP(s5);
                    this.sendNoticeToOps(s1, "Pardoning ip " + s5);
                } else if (s.toLowerCase().startsWith("ban ")) {
                    String s6 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.banPlayer(s6);
                    this.sendNoticeToOps(s1, "Banning " + s6);
                    EntityPlayerMP entityplayermp = serverconfigurationmanager.getPlayerEntity(s6);
                    if (entityplayermp != null) {
                        entityplayermp.playerNetServerHandler.kickPlayer("Banned by admin");
                    }
                } else if (s.toLowerCase().startsWith("pardon ")) {
                    String s7 = s.substring(s.indexOf(" ")).trim();
                    serverconfigurationmanager.pardonPlayer(s7);
                    this.sendNoticeToOps(s1, "Pardoning " + s7);
                } else if (s.toLowerCase().startsWith("kick ")) {
                    String s8 = s.substring(s.indexOf(" ")).trim();
                    EntityPlayerMP entityplayermp1 = null;
                    int l = 0;
                    while (l < serverconfigurationmanager.playerEntities.size()) {
                        EntityPlayerMP entityplayermp5 = (EntityPlayerMP)serverconfigurationmanager.playerEntities.get(l);
                        if (entityplayermp5.username.equalsIgnoreCase(s8)) {
                            entityplayermp1 = entityplayermp5;
                        }
                        ++l;
                    }
                    if (entityplayermp1 != null) {
                        entityplayermp1.playerNetServerHandler.kickPlayer("Kicked by admin");
                        this.sendNoticeToOps(s1, "Kicking " + entityplayermp1.username);
                    } else {
                        icommandlistener.log("Can't find user " + s8 + ". No kick.");
                    }
                } else if (s.toLowerCase().startsWith("tp ")) {
                    String[] as = s.split(" ");
                    if (as.length == 3) {
                        EntityPlayerMP entityplayermp2 = serverconfigurationmanager.getPlayerEntity(as[1]);
                        EntityPlayerMP entityplayermp3 = serverconfigurationmanager.getPlayerEntity(as[2]);
                        if (entityplayermp2 == null) {
                            icommandlistener.log("Can't find user " + as[1] + ". No tp.");
                        } else if (entityplayermp3 == null) {
                            icommandlistener.log("Can't find user " + as[2] + ". No tp.");
                        } else if (entityplayermp2.dimension != entityplayermp3.dimension) {
                            icommandlistener.log("User " + as[1] + " and " + as[2] + " are in different dimensions. No tp.");
                        } else {
                            entityplayermp2.playerNetServerHandler.teleportTo(entityplayermp3.posX, entityplayermp3.posY, entityplayermp3.posZ, entityplayermp3.rotationYaw, entityplayermp3.rotationPitch);
                            this.sendNoticeToOps(s1, "Teleporting " + as[1] + " to " + as[2] + ".");
                        }
                    } else {
                        icommandlistener.log("Syntax error, please provice a source and a target.");
                    }
                } else if (s.toLowerCase().startsWith("i ")) {
                    String[] commandArgs = s.split(" ");
                    if (commandArgs.length != 2 && commandArgs.length != 3) {
                        return;
                    }
                    String target = commandArgs[1];
                    EntityPlayerMP entityplayermp4 = serverconfigurationmanager.getPlayerEntity(s1);
                    if (entityplayermp4 != null) {
                        try {
                            int j1;
                            block87: {
                                j1 = 0;
                                try {
                                    j1 = Integer.parseInt(commandArgs[1]);
                                }
                                catch (Exception ex) {
                                    j1 = IdMap.getItem(commandArgs[1]);
                                    if (j1 != -1) break block87;
                                    icommandlistener.log("Invalid item: " + commandArgs[1]);
                                    commandArgs[1].equals("null");
                                    return;
                                }
                            }
                            if (Item.itemsList[j1] != null) {
                                this.sendNoticeToOps(s1, "Giving " + entityplayermp4.username + " some " + j1);
                                int i2 = Item.itemsList[j1].getItemStackLimit();
                                if (commandArgs.length > 2) {
                                    i2 = this.tryParse(commandArgs[2], 1);
                                }
                                if (i2 < 1) {
                                    i2 = 1;
                                }
                                if (i2 > 64) {
                                    i2 = 64;
                                }
                                entityplayermp4.dropPlayerItem(new ItemStack(j1, i2, 0));
                                break block88;
                            }
                            icommandlistener.log("There's no item with id " + j1);
                        }
                        catch (NumberFormatException numberformatexception1) {
                            icommandlistener.log("There's no item with id " + commandArgs[1]);
                        }
                    } else {
                        icommandlistener.log("Can't find user " + target);
                    }
                }
            }
            if (s.toLowerCase().startsWith("give ")) {
                String[] commandArgs = s.split(" ");
                if (commandArgs.length != 3 && commandArgs.length != 4) {
                    return;
                }
                String s9 = commandArgs[1];
                EntityPlayerMP entityplayermp4 = serverconfigurationmanager.getPlayerEntity(s9);
                if (entityplayermp4 != null) {
                    try {
                        int j1;
                        block89: {
                            j1 = 0;
                            try {
                                j1 = Integer.parseInt(commandArgs[2]);
                            }
                            catch (Exception ex) {
                                j1 = IdMap.getItem(commandArgs[2]);
                                if (j1 != -1) break block89;
                                icommandlistener.log("Invalid item: " + commandArgs[2]);
                                commandArgs[1].equals("null");
                                return;
                            }
                        }
                        if (Item.itemsList[j1] != null) {
                            this.sendNoticeToOps(s1, "Giving " + entityplayermp4.username + " some " + j1);
                            int i2 = 1;
                            if (commandArgs.length > 3) {
                                i2 = this.tryParse(commandArgs[3], 1);
                            }
                            if (i2 < 1) {
                                i2 = 1;
                            }
                            if (i2 > 64) {
                                i2 = 64;
                            }
                            entityplayermp4.dropPlayerItem(new ItemStack(j1, i2, 0));
                            break block90;
                        }
                        icommandlistener.log("There's no item with id " + j1);
                    }
                    catch (NumberFormatException numberformatexception1) {
                        icommandlistener.log("There's no item with id " + commandArgs[2]);
                    }
                } else {
                    icommandlistener.log("Can't find user " + s9);
                }
            } else if (s.toLowerCase().startsWith("time ")) {
                String[] as2 = s.split(" ");
                if (as2.length != 3) {
                    return;
                }
                String s10 = as2[1];
                try {
                    int i1 = Integer.parseInt(as2[2]);
                    if ("add".equalsIgnoreCase(s10)) {
                        int k1 = 0;
                        while (k1 < this.minecraftServer.worldMngr.length) {
                            WorldServer worldserver3 = this.minecraftServer.worldMngr[k1];
                            worldserver3.func_32005_b(worldserver3.getWorldTime() + (long)i1);
                            ++k1;
                        }
                        this.sendNoticeToOps(s1, "Added " + i1 + " to time");
                        break block90;
                    }
                    if ("set".equalsIgnoreCase(s10)) {
                        int l1 = 0;
                        while (l1 < this.minecraftServer.worldMngr.length) {
                            WorldServer worldserver4 = this.minecraftServer.worldMngr[l1];
                            worldserver4.func_32005_b(i1);
                            ++l1;
                        }
                        this.sendNoticeToOps(s1, "Set time to " + i1);
                        break block90;
                    }
                    icommandlistener.log("Unknown method, use either \"add\" or \"set\"");
                }
                catch (NumberFormatException numberformatexception) {
                    icommandlistener.log("Unable to convert time value, " + as2[2]);
                }
            } else if (s.toLowerCase().startsWith("say ")) {
                s = s.substring(s.indexOf(" ")).trim();
                minecraftLogger.info("[" + s1 + "] " + s);
                serverconfigurationmanager.sendPacketToAllPlayers(new Packet3Chat("\u00a7d[Server] " + s));
            } else if (s.toLowerCase().startsWith("tell ")) {
                String[] as3 = s.split(" ");
                if (as3.length >= 3) {
                    s = s.substring(s.indexOf(" ")).trim();
                    s = s.substring(s.indexOf(" ")).trim();
                    minecraftLogger.info("[" + s1 + "->" + as3[1] + "] " + s);
                    s = "\u00a77" + s1 + " whispers " + s;
                    minecraftLogger.info(s);
                    if (!serverconfigurationmanager.sendPacketToPlayer(as3[1], new Packet3Chat(s))) {
                        icommandlistener.log("There's no player by that name online.");
                    }
                }
            } else if (s.toLowerCase().startsWith("whitelist ")) {
                this.handleWhitelist(s1, s, icommandlistener);
            } else {
                minecraftLogger.info("Unknown console command. Type \"help\" for help.");
            }
        }
    }

    private void handleWhitelist(String s, String s1, ICommandListener icommandlistener) {
        String[] as = s1.split(" ");
        if (as.length < 2) {
            return;
        }
        String s2 = as[1].toLowerCase();
        if ("on".equals(s2)) {
            this.sendNoticeToOps(s, "Turned on white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", true);
        } else if ("off".equals(s2)) {
            this.sendNoticeToOps(s, "Turned off white-listing");
            this.minecraftServer.propertyManagerObj.setProperty("white-list", false);
        } else if ("list".equals(s2)) {
            Set set = this.minecraftServer.configManager.getWhiteListedIPs();
            String s5 = "";
            for (String s6 : set) {
                s5 = s5 + s6 + " ";
            }
            icommandlistener.log("White-listed players: " + s5);
        } else if ("add".equals(s2) && as.length == 3) {
            String s3 = as[2].toLowerCase();
            this.minecraftServer.configManager.addToWhiteList(s3);
            this.sendNoticeToOps(s, "Added " + s3 + " to white-list");
        } else if ("remove".equals(s2) && as.length == 3) {
            String s4 = as[2].toLowerCase();
            this.minecraftServer.configManager.removeFromWhiteList(s4);
            this.sendNoticeToOps(s, "Removed " + s4 + " from white-list");
        } else if ("reload".equals(s2)) {
            this.minecraftServer.configManager.reloadWhiteList();
            this.sendNoticeToOps(s, "Reloaded white-list from file");
        }
    }

    private void printHelp(ICommandListener icommandlistener) {
        icommandlistener.log("To run the server without a gui, start it like this:");
        icommandlistener.log("   java -Xmx1024M -Xms1024M -jar minecraft_server.jar nogui");
        icommandlistener.log("Console commands:");
        icommandlistener.log("   help  or  ?               shows this message");
        icommandlistener.log("   kick <player>             removes a player from the server");
        icommandlistener.log("   ban <player>              bans a player from the server");
        icommandlistener.log("   pardon <player>           pardons a banned player so that they can connect again");
        icommandlistener.log("   ban-ip <ip>               bans an IP address from the server");
        icommandlistener.log("   pardon-ip <ip>            pardons a banned IP address so that they can connect again");
        icommandlistener.log("   op <player>               turns a player into an op");
        icommandlistener.log("   deop <player>             removes op status from a player");
        icommandlistener.log("   tp <player1> <player2>    moves one player to the same location as another player");
        icommandlistener.log("   give <player> <id> [num]  gives a player a resource");
        icommandlistener.log("   tell <player> <message>   sends a private message to a player");
        icommandlistener.log("   stop                      gracefully stops the server");
        icommandlistener.log("   save-all                  forces a server-wide level save");
        icommandlistener.log("   save-off                  disables terrain saving (useful for backup scripts)");
        icommandlistener.log("   save-on                   re-enables terrain saving");
        icommandlistener.log("   list                      lists all currently connected players");
        icommandlistener.log("   say <message>             broadcasts a message to all players");
        icommandlistener.log("   time <add|set> <amount>   adds to or sets the world time (0-24000)");
    }

    private void sendNoticeToOps(String s, String s1) {
        String s2 = s + ": " + s1;
        this.minecraftServer.configManager.sendChatMessageToAllOps("\u00a77(" + s2 + ")");
        minecraftLogger.info(s2);
    }

    private int tryParse(String s, int i) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberformatexception) {
            return i;
        }
    }
}

