/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.gui.GuiStatsListener;
import com.mojang.minecraft.network.NetworkManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.Timer;

public class GuiStatsComponent
extends JComponent {
    private int[] memoryUse = new int[256];
    private int updateCounter = 0;
    private String[] displayStrings = new String[10];

    public GuiStatsComponent() {
        this.setPreferredSize(new Dimension(256, 196));
        this.setMinimumSize(new Dimension(256, 196));
        this.setMaximumSize(new Dimension(256, 196));
        new Timer(500, new GuiStatsListener(this)).start();
        this.setBackground(Color.BLACK);
    }

    private void updateStats() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.gc();
        this.displayStrings[0] = "Memory use: " + l / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.displayStrings[1] = "Threads: " + NetworkManager.numReadThreads + " + " + NetworkManager.numWriteThreads;
        this.memoryUse[this.updateCounter++ & 0xFF] = (int)(l * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(new Color(0xFFFFFF));
        g.fillRect(0, 0, 256, 192);
        int i = 0;
        while (i < 256) {
            int k = this.memoryUse[i + this.updateCounter & 0xFF];
            g.setColor(new Color(k + 28 << 16));
            g.fillRect(i, 100 - k, 1, k);
            ++i;
        }
        g.setColor(Color.BLACK);
        int j = 0;
        while (j < this.displayStrings.length) {
            String s = this.displayStrings[j];
            if (s != null) {
                g.drawString(s, 32, 116 + j * 16);
            }
            ++j;
        }
    }

    static void update(GuiStatsComponent guistatscomponent) {
        guistatscomponent.updateStats();
    }
}

