/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.Explosion;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.Pathfinder;
import com.mojang.minecraft.entity.spawn.SpawnerAnimals;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.enums.EnumSeason;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.enums.EnumWeather;
import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.NextTickListEntry;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCache;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.ChunkProvider;
import com.mojang.minecraft.level.chunk.MetadataChunkBlock;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluid;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.server.BiomeGenBase;
import com.mojang.minecraft.server.ISaveHandler;
import com.mojang.minecraft.server.IWorldAccess;
import com.mojang.minecraft.server.MapDataBase;
import com.mojang.minecraft.server.MapStorage;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.WorldChunkManager;
import com.mojang.minecraft.server.WorldInfo;
import com.mojang.minecraft.server.WorldProvider;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class World
implements IBlockAccess {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final int INDEV = 4;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
            this.put(4, "2D PERLIN");
        }
    };
    public float cloudHeight = 108.0f;
    public boolean scheduledUpdatesAreImmediate = false;
    private List lightingZones = new ArrayList();
    public List loadedEntityList = new ArrayList();
    private List unloadedEntityList = new ArrayList();
    private TreeSet scheduledTickTreeSet = new TreeSet();
    private Set scheduledTickSet = new HashSet();
    public List loadedTileEntityList = new ArrayList();
    private List field_20912_E = new ArrayList();
    public List playerEntities = new ArrayList();
    public List lightningEntities = new ArrayList();
    private long field_6159_E = 0xFFFFFFL;
    public boolean snowCovered;
    public int skylightSubtracted = 0;
    protected int distHashCounter = new Random().nextInt();
    protected final int DIST_HASH_MAGIC = 1013904223;
    protected float field_27079_B;
    protected float field_27078_C;
    protected float field_27077_D;
    protected float field_27076_E;
    protected int field_27075_F = 0;
    public int field_27080_i = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp = System.currentTimeMillis();
    protected int autosavePeriod = 40;
    public int difficultySetting;
    public Random rand = new Random();
    public boolean isNewWorld = false;
    public final WorldProvider worldProvider;
    protected List worldAccesses = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final ISaveHandler worldFile;
    protected WorldInfo worldInfo;
    public boolean worldChunkLoadOverride;
    private boolean allPlayersSleeping;
    public MapStorage field_28105_z;
    private ArrayList field_9207_I = new ArrayList();
    private boolean field_31048_L;
    private int field_4265_J = 0;
    private boolean spawnHostileMobs = true;
    private boolean spawnPeacefulMobs = true;
    static int field_4268_y = 0;
    private Set activeChunkSet = new HashSet();
    private int ambientTickCountdown = this.rand.nextInt(12000);
    private List field_778_L = new ArrayList();
    public boolean singleplayerWorld = false;
    public EnumSeason season;
    public EnumSeason lastSeason;
    public EnumWeather weather;
    public boolean loadedSinceOneOneTwelve;
    public boolean experiencedFirstSnow = false;
    public int daysInSeason = 14;
    public float seasonProgress = 0.0f;

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.worldChunkMgr;
    }

    public World(ISaveHandler isavehandler, String levelname, long levelseed, WorldProvider worldprovider, String worldtype, String levelSeason, String levelWeather) {
        this.worldFile = isavehandler;
        this.field_28105_z = new MapStorage(isavehandler);
        this.worldInfo = isavehandler.func_22096_c();
        this.isNewWorld = this.worldInfo == null;
        int worldTypeInt = 0;
        if (worldtype.toLowerCase().equals("normal")) {
            worldTypeInt = 0;
        } else if (worldtype.toLowerCase().equals("floating")) {
            worldTypeInt = 1;
        } else if (worldtype.toLowerCase().equals("corruption")) {
            worldTypeInt = 2;
        } else if (worldtype.toLowerCase().equals("desert")) {
            worldTypeInt = 3;
        } else if (worldtype.toLowerCase().equals("indev")) {
            worldTypeInt = 4;
        }
        this.season = EnumSeason.summer;
        if (levelSeason.toLowerCase().equals("fall")) {
            this.season = EnumSeason.fall;
        } else if (levelSeason.toLowerCase().equals("winter")) {
            this.season = EnumSeason.winter;
        } else if (levelSeason.toLowerCase().equals("spring")) {
            this.season = EnumSeason.spring;
        } else if (levelSeason.toLowerCase().equals("cycle")) {
            this.season = EnumSeason.cycle;
        }
        this.weather = EnumWeather.seasonal;
        if (levelWeather.toLowerCase().equals("clear")) {
            this.weather = EnumWeather.clear;
        } else if (levelWeather.toLowerCase().equals("precipitation")) {
            this.weather = EnumWeather.precipitation;
        }
        this.worldProvider = worldprovider != null ? worldprovider : (this.worldInfo != null && this.worldInfo.getDimension() == -1 ? WorldProvider.func_4091_a(-1) : WorldProvider.func_4091_a(0));
        boolean flag = false;
        if (this.worldInfo == null) {
            this.worldInfo = new WorldInfo(levelseed, levelname, worldTypeInt);
            flag = true;
        } else {
            this.worldInfo.setLevelName(levelname);
        }
        this.worldProvider.registerWorld(this);
        this.chunkProvider = this.createChunkProvider();
        if (flag) {
            this.generateSpawnPoint();
        }
        this.calculateInitialSkylight();
        this.func_27070_x();
    }

    protected IChunkProvider createChunkProvider() {
        int worldType = this.worldInfo.getWorldType();
        IChunkLoader ichunkloader = this.worldFile.func_22092_a(this.worldProvider);
        return new ChunkProvider(this, ichunkloader, this.worldProvider.getChunkProvider(worldType));
    }

    protected void generateSpawnPoint() {
        this.worldChunkLoadOverride = true;
        int i = 0;
        int byte0 = 64;
        int j = 0;
        while (!this.worldProvider.canCoordinateBeSpawn(i, j)) {
            i += this.rand.nextInt(8) - this.rand.nextInt(8);
            j += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
        this.worldInfo.setSpawnPosition(i, byte0, j);
        this.worldChunkLoadOverride = false;
    }

    public int getFirstUncoveredBlock(int i, int j) {
        int k = 63;
        while (!this.isAirBlock(i, k + 1, j)) {
            ++k;
        }
        return this.getBlockId(i, k, j);
    }

    public void saveWorld(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_438_a("Saving level");
        }
        this.saveLevel();
        if (iprogressupdate != null) {
            iprogressupdate.displayLoadingString("Saving chunks");
        }
        this.chunkProvider.saveChunks(flag, iprogressupdate);
    }

    private void saveLevel() {
        this.checkSessionLock();
        this.worldFile.func_22095_a(this.worldInfo, this.playerEntities);
        this.field_28105_z.func_28176_a();
    }

    public int getBlockId(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000 || y < 0 || y >= 128) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x >> 4, z >> 4).getBlockId(x & 0xF, y, z & 0xF);
    }

    public boolean isAirBlock(int i, int j, int k) {
        return this.getBlockId(i, j, k) == 0;
    }

    public boolean blockExists(int i, int j, int k) {
        if (j < 0 || j >= 128) {
            return false;
        }
        return this.chunkExists(i >> 4, k >> 4);
    }

    public boolean doChunksNearChunkExist(int i, int j, int k, int l) {
        return this.checkChunksExist(i - l, j - l, k - l, i + l, j + l, k + l);
    }

    public boolean checkChunksExist(int i, int j, int k, int l, int i1, int j1) {
        if (i1 < 0 || j >= 128) {
            return false;
        }
        i >>= 4;
        j >>= 4;
        k >>= 4;
        l >>= 4;
        i1 >>= 4;
        j1 >>= 4;
        int k1 = i;
        while (k1 <= l) {
            int l1 = k;
            while (l1 <= j1) {
                if (!this.chunkExists(k1, l1)) {
                    return false;
                }
                ++l1;
            }
            ++k1;
        }
        return true;
    }

    private boolean chunkExists(int i, int j) {
        return this.chunkProvider.chunkExists(i, j);
    }

    public Chunk getChunkFromBlockCoords(int i, int j) {
        return this.getChunkFromChunkCoords(i >> 4, j >> 4);
    }

    public Chunk getChunkFromChunkCoords(int i, int j) {
        return this.chunkProvider.provideChunk(i, j);
    }

    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.setBlockIDWithMetadata(i & 0xF, j, k & 0xF, l, i1);
    }

    public boolean setBlock(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.setBlockID(i & 0xF, j, k & 0xF, l);
    }

    public Material getMaterialXYZ(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        if (l == 0) {
            return Material.air;
        }
        return Block.allBlocks[l].blockMaterial;
    }

    public int getBlockMetadata(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 0;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.getBlockMetadata(i &= 0xF, j, k &= 0xF);
    }

    public void setBlockMetadataWithNotify(int i, int j, int k, int l) {
        if (this.setBlockMetadata(i, j, k, l)) {
            int i1 = this.getBlockId(i, j, k);
            if (Block.requiresSelfNotify[i1 & 0xFF]) {
                this.notifyBlockChange(i, j, k, i1);
            } else {
                this.notifyBlocksOfNeighborChange(i, j, k, i1);
            }
        }
    }

    public boolean setBlockMetadata(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.setBlockMetadata(i &= 0xF, j, k &= 0xF, l);
        return true;
    }

    public boolean setBlockWithNotify(int i, int j, int k, int l) {
        if (this.setBlock(i, j, k, l)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int i, int j, int k, int l, int i1) {
        if (this.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(l)).markBlockNeedsUpdate(i, j, k);
            ++l;
        }
    }

    protected void notifyBlockChange(int i, int j, int k, int l) {
        this.markBlockNeedsUpdate(i, j, k);
        this.notifyBlocksOfNeighborChange(i, j, k, l);
    }

    public void markBlocksDirtyVertical(int i, int j, int k, int l) {
        if (k > l) {
            int i1 = l;
            l = k;
            k = i1;
        }
        this.markBlocksDirty(i, k, j, i, l, j);
    }

    public void markBlockAsNeedsUpdate(int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(l)).markBlockRangeNeedsUpdate(i, j, k, i, j, k);
            ++l;
        }
    }

    public void markBlocksDirty(int i, int j, int k, int l, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(k1)).markBlockRangeNeedsUpdate(i, j, k, l, i1, j1);
            ++k1;
        }
    }

    public void notifyBlocksOfNeighborChange(int i, int j, int k, int l) {
        this.notifyBlockOfNeighborChange(i - 1, j, k, l);
        this.notifyBlockOfNeighborChange(i + 1, j, k, l);
        this.notifyBlockOfNeighborChange(i, j - 1, k, l);
        this.notifyBlockOfNeighborChange(i, j + 1, k, l);
        this.notifyBlockOfNeighborChange(i, j, k - 1, l);
        this.notifyBlockOfNeighborChange(i, j, k + 1, l);
    }

    private void notifyBlockOfNeighborChange(int i, int j, int k, int l) {
        if (this.editingBlocks || this.singleplayerWorld) {
            return;
        }
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block != null) {
            block.onNeighborBlockChange(this, i, j, k, l);
        }
    }

    public boolean canBlockSeeTheSky(int i, int j, int k) {
        return this.getChunkFromChunkCoords(i >> 4, k >> 4).canBlockSeeTheSky(i & 0xF, j, k & 0xF);
    }

    public int getBlockLightValueNoChecks(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            j = 127;
        }
        return this.getChunkFromChunkCoords(i >> 4, k >> 4).getBlockLightValue(i & 0xF, j, k & 0xF, 0);
    }

    public int getBlockLightValue(int i, int j, int k) {
        return this.getBlockLightValue_do(i, j, k, true);
    }

    public int getBlockLightValue_do(int i, int j, int k, boolean flag) {
        int l;
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && ((l = this.getBlockId(i, j, k)) == Block.stepSingle.blockID || l == Block.tilledField.blockID || l == Block.stairCompactStone.blockID || l == Block.stairCompactPlanks.blockID)) {
            int i1 = this.getBlockLightValue_do(i, j + 1, k, false);
            int j1 = this.getBlockLightValue_do(i + 1, j, k, false);
            int k1 = this.getBlockLightValue_do(i - 1, j, k, false);
            int l1 = this.getBlockLightValue_do(i, j, k + 1, false);
            int i2 = this.getBlockLightValue_do(i, j, k - 1, false);
            if (j1 > i1) {
                i1 = j1;
            }
            if (k1 > i1) {
                i1 = k1;
            }
            if (l1 > i1) {
                i1 = l1;
            }
            if (i2 > i1) {
                i1 = i2;
            }
            return i1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            j = 127;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.getBlockLightValue(i &= 0xF, j, k &= 0xF, this.skylightSubtracted);
    }

    public boolean canExistingBlockSeeTheSky(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return true;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.canBlockSeeTheSky(i &= 0xF, j, k &= 0xF);
    }

    public int getHeightValue(int i, int j) {
        if (i < -32000000 || j < -32000000 || i >= 32000000 || j > 32000000) {
            return 0;
        }
        if (!this.chunkExists(i >> 4, j >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, j >> 4);
        return chunk.getHeightValue(i & 0xF, j & 0xF);
    }

    public void neighborLightPropagationChanged(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        int i1;
        if (this.worldProvider.field_4306_c && enumskyblock == EnumSkyBlock.Sky) {
            return;
        }
        if (!this.blockExists(i, j, k)) {
            return;
        }
        if (enumskyblock == EnumSkyBlock.Sky) {
            if (this.canExistingBlockSeeTheSky(i, j, k)) {
                l = 15;
            }
        } else if (enumskyblock == EnumSkyBlock.Block && Block.lightValue[i1 = this.getBlockId(i, j, k)] > l) {
            l = Block.lightValue[i1];
        }
        if (this.getSavedLightValue(enumskyblock, i, j, k) != l) {
            this.scheduleLightingUpdate(enumskyblock, i, j, k, i, j, k);
        }
    }

    public int getSavedLightValue(EnumSkyBlock enumskyblock, int i, int j, int k) {
        if (j < 0) {
            j = 0;
        }
        if (j >= 128) {
            j = 127;
        }
        if (j < 0 || j >= 128 || i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return enumskyblock.field_984_c;
        }
        int l = i >> 4;
        int i1 = k >> 4;
        if (!this.chunkExists(l, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l, i1);
        return chunk.getSavedLightValue(enumskyblock, i & 0xF, j, k & 0xF);
    }

    public void setLightValue(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return;
        }
        if (j < 0) {
            return;
        }
        if (j >= 128) {
            return;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.setLightValue(enumskyblock, i & 0xF, j, k & 0xF, l);
        int i1 = 0;
        while (i1 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i1)).markBlockNeedsUpdate(i, j, k);
            ++i1;
        }
    }

    public float getLightBrightness(int i, int j, int k) {
        return this.worldProvider.lightBrightnessTable[this.getBlockLightValue(i, j, k)];
    }

    public boolean isDaytime() {
        return this.skylightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D vec3d, Vec3D vec3d1) {
        return this.rayTraceBlocks_do2(vec3d, vec3d1, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        return this.rayTraceBlocks_do2(vec3d, vec3d1, flag);
    }

    public MovingObjectPosition rayTraceBlocks_do2(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i = MathHelper.floor_double(vec3d1.xCoord);
        int j = MathHelper.floor_double(vec3d1.yCoord);
        int k = MathHelper.floor_double(vec3d1.zCoord);
        int l = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = 20;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            }
            if (i < l) {
                d = (double)l + 0.0;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            }
            if (j < i1) {
                d1 = (double)i1 + 0.0;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            }
            if (k < j1) {
                d2 = (double)j1 + 0.0;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (d != 999.0) {
                d3 = (d - vec3d.xCoord) / d6;
            }
            if (d1 != 999.0) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (d2 != 999.0) {
                d5 = (d2 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                vec3d.xCoord = d;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d2;
            }
            Vec3D vec3d2 = Vec3D.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int l1 = this.getBlockId(l, i1, j1);
            int i2 = this.getBlockMetadata(l, i1, j1);
            Block block = Block.allBlocks[l1];
            if (l1 <= 0 || !block.canCollideCheck(i2, flag) || (movingobjectposition = block.collisionRayTrace(this, l, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition;
        }
        return null;
    }

    public MovingObjectPosition func_28099_a(Vec3D vec3d, Vec3D vec3d1, boolean flag, boolean flag1) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i = MathHelper.floor_double(vec3d1.xCoord);
        int j = MathHelper.floor_double(vec3d1.yCoord);
        int k = MathHelper.floor_double(vec3d1.zCoord);
        int l = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = this.getBlockId(l, i1, j1);
        int i2 = this.getBlockMetadata(l, i1, j1);
        Block block = Block.allBlocks[k1];
        if ((!flag1 || block == null || block.getCollisionBoundingBoxFromPool(this, l, i1, j1) != null) && k1 > 0 && block.canCollideCheck(i2, flag) && (movingobjectposition = block.collisionRayTrace(this, l, i1, j1, vec3d, vec3d1)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            } else if (i < l) {
                d = (double)l + 0.0;
            } else {
                flag2 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (flag2) {
                d3 = (d - vec3d.xCoord) / d6;
            }
            if (flag3) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (flag4) {
                d5 = (d2 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                vec3d.xCoord = d;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d2;
            }
            Vec3D vec3d2 = Vec3D.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int j2 = this.getBlockId(l, i1, j1);
            int k2 = this.getBlockMetadata(l, i1, j1);
            Block block1 = Block.allBlocks[j2];
            if (flag1 && block1 != null && block1.getCollisionBoundingBoxFromPool(this, l, i1, j1) == null || j2 <= 0 || !block1.canCollideCheck(k2, flag) || (movingobjectposition1 = block1.collisionRayTrace(this, l, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i)).playSound(s, entity.posX, entity.posY - (double)entity.yOffset, entity.posZ, f, f1);
            ++i;
        }
    }

    public void playSoundEffect(double d, double d1, double d2, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i)).playSound(s, d, d1, d2, f, f1);
            ++i;
        }
    }

    public void playRecord(String s, int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(l)).playRecord(s, i, j, k);
            ++l;
        }
    }

    public void spawnParticle(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i)).spawnParticle(s, d, d1, d2, d3, d4, d5);
            ++i;
        }
    }

    public boolean addLightningBolt(Entity entity) {
        this.lightningEntities.add(entity);
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
        }
        if ((flag || this.chunkExists(i, j)) && entity != null) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                this.playerEntities.add(entityplayer);
                this.updateAllPlayersSleepingFlag();
            }
            this.getChunkFromChunkCoords(i, j).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i)).obtainEntitySkin(entity);
            ++i;
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(i)).releaseEntitySkin(entity);
            ++i;
        }
    }

    public void removePlayerForLogoff(Entity entity) {
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.mountEntity(null);
        }
        if (entity.ridingEntity != null) {
            entity.mountEntity(null);
        }
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            this.updateAllPlayersSleepingFlag();
        }
    }

    public void removePlayer(Entity entity) {
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            this.updateAllPlayersSleepingFlag();
        }
        int i = entity.chunkCoordX;
        int j = entity.chunkCoordZ;
        if (entity.addedToChunk && this.chunkExists(i, j)) {
            this.getChunkFromChunkCoords(i, j).removeEntity(entity);
        }
        this.loadedEntityList.remove(entity);
        this.releaseEntitySkin(entity);
    }

    public void addWorldAccess(IWorldAccess iworldaccess) {
        this.worldAccesses.add(iworldaccess);
    }

    public List getCollidingBoundingBoxes(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_9207_I.clear();
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = i1;
            while (l1 < j1) {
                if (this.blockExists(k1, 64, l1)) {
                    int i2 = k - 1;
                    while (i2 < l) {
                        Block block = Block.allBlocks[this.getBlockId(k1, i2, l1)];
                        if (!(block == null || (entity instanceof EntityItem || entity instanceof EntityGiant) && block.blockID == Block.leaves.blockID || entity instanceof EntityGiant && block.blockID == Block.wood.blockID)) {
                            block.getCollidingBoundingBoxes(this, k1, i2, l1, axisalignedbb, this.field_9207_I);
                        }
                        ++i2;
                    }
                }
                ++l1;
            }
            ++k1;
        }
        double d = 0.25;
        List list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d, d, d));
        int j2 = 0;
        while (j2 < list.size()) {
            AxisAlignedBB axisalignedbb1 = ((Entity)list.get(j2)).getBoundingBox();
            if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_9207_I.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.func_89_d((Entity)list.get(j2))) != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_9207_I.add(axisalignedbb1);
            }
            ++j2;
        }
        return this.field_9207_I;
    }

    public int calculateSkylightSubtracted(float f) {
        float f1 = this.getCelestialAngle(f);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_27074_d(f) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.func_27065_c(f) * 5.0f) / 16.0));
        f2 = 1.0f - f2;
        return (int)(f2 * 11.0f);
    }

    public float getCelestialAngle(float renderPartialTicks) {
        EnumSeason otherSeason;
        float tickWithinCycle = (float)((int)(this.getWorldTime() % 24000L)) + renderPartialTicks;
        float currDayLength = 0.5f;
        float otherDayLength = 0.5f;
        EnumSeason currSeason = this.getCurrentSeason();
        EnumSeason enumSeason = otherSeason = this.seasonProgress <= 0.5f ? this.getLastSeason() : this.getNextSeason();
        if (currSeason != null) {
            currDayLength = currSeason.getDayLength();
            otherDayLength = otherSeason.getDayLength();
        }
        float blendFactor = Math.abs(this.seasonProgress - 0.5f);
        float dayLength = currDayLength + (otherDayLength - currDayLength) * blendFactor;
        float nightLength = 1.0f - dayLength;
        int dayLengthTicks = (int)(24000.0f * dayLength);
        int nightLengthTicks = (int)(24000.0f * nightLength);
        boolean isDay = tickWithinCycle < (float)dayLengthTicks;
        float partProgress = isDay ? tickWithinCycle / (float)dayLengthTicks : (tickWithinCycle - (float)dayLengthTicks) / (float)nightLengthTicks;
        float dayProgress = isDay ? partProgress / 2.0f : 0.5f + partProgress / 2.0f;
        if ((dayProgress -= 0.25f) < 0.0f) {
            dayProgress += 1.0f;
        }
        if (dayProgress > 1.0f) {
            dayProgress -= 1.0f;
        }
        float f2 = dayProgress;
        dayProgress = 1.0f - (float)((Math.cos((double)dayProgress * Math.PI) + 1.0) / 2.0);
        dayProgress = f2 + (dayProgress - f2) / 3.0f;
        return dayProgress;
    }

    public int getTopSolidOrLiquidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = 127; k > 0; --k) {
            Material material;
            int l = chunk.getBlockId(i, k, j);
            Material material2 = material = l != 0 ? Block.allBlocks[l].blockMaterial : Material.air;
            if (!material.blocksMovement() && !material.getIsLiquid()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public int findTopSolidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = 127; k > 0; --k) {
            int l = chunk.getBlockId(i, k, j);
            if (l == 0 || !Block.allBlocks[l].blockMaterial.blocksMovement()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public void scheduleUpdateTick(int i, int j, int k, int l, int i1) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i, j, k, l);
        int byte0 = 8;
        if (this.scheduledUpdatesAreImmediate) {
            int j1;
            if (this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) && (j1 = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) == nextticklistentry.blockID && j1 > 0) {
                Block.allBlocks[j1].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
            }
            return;
        }
        if (this.checkChunksExist(i - byte0, j - byte0, k - byte0, i + byte0, j + byte0, k + byte0)) {
            if (l > 0) {
                nextticklistentry.setScheduledTime((long)i1 + this.worldInfo.getWorldTime());
            }
            if (!this.scheduledTickSet.contains(nextticklistentry)) {
                this.scheduledTickSet.add(nextticklistentry);
                this.scheduledTickTreeSet.add(nextticklistentry);
            }
        }
    }

    public void updateEntities() {
        int i = 0;
        while (i < this.lightningEntities.size()) {
            Entity entity = (Entity)this.lightningEntities.get(i);
            entity.onUpdate();
            if (entity.isDead) {
                this.lightningEntities.remove(i--);
            }
            ++i;
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        int j = 0;
        while (j < this.unloadedEntityList.size()) {
            Entity entity1 = (Entity)this.unloadedEntityList.get(j);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
            }
            ++j;
        }
        int k = 0;
        while (k < this.unloadedEntityList.size()) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(k));
            ++k;
        }
        this.unloadedEntityList.clear();
        int l = 0;
        while (l < this.loadedEntityList.size()) {
            block19: {
                Entity entity2;
                block18: {
                    entity2 = (Entity)this.loadedEntityList.get(l);
                    if (entity2.ridingEntity == null) break block18;
                    if (!entity2.ridingEntity.isDead && entity2.ridingEntity.riddenByEntity == entity2) break block19;
                    entity2.ridingEntity.riddenByEntity = null;
                    entity2.ridingEntity = null;
                }
                if (!entity2.isDead) {
                    this.updateEntity(entity2);
                }
                if (entity2.isDead) {
                    int j1 = entity2.chunkCoordX;
                    int l1 = entity2.chunkCoordZ;
                    if (entity2.addedToChunk && this.chunkExists(j1, l1)) {
                        this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
                    }
                    this.loadedEntityList.remove(l--);
                    this.releaseEntitySkin(entity2);
                }
            }
            ++l;
        }
        this.field_31048_L = true;
        Iterator iterator = this.loadedTileEntityList.iterator();
        while (iterator.hasNext()) {
            TileEntity tileentity = (TileEntity)iterator.next();
            if (!tileentity.isInvalid()) {
                tileentity.updateEntity();
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            Chunk chunk = this.getChunkFromChunkCoords(tileentity.xCoord >> 4, tileentity.zCoord >> 4);
            if (chunk == null) continue;
            chunk.removeChunkBlockTileEntity(tileentity.xCoord & 0xF, tileentity.yCoord, tileentity.zCoord & 0xF);
        }
        this.field_31048_L = false;
        if (!this.field_20912_E.isEmpty()) {
            for (TileEntity tileentity1 : this.field_20912_E) {
                Chunk chunk1;
                if (tileentity1.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileentity1)) {
                    this.loadedTileEntityList.add(tileentity1);
                }
                if ((chunk1 = this.getChunkFromChunkCoords(tileentity1.xCoord >> 4, tileentity1.zCoord >> 4)) != null) {
                    chunk1.setChunkBlockTileEntity(tileentity1.xCoord & 0xF, tileentity1.yCoord, tileentity1.zCoord & 0xF, tileentity1);
                }
                this.markBlockNeedsUpdate(tileentity1.xCoord, tileentity1.yCoord, tileentity1.zCoord);
            }
            this.field_20912_E.clear();
        }
    }

    public void func_31047_a(Collection collection) {
        if (this.field_31048_L) {
            this.field_20912_E.addAll(collection);
        } else {
            this.loadedTileEntityList.addAll(collection);
        }
    }

    public void updateEntity(Entity entity) {
        this.updateEntityWithOptionalForce(entity, true);
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        int i = MathHelper.floor_double(entity.posX);
        int j = MathHelper.floor_double(entity.posZ);
        int byte0 = 32;
        if (flag && !this.checkChunksExist(i - byte0, 0, j - byte0, i + byte0, 128, j + byte0)) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).tryToDespawn();
            }
            return;
        }
        entity.lastTickPosX = entity.posX;
        entity.lastTickPosY = entity.posY;
        entity.lastTickPosZ = entity.posZ;
        entity.prevRotationYaw = entity.rotationYaw;
        entity.prevRotationPitch = entity.rotationPitch;
        if (flag && entity.addedToChunk) {
            if (entity.ridingEntity != null) {
                entity.updateRidden();
            } else {
                entity.onUpdate();
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.lastTickPosX;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.lastTickPosY;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.lastTickPosZ;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.prevRotationPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.prevRotationYaw;
        }
        int k = MathHelper.floor_double(entity.posX / 16.0);
        int l = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.chunkExists(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.chunkExists(k, i1)) {
                entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
            }
        }
        if (flag && entity.addedToChunk && entity.riddenByEntity != null) {
            if (entity.riddenByEntity.isDead || entity.riddenByEntity.ridingEntity != entity) {
                entity.riddenByEntity.ridingEntity = null;
                entity.riddenByEntity = null;
            } else {
                this.updateEntity(entity.riddenByEntity);
            }
        }
    }

    public boolean checkIfAABBIsClear(AxisAlignedBB axisalignedbb) {
        List list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        int i = 0;
        while (i < list.size()) {
            Entity entity = (Entity)list.get(i);
            if (!entity.isDead && entity.preventEntitySpawning) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean func_27069_b(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean getIsAnyLiquid(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial.getIsLiquid()) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB axisalignedbb) {
        int j1;
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (this.checkChunksExist(i, k, i1, j, l, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            int k1 = i;
            while (k1 < j) {
                int l1 = k;
                while (l1 < l) {
                    int i2 = i1;
                    while (i2 < j1) {
                        int j2 = this.getBlockId(k1, l1, i2);
                        if (j2 == Block.fire.blockID || j2 == Block.lavaMoving.blockID || j2 == Block.lavaStill.blockID) {
                            return true;
                        }
                        ++i2;
                    }
                    ++l1;
                }
                ++k1;
            }
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int j1;
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (!this.checkChunksExist(i, k, i1, j, l, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            return false;
        }
        boolean flag = false;
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    double d1;
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material && (double)l >= (d1 = (double)((float)(l1 + 1) - BlockFluid.setFluidHeight(this.getBlockMetadata(k1, l1, i2))))) {
                        flag = true;
                        block.velocityToAddToEntity(this, k1, l1, i2, entity, vec3d);
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d = 0.014;
            entity.motionX += vec3d.xCoord * d;
            entity.motionY += vec3d.yCoord * d;
            entity.motionZ += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean isMaterialInBB(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        int j2 = this.getBlockMetadata(k1, l1, i2);
                        double d = l1 + 1;
                        if (j2 < 8) {
                            d = (double)(l1 + 1) - (double)j2 / 8.0;
                        }
                        if (d >= axisalignedbb.minY) {
                            return true;
                        }
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double d, double d1, double d2, float f) {
        return this.newExplosion(entity, d, d1, d2, f, false);
    }

    public Explosion newExplosion(Entity entity, double d, double d1, double d2, float f, boolean flag) {
        Explosion explosion = new Explosion(this, entity, d, d1, d2, f);
        explosion.isFlaming = flag;
        explosion.doExplosion();
        explosion.doEffects(true);
        return explosion;
    }

    public float func_494_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f2;
                    if (this.rayTraceBlocks(Vec3D.createVector(d3, d4, d5), vec3d) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void func_28096_a(EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (l == 0) {
            --j;
        }
        if (l == 1) {
            ++j;
        }
        if (l == 2) {
            --k;
        }
        if (l == 3) {
            ++k;
        }
        if (l == 4) {
            --i;
        }
        if (l == 5) {
            ++i;
        }
        if (this.getBlockId(i, j, k) == Block.fire.blockID) {
            this.sendDoorChangeState(entityplayer, 1004, i, j, k, 0);
            this.setBlockWithNotify(i, j, k, 0);
        }
    }

    public TileEntity getBlockTileEntity(int i, int j, int k) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            return chunk.getChunkBlockTileEntity(i & 0xF, j, k & 0xF);
        }
        return null;
    }

    public void setBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (!tileentity.isInvalid()) {
            if (this.field_31048_L) {
                tileentity.xCoord = i;
                tileentity.yCoord = j;
                tileentity.zCoord = k;
                this.field_20912_E.add(tileentity);
            } else {
                this.loadedTileEntityList.add(tileentity);
                Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
                if (chunk != null) {
                    chunk.setChunkBlockTileEntity(i & 0xF, j, k & 0xF, tileentity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity = this.getBlockTileEntity(i, j, k);
        if (tileentity != null && this.field_31048_L) {
            tileentity.invalidate();
        } else {
            Chunk chunk;
            if (tileentity != null) {
                this.loadedTileEntityList.remove(tileentity);
            }
            if ((chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4)) != null) {
                chunk.removeChunkBlockTileEntity(i & 0xF, j, k & 0xF);
            }
        }
    }

    public boolean isBlockOpaqueCube(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isBlockNormalCube(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isWater(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial == Material.water;
    }

    public boolean func_6156_d() {
        if (this.field_4265_J >= 50) {
            return false;
        }
        ++this.field_4265_J;
        try {
            boolean flag1;
            int i = 500;
            while (this.lightingZones.size() > 0) {
                if (--i <= 0) {
                    boolean flag;
                    boolean bl = flag = true;
                    return bl;
                }
                ((MetadataChunkBlock)this.lightingZones.remove(this.lightingZones.size() - 1)).func_4107_a(this);
            }
            boolean bl = flag1 = false;
            return bl;
        }
        finally {
            --this.field_4265_J;
        }
    }

    public void scheduleLightingUpdate(EnumSkyBlock enumskyblock, int i, int j, int k, int l, int i1, int j1) {
        this.func_484_a(enumskyblock, i, j, k, l, i1, j1, true);
    }

    public void func_484_a(EnumSkyBlock enumskyblock, int i, int j, int k, int l, int i1, int j1, boolean flag) {
        if (this.worldProvider.field_4306_c && enumskyblock == EnumSkyBlock.Sky) {
            return;
        }
        ++field_4268_y;
        try {
            if (field_4268_y == 50) {
                return;
            }
            int k1 = (l + i) / 2;
            int l1 = (j1 + k) / 2;
            if (!this.blockExists(k1, 64, l1)) {
                return;
            }
            if (this.getChunkFromBlockCoords(k1, l1).func_21101_g()) {
                return;
            }
            int i2 = this.lightingZones.size();
            if (flag) {
                int j2 = 5;
                if (j2 > i2) {
                    j2 = i2;
                }
                int l2 = 0;
                while (l2 < j2) {
                    MetadataChunkBlock metadatachunkblock = (MetadataChunkBlock)this.lightingZones.get(this.lightingZones.size() - l2 - 1);
                    if (metadatachunkblock.field_957_a == enumskyblock && metadatachunkblock.func_692_a(i, j, k, l, i1, j1)) {
                        return;
                    }
                    ++l2;
                }
            }
            this.lightingZones.add(new MetadataChunkBlock(enumskyblock, i, j, k, l, i1, j1));
            int k2 = 1000000;
            if (this.lightingZones.size() > 1000000) {
                System.out.println("More than " + k2 + " updates, aborting lighting updates");
                this.lightingZones.clear();
            }
        }
        finally {
            --field_4268_y;
        }
    }

    public void calculateInitialSkylight() {
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
        }
    }

    public void setAllowedSpawnTypes(boolean flag, boolean flag1) {
        this.spawnHostileMobs = flag;
        this.spawnPeacefulMobs = flag1;
    }

    public void tick() {
        this.updateWeather();
        if (this.isAllPlayersFullyAsleep()) {
            boolean flag = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1) {
                flag = SpawnerAnimals.performSleepSpawning(this, this.playerEntities);
            }
            if (!flag) {
                long l = this.worldInfo.getWorldTime() + 24000L;
                this.worldInfo.setWorldTime(l - l % 24000L);
                this.wakeUpAllPlayers();
            }
        }
        SpawnerAnimals.rollForMobSpawn(this, this.spawnHostileMobs, this.spawnPeacefulMobs);
        this.chunkProvider.unload100OldestChunks();
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
            int j = 0;
            while (j < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(j)).updateAllRenderers();
                ++j;
            }
        }
        if (this.getCurrentSeason() != this.lastSeason) {
            if (this.getCurrentSeason() == EnumSeason.winter) {
                MinecraftServer.getMinecraft().cleanSpawnChunks(true);
            } else {
                MinecraftServer.getMinecraft().cleanSpawnChunks(false);
            }
        }
        this.lastSeason = this.getCurrentSeason();
        long l1 = this.worldInfo.getWorldTime() + 1L;
        if (l1 % (long)this.autosavePeriod == 0L) {
            this.saveWorld(false, null);
        }
        this.worldInfo.setWorldTime(l1);
        this.TickUpdates(false);
        this.doRandomUpdateTicks();
    }

    private void func_27070_x() {
        if (this.worldInfo.getIsRaining()) {
            this.field_27078_C = 1.0f;
            if (this.worldInfo.getIsThundering()) {
                this.field_27076_E = 1.0f;
            }
        }
    }

    protected void updateWeather() {
        int j;
        int i;
        if (this.worldProvider.field_4306_c) {
            return;
        }
        if (this.field_27075_F > 0) {
            --this.field_27075_F;
        }
        if ((i = this.worldInfo.getThunderTime()) <= 0) {
            if (this.worldInfo.getIsThundering()) {
                this.worldInfo.setIsThundering(false);
            }
        } else {
            this.worldInfo.setThunderTime(--i);
            if (i <= 0) {
                this.worldInfo.setIsThundering(!this.worldInfo.getIsThundering());
            }
        }
        if ((j = this.worldInfo.getRainTime()) <= 0) {
            if (this.worldInfo.getIsRaining()) {
                this.worldInfo.setIsRaining(false);
            }
        } else {
            this.worldInfo.setRainTime(--j);
            if (j <= 0) {
                this.worldInfo.setIsRaining(!this.worldInfo.getIsRaining());
            }
        }
        this.field_27079_B = this.field_27078_C;
        this.field_27078_C = this.worldInfo.getIsRaining() ? (float)((double)this.field_27078_C + 0.01) : (float)((double)this.field_27078_C - 0.01);
        if (this.field_27078_C < 0.0f) {
            this.field_27078_C = 0.0f;
        }
        if (this.field_27078_C > 1.0f) {
            this.field_27078_C = 1.0f;
        }
        this.field_27077_D = this.field_27076_E;
        this.field_27076_E = this.worldInfo.getIsThundering() ? (float)((double)this.field_27076_E + 0.01) : (float)((double)this.field_27076_E - 0.01);
        if (this.field_27076_E < 0.0f) {
            this.field_27076_E = 0.0f;
        }
        if (this.field_27076_E > 1.0f) {
            this.field_27076_E = 1.0f;
        }
    }

    private void clearWeather() {
        this.worldInfo.setRainTime(0);
        this.worldInfo.setIsRaining(false);
        this.worldInfo.setThunderTime(0);
        this.worldInfo.setIsThundering(false);
    }

    protected void doRandomUpdateTicks() {
        int chunkZ;
        int chunkX;
        this.activeChunkSet.clear();
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer = (EntityPlayer)this.playerEntities.get(i);
            chunkX = MathHelper.floor_double(entityplayer.posX / 16.0);
            chunkZ = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int radius = 9;
            int x = -radius;
            while (x <= radius) {
                int z = -radius;
                while (z <= radius) {
                    this.activeChunkSet.add(new ChunkCoordIntPair(x + chunkX, z + chunkZ));
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        if (this.ambientTickCountdown > 0) {
            --this.ambientTickCountdown;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.activeChunkSet) {
            chunkX = chunkcoordintpair.chunkXPos * 16;
            chunkZ = chunkcoordintpair.chunkZPos * 16;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkXPos, chunkcoordintpair.chunkZPos);
            if (this.ambientTickCountdown == 0) {
                EntityPlayer entityplayer1;
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                int k1 = this.distHashCounter >> 2;
                int l2 = k1 & 0xF;
                int l3 = k1 >> 8 & 0xF;
                int l4 = k1 >> 16 & 0x7F;
                int l5 = chunk.getBlockId(l2, l4, l3);
                if (l5 == 0 && this.getBlockLightValueNoChecks(l2 += chunkX, l4, l3 += chunkZ) <= this.rand.nextInt(8) && this.getSavedLightValue(EnumSkyBlock.Sky, l2, l4, l3) <= 0 && (entityplayer1 = this.getClosestPlayer((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, 8.0)) != null && entityplayer1.getDistanceSq((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5) > 4.0) {
                    this.playSoundEffect((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                    this.ambientTickCountdown = this.rand.nextInt(12000) + 6000;
                }
            }
            if (this.rand.nextInt(100000) == 0 && this.func_27068_v() && this.func_27067_u()) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                int l1 = this.distHashCounter >> 2;
                int i3 = chunkX + (l1 & 0xF);
                int i4 = chunkZ + (l1 >> 8 & 0xF);
                int i5 = this.getTopSolidOrLiquidBlock(i3, i4);
                if (this.canLightningStrikeAt(i3, i5, i4)) {
                    this.field_27075_F = 2;
                }
            }
            if (this.rand.nextInt(16) == 0) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                int i2 = this.distHashCounter >> 2;
                int ranX = i2 & 0xF;
                int ranY = i2 >> 8 & 0xF;
                int topBlock = this.getTopSolidOrLiquidBlock(ranX + chunkX, ranY + chunkZ);
                if (this.getCurrentSeason() == EnumSeason.winter && this.rand.nextInt(4) == 0 && topBlock >= 0 && topBlock < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, ranX, topBlock, ranY) < 10) {
                    int i5 = chunk.getBlockId(ranX, topBlock - 1, ranY);
                    if (chunk.getBlockId(ranX, topBlock, ranY) == 0 && Block.snow.canPlace(this, ranX + chunkX, topBlock, ranY + chunkZ)) {
                        this.setBlockWithNotify(ranX + chunkX, topBlock, ranY + chunkZ, Block.snow.blockID);
                    }
                    if (i5 == Block.waterStill.blockID && chunk.getBlockMetadata(ranX, topBlock - 1, ranY) == 0 && Block.ice.canPlace(this, ranX + chunkX, topBlock, ranY + chunkZ)) {
                        this.setBlockWithNotify(ranX + chunkX, topBlock - 1, ranY + chunkZ, Block.ice.blockID);
                    }
                }
                if (this.getCurrentSeason() != EnumSeason.winter && this.rand.nextInt(4) == 0 && topBlock >= 0 && topBlock < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, ranX, topBlock, ranY) < 10) {
                    int block = chunk.getBlockId(ranX, topBlock - 1, ranY);
                    if (chunk.getBlockId(ranX, topBlock, ranY) == Block.snow.blockID) {
                        this.setBlockWithNotify(ranX + chunkX, topBlock, ranY + chunkZ, 0);
                    }
                    if (block == Block.ice.blockID && chunk.getBlockMetadata(ranX, topBlock - 1, ranY) == 0) {
                        this.setBlockWithNotify(ranX + chunkX, topBlock - 1, ranY + chunkZ, Block.waterStill.blockID);
                    }
                }
            }
            int j2 = 0;
            while (j2 < 80) {
                this.distHashCounter = this.distHashCounter * 3 + 1013904223;
                int k3 = this.distHashCounter >> 2;
                int k4 = k3 & 0xF;
                int k5 = k3 >> 8 & 0xF;
                int j6 = k3 >> 16 & 0x7F;
                int l6 = chunk.blocks[k4 << 11 | k5 << 7 | j6] & 0xFF;
                if (Block.tickOnLoad[l6]) {
                    Block.allBlocks[l6].updateTick(this, k4 + chunkX, j6, k5 + chunkZ, this.rand);
                }
                ++j2;
            }
        }
    }

    public boolean TickUpdates(boolean flag) {
        int i = this.scheduledTickTreeSet.size();
        if (i != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i > 1000) {
            i = 1000;
        }
        int j = 0;
        while (j < i) {
            int k;
            NextTickListEntry nextticklistentry = (NextTickListEntry)this.scheduledTickTreeSet.first();
            if (!flag && nextticklistentry.scheduledTime > this.worldInfo.getWorldTime()) break;
            this.scheduledTickTreeSet.remove(nextticklistentry);
            this.scheduledTickSet.remove(nextticklistentry);
            int byte0 = 8;
            if (this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) && (k = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) == nextticklistentry.blockID && k > 0) {
                Block.allBlocks[k].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
            }
            ++j;
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public List getEntitiesWithinAABBExcludingEntity(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_778_L.clear();
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(entity, axisalignedbb, this.field_778_L);
                }
                ++j1;
            }
            ++i1;
        }
        return this.field_778_L;
    }

    public List getEntitiesWithinAABB(Class class1, AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        ArrayList arraylist = new ArrayList();
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(class1, axisalignedbb, arraylist);
                }
                ++j1;
            }
            ++i1;
        }
        return arraylist;
    }

    public void updateTileEntityChunkAndDoNothing(int i, int j, int k, TileEntity tileentity) {
        if (this.blockExists(i, j, k)) {
            this.getChunkFromBlockCoords(i, k).setChunkModified();
        }
        int l = 0;
        while (l < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(l)).doNothingWithTileEntity(i, j, k, tileentity);
            ++l;
        }
    }

    public int countEntities(Class class1) {
        int i = 0;
        int j = 0;
        while (j < this.loadedEntityList.size()) {
            Entity entity = (Entity)this.loadedEntityList.get(j);
            if (class1.isAssignableFrom(entity.getClass())) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    public void addLoadedEntities(List list) {
        this.loadedEntityList.addAll(list);
        int i = 0;
        while (i < list.size()) {
            this.obtainEntitySkin((Entity)list.get(i));
            ++i;
        }
    }

    public void addUnloadedEntities(List list) {
        this.unloadedEntityList.addAll(list);
    }

    public boolean canBlockBePlacedAt(int i, int j, int k, int l, boolean flag, int i1) {
        int j1 = this.getBlockId(j, k, l);
        Block block = Block.allBlocks[j1];
        Block block1 = Block.allBlocks[i];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, j, k, l);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.checkIfAABBIsClear(axisalignedbb)) {
            return false;
        }
        if (block == Block.waterMoving || block == Block.waterStill || block == Block.lavaMoving || block == Block.lavaStill || block == Block.fire || block == Block.snow) {
            return true;
        }
        return i > 0 && block == null && block1.canPlaceBlockOnSide(this, j, k, l, i1);
    }

    public PathEntity getPathToEntity(Entity entity, Entity entity1, float f) {
        int i = MathHelper.floor_double(entity.posX);
        int j = MathHelper.floor_double(entity.posY);
        int k = MathHelper.floor_double(entity.posZ);
        int l = (int)(f + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f);
    }

    public PathEntity getEntityPathToXYZ(Entity entity, int i, int j, int k, float f) {
        int l = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i, j, k, f);
    }

    public boolean isBlockProvidingPowerTo(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isIndirectlyPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockGettingPowered(int i, int j, int k) {
        if (this.isBlockProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(i + 1, j, k, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i, int j, int k, int l) {
        if (this.isBlockNormalCube(i, j, k)) {
            return this.isBlockGettingPowered(i, j, k);
        }
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockIndirectlyGettingPowered(int i, int j, int k) {
        if (this.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double d) {
        return this.getClosestPlayer(entity.posX, entity.posY, entity.posZ, d);
    }

    public EntityPlayer getClosestPlayer(double d, double d1, double d2, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer1 = (EntityPlayer)this.playerEntities.get(i);
            double d5 = entityplayer1.getDistanceSq(d, d1, d2);
            if ((d3 < 0.0 || d5 < d3 * d3) && (d4 == -1.0 || d5 < d4)) {
                d4 = d5;
                entityplayer = entityplayer1;
            }
            ++i;
        }
        return entityplayer;
    }

    public EntityPlayer getPlayerEntityByName(String s) {
        int i = 0;
        while (i < this.playerEntities.size()) {
            if (s.equals(((EntityPlayer)this.playerEntities.get((int)i)).username)) {
                return (EntityPlayer)this.playerEntities.get(i);
            }
            ++i;
        }
        return null;
    }

    public byte[] getChunkData(int i, int j, int k, int l, int i1, int j1) {
        byte[] abyte0 = new byte[l * i1 * j1 * 5 / 2];
        int k1 = i >> 4;
        int l1 = k >> 4;
        int i2 = i + l - 1 >> 4;
        int j2 = k + j1 - 1 >> 4;
        int k2 = 0;
        int l2 = j;
        int i3 = j + i1;
        if (l2 < 0) {
            l2 = 0;
        }
        if (i3 > 128) {
            i3 = 128;
        }
        int j3 = k1;
        while (j3 <= i2) {
            int k3 = i - j3 * 16;
            int l3 = i + l - j3 * 16;
            if (k3 < 0) {
                k3 = 0;
            }
            if (l3 > 16) {
                l3 = 16;
            }
            int i4 = l1;
            while (i4 <= j2) {
                int j4 = k - i4 * 16;
                int k4 = k + j1 - i4 * 16;
                if (j4 < 0) {
                    j4 = 0;
                }
                if (k4 > 16) {
                    k4 = 16;
                }
                k2 = this.getChunkFromChunkCoords(j3, i4).getChunkData(abyte0, k3, l2, j4, l3, i3, k4, k2);
                ++i4;
            }
            ++j3;
        }
        return abyte0;
    }

    public void checkSessionLock() {
        this.worldFile.func_22091_b();
    }

    public void setWorldTime(long l) {
        this.worldInfo.setWorldTime(l);
    }

    public void func_32005_b(long l) {
        long l1 = l - this.worldInfo.getWorldTime();
        for (NextTickListEntry nextticklistentry : this.scheduledTickSet) {
            nextticklistentry.scheduledTime += l1;
        }
        this.setWorldTime(l);
    }

    public long getRandomSeed() {
        return this.worldInfo.getRandomSeed();
    }

    public long getWorldTime() {
        return this.worldInfo.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.worldInfo.getSpawnX(), this.worldInfo.getSpawnY(), this.worldInfo.getSpawnZ());
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        return true;
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entity, byte byte0) {
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void playNoteAt(int i, int j, int k, int l, int i1) {
        int j1 = this.getBlockId(i, j, k);
        if (j1 > 0) {
            Block.allBlocks[j1].playBlock(this, i, j, k, l, i1);
        }
    }

    public ISaveHandler getWorldFile() {
        return this.worldFile;
    }

    public WorldInfo getWorldInfo() {
        return this.worldInfo;
    }

    public void updateAllPlayersSleepingFlag() {
        this.allPlayersSleeping = !this.playerEntities.isEmpty();
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (entityplayer.func_22057_E()) continue;
            this.allPlayersSleeping = false;
            break;
        }
    }

    protected void wakeUpAllPlayers() {
        this.allPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (!entityplayer.func_22057_E()) continue;
            entityplayer.wakeUpPlayer(false, false, true);
        }
        this.clearWeather();
    }

    public boolean isAllPlayersFullyAsleep() {
        if (this.allPlayersSleeping && !this.singleplayerWorld) {
            for (EntityPlayer entityplayer : this.playerEntities) {
                if (entityplayer.isPlayerFullyAsleep()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public float func_27065_c(float f) {
        return (this.field_27077_D + (this.field_27076_E - this.field_27077_D) * f) * this.func_27074_d(f);
    }

    public float func_27074_d(float f) {
        return this.field_27079_B + (this.field_27078_C - this.field_27079_B) * f;
    }

    public boolean func_27067_u() {
        return (double)this.func_27065_c(1.0f) > 0.9;
    }

    public boolean func_27068_v() {
        return (double)this.func_27074_d(1.0f) > 0.2;
    }

    public boolean canLightningStrikeAt(int i, int j, int k) {
        if (!this.func_27068_v()) {
            return false;
        }
        if (!this.canBlockSeeTheSky(i, j, k)) {
            return false;
        }
        if (this.getTopSolidOrLiquidBlock(i, k) > j) {
            return false;
        }
        BiomeGenBase biomegenbase = this.getWorldChunkManager().getBiomeGenAt(i, k);
        if (biomegenbase.getEnableSnow()) {
            return false;
        }
        return biomegenbase.canSpawnLightningBolt();
    }

    public void func_28102_a(String s, MapDataBase mapdatabase) {
        this.field_28105_z.func_28177_a(s, mapdatabase);
    }

    public MapDataBase func_28103_a(Class class1, String s) {
        return this.field_28105_z.func_28178_a(class1, s);
    }

    public int func_28104_b(String s) {
        return this.field_28105_z.func_28173_a(s);
    }

    public void func_28097_e(int i, int j, int k, int l, int i1) {
        this.sendDoorChangeState(null, i, j, k, l, i1);
    }

    public void sendDoorChangeState(EntityPlayer entityplayer, int i, int j, int k, int l, int i1) {
        int j1 = 0;
        while (j1 < this.worldAccesses.size()) {
            ((IWorldAccess)this.worldAccesses.get(j1)).sendDoorChange(entityplayer, i, j, k, l, i1);
            ++j1;
        }
    }

    public EnumSeason getCurrentSeason() {
        if (this.season != EnumSeason.cycle) {
            return this.season;
        }
        int timeOfYear = (int)(this.getWorldTime() % (long)(24000 * this.daysInSeason * 4) / (long)(24000 * this.daysInSeason));
        switch (timeOfYear) {
            case 0: {
                return EnumSeason.summer;
            }
            case 1: {
                return EnumSeason.fall;
            }
            case 2: {
                return EnumSeason.winter;
            }
            case 3: {
                return EnumSeason.spring;
            }
        }
        return EnumSeason.summer;
    }

    public EnumSeason getLastSeason() {
        switch (this.getCurrentSeason()) {
            case summer: {
                return EnumSeason.spring;
            }
            case fall: {
                return EnumSeason.summer;
            }
            case winter: {
                return EnumSeason.fall;
            }
            case spring: {
                return EnumSeason.winter;
            }
        }
        return EnumSeason.spring;
    }

    public EnumSeason getNextSeason() {
        switch (this.getCurrentSeason()) {
            case summer: {
                return EnumSeason.fall;
            }
            case fall: {
                return EnumSeason.winter;
            }
            case winter: {
                return EnumSeason.spring;
            }
            case spring: {
                return EnumSeason.summer;
            }
        }
        return EnumSeason.fall;
    }
}

