/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkBlockMap;
import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.level.generate.noise.NibbleArray;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Chunk {
    public static boolean isLit;
    public byte[] blocks;
    public boolean isChunkLoaded;
    public World worldObj;
    public NibbleArray data;
    public NibbleArray skylightMap;
    public NibbleArray blocklightMap;
    public byte[] heightMap;
    public int field_1532_i;
    public final int xPosition;
    public final int zPosition;
    public Map chunkTileEntityMap = new HashMap();
    public List[] entities = new List[8];
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean neverSave;
    public boolean hasEntities = false;
    public long lastSaveTime = 0L;
    public boolean frozen;
    public boolean snowy;

    public Chunk(World world, int i, int j) {
        this.worldObj = world;
        this.xPosition = i;
        this.zPosition = j;
        this.heightMap = new byte[256];
        this.frozen = false;
        this.snowy = false;
        int k = 0;
        while (k < this.entities.length) {
            this.entities[k] = new ArrayList();
            ++k;
        }
    }

    public Chunk(World world, byte[] abyte0, int i, int j) {
        this(world, i, j);
        this.blocks = abyte0;
        this.data = new NibbleArray(abyte0.length);
        this.skylightMap = new NibbleArray(abyte0.length);
        this.blocklightMap = new NibbleArray(abyte0.length);
    }

    public boolean isAtLocation(int i, int j) {
        return i == this.xPosition && j == this.zPosition;
    }

    public int getHeightValue(int i, int j) {
        return this.heightMap[j << 4 | i] & 0xFF;
    }

    public void func_1014_a() {
    }

    public void func_1024_c() {
        int i = 127;
        int j = 0;
        while (j < 16) {
            int l = 0;
            while (l < 16) {
                int j1 = 127;
                int k1 = j << 11 | l << 7;
                while (j1 > 0 && Block.lightOpacity[this.blocks[k1 + j1 - 1] & 0xFF] == 0) {
                    --j1;
                }
                this.heightMap[l << 4 | j] = (byte)j1;
                if (j1 < i) {
                    i = j1;
                }
                if (!this.worldObj.worldProvider.field_4306_c) {
                    int l1 = 15;
                    int i2 = 127;
                    do {
                        if ((l1 -= Block.lightOpacity[this.blocks[k1 + i2] & 0xFF]) <= 0) continue;
                        this.skylightMap.setNibble(j, i2, l, l1);
                    } while (--i2 > 0 && l1 > 0);
                }
                ++l;
            }
            ++j;
        }
        this.field_1532_i = i;
        int k = 0;
        while (k < 16) {
            int i1 = 0;
            while (i1 < 16) {
                this.func_996_c(k, i1);
                ++i1;
            }
            ++k;
        }
        this.isModified = true;
    }

    public void func_4053_c() {
    }

    private void func_996_c(int i, int j) {
        int k = this.getHeightValue(i, j);
        int l = this.xPosition * 16 + i;
        int i1 = this.zPosition * 16 + j;
        this.func_1020_f(l - 1, i1, k);
        this.func_1020_f(l + 1, i1, k);
        this.func_1020_f(l, i1 - 1, k);
        this.func_1020_f(l, i1 + 1, k);
    }

    private void func_1020_f(int i, int j, int k) {
        int l = this.worldObj.getHeightValue(i, j);
        if (l > k) {
            this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, i, k, j, i, l, j);
            this.isModified = true;
        } else if (l < k) {
            this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, i, l, j, i, k, j);
            this.isModified = true;
        }
    }

    private void func_1003_g(int i, int j, int k) {
        int l;
        int i1 = l = this.heightMap[k << 4 | i] & 0xFF;
        if (j > l) {
            i1 = j;
        }
        int j1 = i << 11 | k << 7;
        while (i1 > 0 && Block.lightOpacity[this.blocks[j1 + i1 - 1] & 0xFF] == 0) {
            --i1;
        }
        if (i1 == l) {
            return;
        }
        this.worldObj.markBlocksDirtyVertical(i, k, i1, l);
        this.heightMap[k << 4 | i] = (byte)i1;
        if (i1 < this.field_1532_i) {
            this.field_1532_i = i1;
        } else {
            int k1 = 127;
            int i2 = 0;
            while (i2 < 16) {
                int k2 = 0;
                while (k2 < 16) {
                    if ((this.heightMap[k2 << 4 | i2] & 0xFF) < k1) {
                        k1 = this.heightMap[k2 << 4 | i2] & 0xFF;
                    }
                    ++k2;
                }
                ++i2;
            }
            this.field_1532_i = k1;
        }
        int l1 = this.xPosition * 16 + i;
        int j2 = this.zPosition * 16 + k;
        if (i1 < l) {
            int l2 = i1;
            while (l2 < l) {
                this.skylightMap.setNibble(i, l2, k, 15);
                ++l2;
            }
        } else {
            this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, l1, l, j2, l1, i1, j2);
            int i3 = l;
            while (i3 < i1) {
                this.skylightMap.setNibble(i, i3, k, 0);
                ++i3;
            }
        }
        int j3 = 15;
        int k3 = i1;
        while (i1 > 0 && j3 > 0) {
            int l3;
            if ((l3 = Block.lightOpacity[this.getBlockId(i, --i1, k)]) == 0) {
                l3 = 1;
            }
            if ((j3 -= l3) < 0) {
                j3 = 0;
            }
            this.skylightMap.setNibble(i, i1, k, j3);
        }
        while (i1 > 0 && Block.lightOpacity[this.getBlockId(i, i1 - 1, k)] == 0) {
            --i1;
        }
        if (i1 != k3) {
            this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, l1 - 1, i1, j2 - 1, l1 + 1, k3, j2 + 1);
        }
        this.isModified = true;
    }

    public int getBlockId(int i, int j, int k) {
        return this.blocks[i << 11 | k << 7 | j] & 0xFF;
    }

    public boolean setBlockIDWithMetadata(int i, int j, int k, int l, int i1) {
        byte byte0 = (byte)l;
        int j1 = this.heightMap[k << 4 | i] & 0xFF;
        int k1 = this.blocks[i << 11 | k << 7 | j] & 0xFF;
        if (k1 == l && this.data.getNibble(i, j, k) == i1) {
            return false;
        }
        int l1 = this.xPosition * 16 + i;
        int i2 = this.zPosition * 16 + k;
        this.blocks[i << 11 | k << 7 | j] = (byte)(byte0 & 0xFF);
        if (k1 != 0 && !this.worldObj.singleplayerWorld) {
            Block.allBlocks[k1].onBlockRemoval(this.worldObj, l1, j, i2);
        }
        this.data.setNibble(i, j, k, i1);
        if (!this.worldObj.worldProvider.field_4306_c) {
            if (Block.lightOpacity[byte0 & 0xFF] != 0) {
                if (j >= j1) {
                    this.func_1003_g(i, j + 1, k);
                }
            } else if (j == j1 - 1) {
                this.func_1003_g(i, j, k);
            }
            this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, l1, j, i2, l1, j, i2);
        }
        this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Block, l1, j, i2, l1, j, i2);
        this.func_996_c(i, k);
        this.data.setNibble(i, j, k, i1);
        if (l != 0) {
            Block.allBlocks[l].onBlockAdded(this.worldObj, l1, j, i2);
        }
        this.isModified = true;
        return true;
    }

    public boolean setBlockID(int i, int j, int k, int l) {
        byte byte0 = (byte)l;
        int i1 = this.heightMap[k << 4 | i] & 0xFF;
        int j1 = this.blocks[i << 11 | k << 7 | j] & 0xFF;
        if (j1 == l) {
            return false;
        }
        int k1 = this.xPosition * 16 + i;
        int l1 = this.zPosition * 16 + k;
        this.blocks[i << 11 | k << 7 | j] = (byte)(byte0 & 0xFF);
        if (j1 != 0) {
            Block.allBlocks[j1].onBlockRemoval(this.worldObj, k1, j, l1);
        }
        this.data.setNibble(i, j, k, 0);
        if (Block.lightOpacity[byte0 & 0xFF] != 0) {
            if (j >= i1) {
                this.func_1003_g(i, j + 1, k);
            }
        } else if (j == i1 - 1) {
            this.func_1003_g(i, j, k);
        }
        this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Sky, k1, j, l1, k1, j, l1);
        this.worldObj.scheduleLightingUpdate(EnumSkyBlock.Block, k1, j, l1, k1, j, l1);
        this.func_996_c(i, k);
        if (l != 0 && !this.worldObj.singleplayerWorld) {
            Block.allBlocks[l].onBlockAdded(this.worldObj, k1, j, l1);
        }
        this.isModified = true;
        return true;
    }

    public int getBlockMetadata(int i, int j, int k) {
        return this.data.getNibble(i, j, k);
    }

    public void setBlockMetadata(int i, int j, int k, int l) {
        this.isModified = true;
        this.data.setNibble(i, j, k, l);
    }

    public int getSavedLightValue(EnumSkyBlock enumskyblock, int i, int j, int k) {
        if (enumskyblock == EnumSkyBlock.Sky) {
            return this.skylightMap.getNibble(i, j, k);
        }
        if (enumskyblock == EnumSkyBlock.Block) {
            return this.blocklightMap.getNibble(i, j, k);
        }
        return 0;
    }

    public void setLightValue(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        this.isModified = true;
        if (enumskyblock == EnumSkyBlock.Sky) {
            this.skylightMap.setNibble(i, j, k, l);
        } else if (enumskyblock == EnumSkyBlock.Block) {
            this.blocklightMap.setNibble(i, j, k, l);
        } else {
            return;
        }
    }

    public int getBlockLightValue(int i, int j, int k, int l) {
        int j1;
        int i1 = this.skylightMap.getNibble(i, j, k);
        if (i1 > 0) {
            isLit = true;
        }
        if ((j1 = this.blocklightMap.getNibble(i, j, k)) > (i1 -= l)) {
            i1 = j1;
        }
        return i1;
    }

    public void addEntity(Entity entity) {
        int k;
        this.hasEntities = true;
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        if (i != this.xPosition || j != this.zPosition) {
            System.out.println("Wrong location! " + entity);
            Thread.dumpStack();
        }
        if ((k = MathHelper.floor_double(entity.posY / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.entities.length) {
            k = this.entities.length - 1;
        }
        entity.addedToChunk = true;
        entity.chunkCoordX = this.xPosition;
        entity.chunkCoordY = k;
        entity.chunkCoordZ = this.zPosition;
        this.entities[k].add(entity);
    }

    public void removeEntity(Entity entity) {
        this.removeEntityAtIndex(entity, entity.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity entity, int i) {
        if (i < 0) {
            i = 0;
        }
        if (i >= this.entities.length) {
            i = this.entities.length - 1;
        }
        this.entities[i].remove(entity);
    }

    public boolean canBlockSeeTheSky(int i, int j, int k) {
        return j >= (this.heightMap[k << 4 | i] & 0xFF);
    }

    public TileEntity getChunkBlockTileEntity(int i, int j, int k) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        TileEntity tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        if (tileentity == null) {
            int l = this.getBlockId(i, j, k);
            if (!Block.isBlockContainer[l]) {
                return null;
            }
            BlockContainer blockcontainer = (BlockContainer)Block.allBlocks[l];
            blockcontainer.onBlockAdded(this.worldObj, this.xPosition * 16 + i, j, this.zPosition * 16 + k);
            tileentity = (TileEntity)this.chunkTileEntityMap.get(chunkposition);
        }
        if (tileentity != null && tileentity.isInvalid()) {
            this.chunkTileEntityMap.remove(chunkposition);
            return null;
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity tileentity) {
        int i = tileentity.xCoord - this.xPosition * 16;
        int j = tileentity.yCoord;
        int k = tileentity.zCoord - this.zPosition * 16;
        this.setChunkBlockTileEntity(i, j, k, tileentity);
        if (this.isChunkLoaded) {
            this.worldObj.loadedTileEntityList.add(tileentity);
        }
    }

    public void setChunkBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        tileentity.worldObj = this.worldObj;
        tileentity.xCoord = this.xPosition * 16 + i;
        tileentity.yCoord = j;
        tileentity.zCoord = this.zPosition * 16 + k;
        if (this.getBlockId(i, j, k) == 0 || !(Block.allBlocks[this.getBlockId(i, j, k)] instanceof BlockContainer)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        tileentity.validate();
        this.chunkTileEntityMap.put(chunkposition, tileentity);
    }

    public void removeChunkBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        if (this.isChunkLoaded && (tileentity = (TileEntity)this.chunkTileEntityMap.remove(chunkposition)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.worldObj.func_31047_a(this.chunkTileEntityMap.values());
        int i = 0;
        while (i < this.entities.length) {
            this.worldObj.addLoadedEntities(this.entities[i]);
            ++i;
        }
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            tileentity.invalidate();
        }
        int i = 0;
        while (i < this.entities.length) {
            this.worldObj.addUnloadedEntities(this.entities[i]);
            ++i;
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity entity, AxisAlignedBB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        int k = i;
        while (k <= j) {
            List list1 = this.entities[k];
            int l = 0;
            while (l < list1.size()) {
                Entity entity1 = (Entity)list1.get(l);
                if (entity1 != entity && entity1.boundingBox.intersectsWith(axisalignedbb)) {
                    list.add(entity1);
                }
                ++l;
            }
            ++k;
        }
    }

    public void getEntitiesOfTypeWithinAAAB(Class class1, AxisAlignedBB axisalignedbb, List list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxY + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.entities.length) {
            j = this.entities.length - 1;
        }
        int k = i;
        while (k <= j) {
            List list1 = this.entities[k];
            int l = 0;
            while (l < list1.size()) {
                Entity entity = (Entity)list1.get(l);
                if (class1.isAssignableFrom(entity.getClass()) && entity.boundingBox.intersectsWith(axisalignedbb)) {
                    list.add(entity);
                }
                ++l;
            }
            ++k;
        }
    }

    public boolean needsSaving(boolean flag) {
        if (this.neverSave) {
            return false;
        }
        if (flag ? this.hasEntities && this.worldObj.getWorldTime() != this.lastSaveTime : this.hasEntities && this.worldObj.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public int getChunkData(byte[] abyte0, int i, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = l - i;
        int i2 = i1 - j;
        int j2 = j1 - k;
        if (l1 * i2 * j2 == this.blocks.length) {
            System.arraycopy(this.blocks, 0, abyte0, k1, this.blocks.length);
            System.arraycopy(this.data.data, 0, abyte0, k1 += this.blocks.length, this.data.data.length);
            System.arraycopy(this.blocklightMap.data, 0, abyte0, k1 += this.data.data.length, this.blocklightMap.data.length);
            System.arraycopy(this.skylightMap.data, 0, abyte0, k1 += this.blocklightMap.data.length, this.skylightMap.data.length);
            return k1 += this.skylightMap.data.length;
        }
        int k2 = i;
        while (k2 < l) {
            int k3 = k;
            while (k3 < j1) {
                int k4 = k2 << 11 | k3 << 7 | j;
                int k5 = i1 - j;
                System.arraycopy(this.blocks, k4, abyte0, k1, k5);
                k1 += k5;
                ++k3;
            }
            ++k2;
        }
        int l2 = i;
        while (l2 < l) {
            int l3 = k;
            while (l3 < j1) {
                int l4 = (l2 << 11 | l3 << 7 | j) >> 1;
                int l5 = (i1 - j) / 2;
                System.arraycopy(this.data.data, l4, abyte0, k1, l5);
                k1 += l5;
                ++l3;
            }
            ++l2;
        }
        int i3 = i;
        while (i3 < l) {
            int i4 = k;
            while (i4 < j1) {
                int i5 = (i3 << 11 | i4 << 7 | j) >> 1;
                int i6 = (i1 - j) / 2;
                System.arraycopy(this.blocklightMap.data, i5, abyte0, k1, i6);
                k1 += i6;
                ++i4;
            }
            ++i3;
        }
        int j3 = i;
        while (j3 < l) {
            int j4 = k;
            while (j4 < j1) {
                int j5 = (j3 << 11 | j4 << 7 | j) >> 1;
                int j6 = (i1 - j) / 2;
                System.arraycopy(this.skylightMap.data, j5, abyte0, k1, j6);
                k1 += j6;
                ++j4;
            }
            ++j3;
        }
        return k1;
    }

    public Random func_334_a(long l) {
        return new Random(this.worldObj.getRandomSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ l);
    }

    public boolean func_21101_g() {
        return false;
    }

    public void func_25083_h() {
        ChunkBlockMap.func_26001_a(this.blocks);
    }

    public void setFrozen(boolean flag) {
        int chunkX = this.xPosition << 4;
        int chunkZ = this.zPosition << 4;
        int x = 0;
        while (x < 16) {
            int z = 0;
            while (z < 16) {
                int j4 = this.worldObj.getTopSolidOrLiquidBlock(x + chunkX, z + chunkZ);
                if (j4 >= 0 && j4 < 128 && this.getSavedLightValue(EnumSkyBlock.Block, x, j4, z) < 10) {
                    int i5 = this.getBlockId(x, j4 - 1, z);
                    if (!flag && i5 == Block.ice.blockID && this.getBlockMetadata(x, j4 - 1, z) == 0) {
                        this.worldObj.setBlock(x + chunkX, j4 - 1, z + chunkZ, Block.waterStill.blockID);
                    }
                    if (flag && (i5 == Block.waterStill.blockID || i5 == Block.waterMoving.blockID) && this.getBlockMetadata(x, j4 - 1, z) == 0) {
                        this.worldObj.setBlock(x + chunkX, j4 - 1, z + chunkZ, Block.ice.blockID);
                    }
                }
                ++z;
            }
            ++x;
        }
        this.frozen = flag;
    }

    public void setSnowy(boolean flag) {
        int chunkX = this.xPosition << 4;
        int chunkZ = this.zPosition << 4;
        int x = 0;
        while (x < 16) {
            int z = 0;
            while (z < 16) {
                int j4 = this.worldObj.getTopSolidOrLiquidBlock(x + chunkX, z + chunkZ);
                if (j4 >= 0 && j4 < 128 && this.getSavedLightValue(EnumSkyBlock.Block, x, j4, z) < 10) {
                    int i5 = this.getBlockId(x, j4, z);
                    if (flag && i5 == 0 && Block.snow.canPlaceSnowy(this.worldObj, x + chunkX, j4, z + chunkZ)) {
                        this.worldObj.setBlock(x + chunkX, j4, z + chunkZ, Block.snow.blockID);
                    }
                    if (!flag && i5 == Block.snow.blockID) {
                        this.worldObj.setBlock(x + chunkX, j4, z + chunkZ, 0);
                    }
                }
                ++z;
            }
            ++x;
        }
        this.snowy = flag;
    }
}

