/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ChunkCache
implements IBlockAccess {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private World worldObj;

    public ChunkCache(World world, int i, int j, int k, int l, int i1, int j1) {
        this.worldObj = world;
        this.chunkX = i >> 4;
        this.chunkZ = k >> 4;
        int k1 = l >> 4;
        int l1 = j1 >> 4;
        this.chunkArray = new Chunk[k1 - this.chunkX + 1][l1 - this.chunkZ + 1];
        int i2 = this.chunkX;
        while (i2 <= k1) {
            int j2 = this.chunkZ;
            while (j2 <= l1) {
                this.chunkArray[i2 - this.chunkX][j2 - this.chunkZ] = world.getChunkFromChunkCoords(i2, j2);
                ++j2;
            }
            ++i2;
        }
    }

    public int getBlockId(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        if (l < 0 || l >= this.chunkArray.length || i1 < 0 || i1 >= this.chunkArray[l].length) {
            return 0;
        }
        Chunk chunk = this.chunkArray[l][i1];
        if (chunk == null) {
            return 0;
        }
        return chunk.getBlockId(i & 0xF, j, k & 0xF);
    }

    public TileEntity getBlockTileEntity(int i, int j, int k) {
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[l][i1].getChunkBlockTileEntity(i & 0xF, j, k & 0xF);
    }

    public int getBlockMetadata(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        int l = (i >> 4) - this.chunkX;
        int i1 = (k >> 4) - this.chunkZ;
        return this.chunkArray[l][i1].getBlockMetadata(i & 0xF, j, k & 0xF);
    }

    public Material getMaterialXYZ(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        if (l == 0) {
            return Material.air;
        }
        return Block.allBlocks[l].blockMaterial;
    }

    public boolean isBlockNormalCube(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.blocksMovement() && block.isACube();
    }
}

