/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.noise.NibbleArray;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.server.WorldInfo;
import com.mojang.minecraft.util.CompressedStreamTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ChunkLoader
implements IChunkLoader {
    private File saveDir;
    private boolean createIfNecessary;

    public ChunkLoader(File file, boolean flag) {
        this.saveDir = file;
        this.createIfNecessary = flag;
    }

    private File chunkFileForXZ(int i, int j) {
        String s = "c." + Integer.toString(i, 36) + "." + Integer.toString(j, 36) + ".dat";
        String s1 = Integer.toString(i & 0x3F, 36);
        String s2 = Integer.toString(j & 0x3F, 36);
        File file = new File(this.saveDir, s1);
        if (!file.exists()) {
            if (this.createIfNecessary) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, s2)).exists()) {
            if (this.createIfNecessary) {
                file.mkdir();
            } else {
                return null;
            }
        }
        if (!(file = new File(file, s)).exists() && !this.createIfNecessary) {
            return null;
        }
        return file;
    }

    public Chunk loadChunk(World world, int i, int j) throws IOException {
        File file = this.chunkFileForXZ(i, j);
        if (file != null && file.exists()) {
            NBTTagCompound nbttagcompound;
            block7: {
                block6: {
                    FileInputStream fileinputstream = new FileInputStream(file);
                    nbttagcompound = CompressedStreamTools.func_1138_a(fileinputstream);
                    if (nbttagcompound.hasKey("Level")) break block6;
                    System.out.println("Chunk file at " + i + "," + j + " is missing level data, skipping");
                    return null;
                }
                if (nbttagcompound.getCompoundTag("Level").hasKey("Blocks")) break block7;
                System.out.println("Chunk file at " + i + "," + j + " is missing block data, skipping");
                return null;
            }
            try {
                Chunk chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbttagcompound.getCompoundTag("Level"));
                if (!chunk.isAtLocation(i, j)) {
                    System.out.println("Chunk file at " + i + "," + j + " is in the wrong location; relocating. (Expected " + i + ", " + j + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
                    nbttagcompound.setInteger("xPos", i);
                    nbttagcompound.setInteger("zPos", j);
                    chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbttagcompound.getCompoundTag("Level"));
                }
                chunk.func_25083_h();
                return chunk;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void saveChunk(World world, Chunk chunk) throws IOException {
        world.checkSessionLock();
        File file = this.chunkFileForXZ(chunk.xPosition, chunk.zPosition);
        if (file.exists()) {
            WorldInfo worldinfo = world.getWorldInfo();
            worldinfo.setSizeOnDisk(worldinfo.getSizeOnDisk() - file.length());
        }
        try {
            File file1 = new File(this.saveDir, "tmp_chunk.dat");
            FileOutputStream fileoutputstream = new FileOutputStream(file1);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.setTag("Level", nbttagcompound1);
            ChunkLoader.storeChunkInCompound(chunk, world, nbttagcompound1);
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound, fileoutputstream);
            fileoutputstream.close();
            if (file.exists()) {
                file.delete();
            }
            file1.renameTo(file);
            WorldInfo worldinfo1 = world.getWorldInfo();
            worldinfo1.setSizeOnDisk(worldinfo1.getSizeOnDisk() + file.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void storeChunkInCompound(Chunk chunk, World world, NBTTagCompound nbttagcompound) {
        world.checkSessionLock();
        nbttagcompound.setInteger("xPos", chunk.xPosition);
        nbttagcompound.setInteger("zPos", chunk.zPosition);
        nbttagcompound.setLong("LastUpdate", world.getWorldTime());
        nbttagcompound.setByteArray("Blocks", chunk.blocks);
        nbttagcompound.setByteArray("Data", chunk.data.data);
        nbttagcompound.setByteArray("SkyLight", chunk.skylightMap.data);
        nbttagcompound.setByteArray("BlockLight", chunk.blocklightMap.data);
        nbttagcompound.setByteArray("HeightMap", chunk.heightMap);
        nbttagcompound.setBoolean("TerrainPopulated", chunk.isTerrainPopulated);
        nbttagcompound.setBoolean("Frozen", chunk.frozen);
        nbttagcompound.setBoolean("Snowy", chunk.snowy);
        chunk.hasEntities = false;
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < chunk.entities.length) {
            for (Entity entity : chunk.entities[i]) {
                chunk.hasEntities = true;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                if (!entity.addEntityID(nbttagcompound1)) continue;
                nbttaglist.setTag(nbttagcompound1);
            }
            ++i;
        }
        nbttagcompound.setTag("Entities", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (TileEntity tileentity : chunk.chunkTileEntityMap.values()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            tileentity.writeToNBT(nbttagcompound2);
            nbttaglist1.setTag(nbttagcompound2);
        }
        nbttagcompound.setTag("TileEntities", nbttaglist1);
    }

    public static Chunk loadChunkIntoWorldFromCompound(World world, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist1;
        NBTTagList nbttaglist;
        int i = nbttagcompound.getInteger("xPos");
        int j = nbttagcompound.getInteger("zPos");
        Chunk chunk = new Chunk(world, i, j);
        chunk.blocks = nbttagcompound.getByteArray("Blocks");
        chunk.data = new NibbleArray(nbttagcompound.getByteArray("Data"));
        chunk.skylightMap = new NibbleArray(nbttagcompound.getByteArray("SkyLight"));
        chunk.blocklightMap = new NibbleArray(nbttagcompound.getByteArray("BlockLight"));
        chunk.heightMap = nbttagcompound.getByteArray("HeightMap");
        chunk.isTerrainPopulated = nbttagcompound.getBoolean("TerrainPopulated");
        chunk.frozen = nbttagcompound.getBoolean("Frozen");
        chunk.snowy = nbttagcompound.getBoolean("Snowy");
        if (!chunk.data.isValid()) {
            chunk.data = new NibbleArray(chunk.blocks.length);
        }
        if (chunk.heightMap == null || !chunk.skylightMap.isValid()) {
            chunk.heightMap = new byte[256];
            chunk.skylightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1024_c();
        }
        if (!chunk.blocklightMap.isValid()) {
            chunk.blocklightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1014_a();
        }
        if ((nbttaglist = nbttagcompound.getTagList("Entities")) != null) {
            int k = 0;
            while (k < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(k);
                Entity entity = EntityList.createEntityFromNBT(nbttagcompound1, world);
                chunk.hasEntities = true;
                if (entity != null) {
                    chunk.addEntity(entity);
                }
                ++k;
            }
        }
        if ((nbttaglist1 = nbttagcompound.getTagList("TileEntities")) != null) {
            int l = 0;
            while (l < nbttaglist1.tagCount()) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist1.tagAt(l);
                TileEntity tileentity = TileEntity.createAndLoadEntity(nbttagcompound2);
                if (tileentity != null) {
                    chunk.addTileEntity(tileentity);
                }
                ++l;
            }
        }
        return chunk;
    }

    public void func_814_a() {
    }

    public void saveExtraData() {
    }

    public void saveExtraChunkData(World world, Chunk chunk) throws IOException {
    }
}

