/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.server.EmptyChunk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChunkProvider
implements IChunkProvider {
    private Set field_28062_a = new HashSet();
    private Chunk field_28061_b;
    private IChunkProvider chunkGenerator;
    private IChunkLoader field_28066_d;
    private Map field_28065_e = new HashMap();
    private List field_28064_f = new ArrayList();
    private World worldObj;

    public ChunkProvider(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.field_28061_b = new EmptyChunk(world, new byte[32768], 0, 0);
        this.worldObj = world;
        this.field_28066_d = ichunkloader;
        this.chunkGenerator = ichunkprovider;
    }

    public boolean chunkExists(int i, int j) {
        return this.field_28065_e.containsKey(ChunkCoordIntPair.chunkXZ2Int(i, j));
    }

    public Chunk loadChunk(int i, int j) {
        int k = ChunkCoordIntPair.chunkXZ2Int(i, j);
        this.field_28062_a.remove(k);
        Chunk chunk = (Chunk)this.field_28065_e.get(k);
        if (chunk == null) {
            chunk = this.func_28058_d(i, j);
            if (chunk == null) {
                chunk = this.chunkGenerator == null ? this.field_28061_b : this.chunkGenerator.provideChunk(i, j);
            }
            this.field_28065_e.put(k, chunk);
            this.field_28064_f.add(chunk);
            if (chunk != null) {
                chunk.func_4053_c();
                chunk.onChunkLoad();
            }
            if (!chunk.isTerrainPopulated && this.chunkExists(i + 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j);
            }
            if (this.chunkExists(i - 1, j) && !this.provideChunk((int)(i - 1), (int)j).isTerrainPopulated && this.chunkExists(i - 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j);
            }
            if (this.chunkExists(i, j - 1) && !this.provideChunk((int)i, (int)(j - 1)).isTerrainPopulated && this.chunkExists(i + 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j - 1);
            }
            if (this.chunkExists(i - 1, j - 1) && !this.provideChunk((int)(i - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(i - 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j - 1);
            }
        }
        return chunk;
    }

    public Chunk provideChunk(int i, int j) {
        Chunk chunk = (Chunk)this.field_28065_e.get(ChunkCoordIntPair.chunkXZ2Int(i, j));
        if (chunk == null) {
            return this.loadChunk(i, j);
        }
        return chunk;
    }

    private Chunk func_28058_d(int i, int j) {
        if (this.field_28066_d == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_28066_d.loadChunk(this.worldObj, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_28060_a(Chunk chunk) {
        if (this.field_28066_d == null) {
            return;
        }
        try {
            this.field_28066_d.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_28059_b(Chunk chunk) {
        if (this.field_28066_d == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.field_28066_d.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.generateStructures(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        int j = 0;
        while (j < this.field_28064_f.size()) {
            Chunk chunk = (Chunk)this.field_28064_f.get(j);
            if (flag && !chunk.neverSave) {
                this.func_28060_a(chunk);
            }
            if (chunk.needsSaving(flag)) {
                this.func_28059_b(chunk);
                chunk.isModified = false;
                if (++i == 24 && !flag) {
                    return false;
                }
            }
            ++j;
        }
        if (flag) {
            if (this.field_28066_d == null) {
                return true;
            }
            this.field_28066_d.saveExtraData();
        }
        return true;
    }

    public boolean unload100OldestChunks() {
        int i = 0;
        while (i < 100) {
            if (!this.field_28062_a.isEmpty()) {
                Integer integer = (Integer)this.field_28062_a.iterator().next();
                Chunk chunk = (Chunk)this.field_28065_e.get(integer);
                chunk.onChunkUnload();
                this.func_28059_b(chunk);
                this.func_28060_a(chunk);
                this.field_28062_a.remove(integer);
                this.field_28065_e.remove(integer);
                this.field_28064_f.remove(chunk);
            }
            ++i;
        }
        if (this.field_28066_d != null) {
            this.field_28066_d.func_814_a();
        }
        return this.chunkGenerator.unload100OldestChunks();
    }

    public boolean canSave() {
        return true;
    }
}

