/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.generate.MapGenBase;
import com.mojang.minecraft.level.generate.MapGenCaves;
import com.mojang.minecraft.level.generate.WorldGenCactus;
import com.mojang.minecraft.level.generate.WorldGenClay;
import com.mojang.minecraft.level.generate.WorldGenDungeons;
import com.mojang.minecraft.level.generate.WorldGenFlowers;
import com.mojang.minecraft.level.generate.WorldGenLakes;
import com.mojang.minecraft.level.generate.WorldGenLiquids;
import com.mojang.minecraft.level.generate.WorldGenMinable;
import com.mojang.minecraft.level.generate.WorldGenPumpkin;
import com.mojang.minecraft.level.generate.WorldGenReed;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.generate.noise.NoiseGeneratorOctaves;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.server.BiomeGenBase;
import java.util.Random;

public class ChunkProviderGenerateBeta
implements IChunkProvider {
    protected Random genRandom;
    protected NoiseGeneratorOctaves noiseGen1;
    protected NoiseGeneratorOctaves noiseGen2;
    protected NoiseGeneratorOctaves noiseGen3;
    protected NoiseGeneratorOctaves beachNoise;
    protected NoiseGeneratorOctaves soilNoise;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves noiseGen7;
    public NoiseGeneratorOctaves treeNoise;
    protected World worldObj;
    protected double[] densities;
    protected double[] sandBeachNoise = new double[256];
    protected double[] gravelBeachNoise = new double[256];
    protected double[] soilThicknessNoise = new double[256];
    protected MapGenBase mapGenBase = new MapGenCaves();
    protected BiomeGenBase[] biomesForGeneration;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    int[][] blockArray = new int[32][32];
    private double[] generatedTemperatures;

    public ChunkProviderGenerateBeta(World world, long l) {
        this.worldObj = world;
        this.genRandom = new Random(l);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.genRandom, 8);
        this.beachNoise = new NoiseGeneratorOctaves(this.genRandom, 4);
        this.soilNoise = new NoiseGeneratorOctaves(this.genRandom, 4);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.genRandom, 10);
        this.noiseGen7 = new NoiseGeneratorOctaves(this.genRandom, 16);
        this.treeNoise = new NoiseGeneratorOctaves(this.genRandom, 8);
    }

    public void generateTerrain(int i, int j, byte[] abyte0, BiomeGenBase[] abiomegenbase, double[] ad) {
        int byte0 = 4;
        int byte1 = 64;
        int k = byte0 + 1;
        int byte2 = 17;
        int l = byte0 + 1;
        this.densities = this.initializeNoiseField(this.densities, i * byte0, 0, j * byte0, k, byte2, l);
        int i1 = 0;
        while (i1 < byte0) {
            int j1 = 0;
            while (j1 < byte0) {
                int k1 = 0;
                while (k1 < 16) {
                    double d = 0.125;
                    double d1 = this.densities[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d2 = this.densities[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.densities[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.densities[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.densities[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d;
                    double d6 = (this.densities[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d2) * d;
                    double d7 = (this.densities[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d;
                    double d8 = (this.densities[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d;
                    int l1 = 0;
                    while (l1 < 8) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int i2 = 0;
                        while (i2 < 4) {
                            int j2 = i2 + i1 * 4 << 11 | 0 + j1 * 4 << 7 | k1 * 8 + l1;
                            int c = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            int k2 = 0;
                            while (k2 < 4) {
                                double d17 = ad[(i1 * 4 + i2) * 16 + (j1 * 4 + k2)];
                                int l2 = 0;
                                if (k1 * 8 + l1 < byte1) {
                                    l2 = d17 < 0.5 && k1 * 8 + l1 >= byte1 - 1 ? Block.ice.blockID : Block.waterStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                abyte0[j2] = (byte)l2;
                                j2 += c;
                                d15 += d16;
                                ++k2;
                            }
                            d10 += d12;
                            d11 += d13;
                            ++i2;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
    }

    public void replaceBlocksForBiome(int i, int j, byte[] abyte0, BiomeGenBase[] abiomegenbase) {
        int byte0 = 64;
        double d = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves(this.sandBeachNoise, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves(this.gravelBeachNoise, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves(this.soilThicknessNoise, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                BiomeGenBase biomegenbase = abiomegenbase[k + l * 16];
                boolean flag = this.sandBeachNoise[k + l * 16] + this.genRandom.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelBeachNoise[k + l * 16] + this.genRandom.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.soilThicknessNoise[k + l * 16] / 3.0 + 3.0 + this.genRandom.nextDouble() * 0.25);
                int j1 = -1;
                byte byte1 = biomegenbase.topBlock;
                byte byte2 = biomegenbase.fillerBlock;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    if (k1 <= 0 + this.genRandom.nextInt(5)) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = abyte0[l1];
                        if (byte3 == 0) {
                            j1 = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    byte1 = 0;
                                    byte2 = (byte)Block.stone.blockID;
                                } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                                    byte1 = biomegenbase.topBlock;
                                    byte2 = biomegenbase.fillerBlock;
                                    if (flag1) {
                                        byte1 = 0;
                                    }
                                    if (flag1) {
                                        byte2 = (byte)Block.gravel.blockID;
                                    }
                                    if (flag) {
                                        byte1 = (byte)Block.sand.blockID;
                                    }
                                    if (flag) {
                                        byte2 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (k1 < byte0 && byte1 == 0) {
                                    byte1 = (byte)Block.waterStill.blockID;
                                }
                                j1 = i1;
                                abyte0[l1] = k1 >= byte0 - 1 ? byte1 : byte2;
                            } else if (j1 > 0) {
                                abyte0[l1] = byte2;
                                if (--j1 == 0 && byte2 == Block.sand.blockID) {
                                    j1 = this.genRandom.nextInt(4);
                                }
                            }
                        }
                    }
                    --k1;
                }
                ++l;
            }
            ++k;
        }
    }

    public Chunk loadChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    public Chunk provideChunk(int i, int j) {
        this.genRandom.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        byte[] abyte0 = new byte[32768];
        Chunk chunk = new Chunk(this.worldObj, abyte0, i, j);
        this.biomesForGeneration = this.worldObj.getWorldChunkManager().loadBlockGeneratorData(this.biomesForGeneration, i * 16, j * 16, 16, 16);
        double[] ad = this.worldObj.getWorldChunkManager().temperature;
        this.generateTerrain(i, j, abyte0, this.biomesForGeneration, ad);
        this.replaceBlocksForBiome(i, j, abyte0, this.biomesForGeneration);
        this.mapGenBase.func_867_a(this, this.worldObj, i, j, abyte0);
        chunk.func_1024_c();
        return chunk;
    }

    protected double[] initializeNoiseField(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 684.412;
        double[] ad1 = this.worldObj.getWorldChunkManager().temperature;
        double[] ad2 = this.worldObj.getWorldChunkManager().humidity;
        this.noiseData4 = this.noiseGen6.func_4103_a(this.noiseData4, i, k, l, j1, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen7.func_4103_a(this.noiseData5, i, k, l, j1, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.generateNoiseOctaves(this.noiseData1, i, j, k, l, i1, j1, d / 80.0, d1 / 160.0, d / 80.0);
        this.noiseData2 = this.noiseGen1.generateNoiseOctaves(this.noiseData2, i, j, k, l, i1, j1, d, d1, d);
        this.noiseData3 = this.noiseGen2.generateNoiseOctaves(this.noiseData3, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        int i2 = 16 / l;
        int j2 = 0;
        while (j2 < l) {
            int k2 = j2 * i2 + i2 / 2;
            int l2 = 0;
            while (l2 < j1) {
                double d6;
                int i3 = l2 * i2 + i2 / 2;
                double d2 = ad1[k2 * 16 + i3];
                double d3 = ad2[k2 * 16 + i3] * d2;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.noiseData4[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.noiseData5[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) < 0.0) {
                    if ((d6 /= 2.0) < -1.0) {
                        d6 = -1.0;
                    }
                    d6 /= 1.4;
                    d6 /= 2.0;
                    d5 = 0.0;
                } else {
                    if (d6 > 1.0) {
                        d6 = 1.0;
                    }
                    d6 /= 8.0;
                }
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)i1 / 16.0;
                double d7 = (double)i1 / 2.0 + d6 * 4.0;
                ++l1;
                int j3 = 0;
                while (j3 < i1) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 12.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= 4.0;
                    }
                    double d10 = this.noiseData2[k1] / 512.0;
                    double d11 = this.noiseData3[k1] / 512.0;
                    double d12 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= d9;
                    if (j3 > i1 - 4) {
                        double d13 = (float)(j3 - (i1 - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d13) + -10.0 * d13;
                    }
                    ad[k1] = d8;
                    ++k1;
                    ++j3;
                }
                ++l2;
            }
            ++j2;
        }
        return ad;
    }

    public boolean chunkExists(int i, int j) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase biomegenbase = this.worldObj.getWorldChunkManager().getBiomeGenAt(k + 16, l + 16);
        this.genRandom.setSeed(this.worldObj.getRandomSeed());
        long l1 = this.genRandom.nextLong() / 2L * 2L + 1L;
        long l2 = this.genRandom.nextLong() / 2L * 2L + 1L;
        this.genRandom.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.getRandomSeed());
        double d = 0.25;
        if (this.genRandom.nextInt(4) == 0) {
            int i1 = k + this.genRandom.nextInt(16) + 8;
            int l4 = this.genRandom.nextInt(128);
            int i8 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLakes(Block.waterStill.blockID).generate(this.worldObj, this.genRandom, i1, l4, i8);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int j1 = k + this.genRandom.nextInt(16) + 8;
            int i5 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int j8 = l + this.genRandom.nextInt(16) + 8;
            if (i5 < 64 || this.genRandom.nextInt(10) == 0) {
                new WorldGenLakes(Block.lavaStill.blockID).generate(this.worldObj, this.genRandom, j1, i5, j8);
            }
        }
        int k1 = 0;
        while (k1 < 8) {
            int j5 = k + this.genRandom.nextInt(16) + 8;
            int k8 = this.genRandom.nextInt(128);
            int j11 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.genRandom, j5, k8, j11);
            ++k1;
        }
        int i2 = 0;
        while (i2 < 10) {
            int k5 = k + this.genRandom.nextInt(16);
            int l8 = this.genRandom.nextInt(128);
            int k11 = l + this.genRandom.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.genRandom, k5, l8, k11);
            ++i2;
        }
        int j2 = 0;
        while (j2 < 20) {
            int l5 = k + this.genRandom.nextInt(16);
            int i9 = this.genRandom.nextInt(128);
            int l11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.genRandom, l5, i9, l11);
            ++j2;
        }
        int k2 = 0;
        while (k2 < 10) {
            int i6 = k + this.genRandom.nextInt(16);
            int j9 = this.genRandom.nextInt(128);
            int i12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.genRandom, i6, j9, i12);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 20) {
            int j6 = k + this.genRandom.nextInt(16);
            int k9 = this.genRandom.nextInt(128);
            int j12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.genRandom, j6, k9, j12);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 20) {
            int k6 = k + this.genRandom.nextInt(16);
            int l9 = this.genRandom.nextInt(64);
            int k12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.genRandom, k6, l9, k12);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 2) {
            int l6 = k + this.genRandom.nextInt(16);
            int i10 = this.genRandom.nextInt(32);
            int l12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.genRandom, l6, i10, l12);
            ++k3;
        }
        int l3 = 0;
        while (l3 < 8) {
            int i7 = k + this.genRandom.nextInt(16);
            int j10 = this.genRandom.nextInt(16);
            int i13 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.worldObj, this.genRandom, i7, j10, i13);
            ++l3;
        }
        int i4 = 0;
        while (i4 < 1) {
            int j7 = k + this.genRandom.nextInt(16);
            int k10 = this.genRandom.nextInt(16);
            int j13 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.genRandom, j7, k10, j13);
            ++i4;
        }
        d = 0.5;
        int k4 = (int)((this.treeNoise.func_806_a((double)k * d, (double)l * d) / 8.0 + this.genRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        int l7 = 0;
        if (this.genRandom.nextInt(10) == 0) {
            ++l7;
        }
        if (biomegenbase == BiomeGenBase.forest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            l7 += k4 + 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.tundra) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            l7 -= 20;
        }
        int i11 = 0;
        while (i11 < l7) {
            int l13 = k + this.genRandom.nextInt(16) + 8;
            int j14 = l + this.genRandom.nextInt(16) + 8;
            WorldGenerator worldgenerator = biomegenbase.getRandomWorldGenForTrees(this.genRandom);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.worldObj, this.genRandom, l13, this.worldObj.getHeightValue(l13, j14), j14);
            ++i11;
        }
        int byte0 = 0;
        if (biomegenbase == BiomeGenBase.forest) {
            byte0 = 2;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            byte0 = 4;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            byte0 = 2;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            byte0 = 3;
        }
        int i14 = 0;
        while (i14 < byte0) {
            int k14 = k + this.genRandom.nextInt(16) + 8;
            int l16 = this.genRandom.nextInt(128);
            int k19 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.genRandom, k14, l16, k19);
            ++i14;
        }
        int byte1 = 0;
        if (biomegenbase == BiomeGenBase.forest) {
            byte1 = 2;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            byte1 = 10;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            byte1 = 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            byte1 = 1;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            byte1 = 10;
        }
        byte1 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            byte1 = 2;
        }
        if (this.genRandom.nextInt(2) == 0) {
            int j15 = k + this.genRandom.nextInt(16) + 8;
            int j17 = this.genRandom.nextInt(128);
            int j20 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.genRandom, j15, j17, j20);
        }
        if (this.genRandom.nextInt(4) == 0) {
            int k15 = k + this.genRandom.nextInt(16) + 8;
            int k17 = this.genRandom.nextInt(128);
            int k20 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.genRandom, k15, k17, k20);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int l15 = k + this.genRandom.nextInt(16) + 8;
            int l17 = this.genRandom.nextInt(128);
            int l20 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.genRandom, l15, l17, l20);
        }
        int i16 = 0;
        while (i16 < 10) {
            int i18 = k + this.genRandom.nextInt(16) + 8;
            int i21 = this.genRandom.nextInt(128);
            int i23 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.genRandom, i18, i21, i23);
            ++i16;
        }
        if (this.genRandom.nextInt(32) == 0) {
            int j16 = k + this.genRandom.nextInt(16) + 8;
            int j18 = this.genRandom.nextInt(128);
            int j21 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.worldObj, this.genRandom, j16, j18, j21);
        }
        int k16 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            k16 += 10;
        }
        int k18 = 0;
        while (k18 < k16) {
            int k21 = k + this.genRandom.nextInt(16) + 8;
            int j23 = this.genRandom.nextInt(128);
            int k24 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.genRandom, k21, j23, k24);
            ++k18;
        }
        int l18 = 0;
        while (l18 < 50) {
            int l21 = k + this.genRandom.nextInt(16) + 8;
            int k23 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int l24 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.genRandom, l21, k23, l24);
            ++l18;
        }
        int i19 = 0;
        while (i19 < 20) {
            int i22 = k + this.genRandom.nextInt(16) + 8;
            int l23 = this.genRandom.nextInt(this.genRandom.nextInt(this.genRandom.nextInt(112) + 8) + 8);
            int i25 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.genRandom, i22, l23, i25);
            ++i19;
        }
        this.generatedTemperatures = this.worldObj.getWorldChunkManager().getTemperatures(this.generatedTemperatures, k + 8, l + 8, 16, 16);
        int j19 = k + 8;
        while (j19 < k + 8 + 16) {
            int j22 = l + 8;
            while (j22 < l + 8 + 16) {
                int i24 = j19 - (k + 8);
                int j25 = j22 - (l + 8);
                int k25 = this.worldObj.getTopSolidOrLiquidBlock(j19, j22);
                double d1 = this.generatedTemperatures[i24 * 16 + j25] - (double)(k25 - 64) / 64.0 * 0.3;
                if (d1 < 0.5 && k25 > 0 && k25 < 128 && this.worldObj.isAirBlock(j19, k25, j22) && this.worldObj.getMaterialXYZ(j19, k25 - 1, j22).blocksMovement() && this.worldObj.getMaterialXYZ(j19, k25 - 1, j22) != Material.ice) {
                    this.worldObj.setBlockWithNotify(j19, k25, j22, Block.snow.blockID);
                }
                ++j22;
            }
            ++j19;
        }
        BlockSand.fallInstantly = false;
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean canSave() {
        return true;
    }
}

