/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.generate.MapGenBase;
import com.mojang.minecraft.level.generate.MapGenCavesHell;
import com.mojang.minecraft.level.generate.WorldGenFire;
import com.mojang.minecraft.level.generate.WorldGenFlowers;
import com.mojang.minecraft.level.generate.WorldGenGlowStone1;
import com.mojang.minecraft.level.generate.WorldGenGlowStone2;
import com.mojang.minecraft.level.generate.WorldGenHellLava;
import com.mojang.minecraft.level.generate.noise.NoiseGeneratorOctaves;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSand;
import java.util.Random;

public class ChunkProviderHell
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves field_4240_i;
    private NoiseGeneratorOctaves field_4239_j;
    private NoiseGeneratorOctaves field_4238_k;
    private NoiseGeneratorOctaves field_4237_l;
    private NoiseGeneratorOctaves field_4236_m;
    public NoiseGeneratorOctaves field_4248_a;
    public NoiseGeneratorOctaves field_4247_b;
    private World field_4235_n;
    private double[] field_4234_o;
    private double[] field_4233_p = new double[256];
    private double[] field_4232_q = new double[256];
    private double[] field_4231_r = new double[256];
    private MapGenBase field_4230_s = new MapGenCavesHell();
    double[] field_4246_c;
    double[] field_4245_d;
    double[] field_4244_e;
    double[] field_4243_f;
    double[] field_4242_g;

    public ChunkProviderHell(World world, long l) {
        this.field_4235_n = world;
        this.hellRNG = new Random(l);
        this.field_4240_i = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4239_j = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4238_k = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.field_4237_l = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4236_m = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4248_a = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.field_4247_b = new NoiseGeneratorOctaves(this.hellRNG, 16);
    }

    public void func_4062_a(int i, int j, byte[] abyte0) {
        int byte0 = 4;
        int byte1 = 32;
        int k = byte0 + 1;
        int byte2 = 17;
        int l = byte0 + 1;
        this.field_4234_o = this.func_4060_a(this.field_4234_o, i * byte0, 0, j * byte0, k, byte2, l);
        int i1 = 0;
        while (i1 < byte0) {
            int j1 = 0;
            while (j1 < byte0) {
                int k1 = 0;
                while (k1 < 16) {
                    double d = 0.125;
                    double d1 = this.field_4234_o[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d2 = this.field_4234_o[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.field_4234_o[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.field_4234_o[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.field_4234_o[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d;
                    double d6 = (this.field_4234_o[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d2) * d;
                    double d7 = (this.field_4234_o[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d;
                    double d8 = (this.field_4234_o[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d;
                    int l1 = 0;
                    while (l1 < 8) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int i2 = 0;
                        while (i2 < 4) {
                            int j2 = i2 + i1 * 4 << 11 | 0 + j1 * 4 << 7 | k1 * 8 + l1;
                            int c = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            int k2 = 0;
                            while (k2 < 4) {
                                int l2 = 0;
                                if (k1 * 8 + l1 < byte1) {
                                    l2 = Block.lavaStill.blockID;
                                }
                                abyte0[j2] = (byte)l2;
                                j2 += c;
                                d15 += d16;
                                ++k2;
                            }
                            d10 += d12;
                            d11 += d13;
                            ++i2;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
    }

    public void func_4061_b(int i, int j, byte[] abyte0) {
        int byte0 = 64;
        double d = 0.03125;
        this.field_4233_p = this.field_4237_l.generateNoiseOctaves(this.field_4233_p, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.field_4232_q = this.field_4237_l.generateNoiseOctaves(this.field_4232_q, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.field_4231_r = this.field_4236_m.generateNoiseOctaves(this.field_4231_r, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                boolean flag = this.field_4233_p[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.field_4232_q[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.field_4231_r[k + l * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                byte byte1 = (byte)Block.stone.blockID;
                byte byte2 = (byte)Block.stone.blockID;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    if (k1 >= 127 - this.hellRNG.nextInt(5)) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else if (k1 <= 0 + this.hellRNG.nextInt(5)) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = abyte0[l1];
                        if (byte3 == 0) {
                            j1 = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    byte1 = 0;
                                    byte2 = (byte)Block.stone.blockID;
                                } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                                    byte1 = (byte)Block.stone.blockID;
                                    byte2 = (byte)Block.stone.blockID;
                                    if (flag1) {
                                        byte1 = (byte)Block.gravel.blockID;
                                    }
                                    if (flag1) {
                                        byte2 = (byte)Block.stone.blockID;
                                    }
                                    if (flag) {
                                        byte1 = (byte)Block.sand.blockID;
                                    }
                                    if (flag) {
                                        byte2 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (k1 < byte0 && byte1 == 0) {
                                    byte1 = (byte)Block.lavaStill.blockID;
                                }
                                j1 = i1;
                                abyte0[l1] = k1 >= byte0 - 1 ? byte1 : byte2;
                            } else if (j1 > 0) {
                                --j1;
                                abyte0[l1] = byte2;
                            }
                        }
                    }
                    --k1;
                }
                ++l;
            }
            ++k;
        }
    }

    public Chunk loadChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    public Chunk provideChunk(int i, int j) {
        this.hellRNG.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        byte[] abyte0 = new byte[32768];
        this.func_4062_a(i, j, abyte0);
        this.func_4061_b(i, j, abyte0);
        this.field_4230_s.func_867_a(this, this.field_4235_n, i, j, abyte0);
        Chunk chunk = new Chunk(this.field_4235_n, abyte0, i, j);
        return chunk;
    }

    private double[] func_4060_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.field_4243_f = this.field_4248_a.generateNoiseOctaves(this.field_4243_f, i, j, k, l, 1, j1, 1.0, 0.0, 1.0);
        this.field_4242_g = this.field_4247_b.generateNoiseOctaves(this.field_4242_g, i, j, k, l, 1, j1, 100.0, 0.0, 100.0);
        this.field_4246_c = this.field_4238_k.generateNoiseOctaves(this.field_4246_c, i, j, k, l, i1, j1, d / 80.0, d1 / 60.0, d / 80.0);
        this.field_4245_d = this.field_4240_i.generateNoiseOctaves(this.field_4245_d, i, j, k, l, i1, j1, d, d1, d);
        this.field_4244_e = this.field_4239_j.generateNoiseOctaves(this.field_4244_e, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        double[] ad1 = new double[i1];
        int i2 = 0;
        while (i2 < i1) {
            ad1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)i1) * 2.0;
            double d2 = i2;
            if (i2 > i1 / 2) {
                d2 = i1 - 1 - i2;
            }
            if (d2 < 4.0) {
                d2 = 4.0 - d2;
                int n = i2;
                ad1[n] = ad1[n] - d2 * d2 * d2 * 10.0;
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < l) {
            int k2 = 0;
            while (k2 < j1) {
                double d3 = (this.field_4243_f[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.field_4242_g[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)i1 / 16.0;
                ++l1;
                int l2 = 0;
                while (l2 < i1) {
                    double d6 = 0.0;
                    double d7 = ad1[l2];
                    double d8 = this.field_4245_d[k1] / 512.0;
                    double d9 = this.field_4244_e[k1] / 512.0;
                    double d10 = (this.field_4246_c[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (l2 > i1 - 4) {
                        double d11 = (float)(l2 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)l2 < d4) {
                        double d12 = (d4 - (double)l2) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    ad[k1] = d6;
                    ++k1;
                    ++l2;
                }
                ++k2;
            }
            ++j2;
        }
        return ad;
    }

    public boolean chunkExists(int i, int j) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        int i1 = 0;
        while (i1 < 8) {
            int k1 = k + this.hellRNG.nextInt(16) + 8;
            int i3 = this.hellRNG.nextInt(120) + 4;
            int k4 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenHellLava(Block.lavaMoving.blockID).generate(this.field_4235_n, this.hellRNG, k1, i3, k4);
            ++i1;
        }
        int j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1) + 1;
        int l1 = 0;
        while (l1 < j1) {
            int j3 = k + this.hellRNG.nextInt(16) + 8;
            int l4 = this.hellRNG.nextInt(120) + 4;
            int i6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFire().generate(this.field_4235_n, this.hellRNG, j3, l4, i6);
            ++l1;
        }
        j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        int i2 = 0;
        while (i2 < j1) {
            int k3 = k + this.hellRNG.nextInt(16) + 8;
            int i5 = this.hellRNG.nextInt(120) + 4;
            int j6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone1().generate(this.field_4235_n, this.hellRNG, k3, i5, j6);
            ++i2;
        }
        int j2 = 0;
        while (j2 < 10) {
            int l3 = k + this.hellRNG.nextInt(16) + 8;
            int j5 = this.hellRNG.nextInt(128);
            int k6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone2().generate(this.field_4235_n, this.hellRNG, l3, j5, k6);
            ++j2;
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int k2 = k + this.hellRNG.nextInt(16) + 8;
            int i4 = this.hellRNG.nextInt(128);
            int k5 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.field_4235_n, this.hellRNG, k2, i4, k5);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int l2 = k + this.hellRNG.nextInt(16) + 8;
            int j4 = this.hellRNG.nextInt(128);
            int l5 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.field_4235_n, this.hellRNG, l2, j4, l5);
        }
        BlockSand.fallInstantly = false;
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean canSave() {
        return true;
    }
}

