/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.enums.EnumSeason;
import com.mojang.minecraft.enums.EnumWeather;
import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.server.EmptyChunk;
import com.mojang.minecraft.server.WorldServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChunkProviderServer
implements IChunkProvider {
    private Set field_725_a = new HashSet();
    private Chunk dummyChunk;
    private IChunkProvider serverChunkGenerator;
    private IChunkLoader field_729_d;
    public boolean chunkLoadOverride = false;
    private Map id2ChunkMap = new HashMap();
    private List field_727_f = new ArrayList();
    private WorldServer worldObj;

    public ChunkProviderServer(WorldServer worldserver, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.dummyChunk = new EmptyChunk(worldserver, new byte[32768], 0, 0);
        this.worldObj = worldserver;
        this.field_729_d = ichunkloader;
        this.serverChunkGenerator = ichunkprovider;
    }

    public boolean chunkExists(int i, int j) {
        return this.id2ChunkMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(i, j));
    }

    public void func_374_c(int i, int j) {
        ChunkCoordinates chunkcoordinates = this.worldObj.getSpawnPoint();
        int k = i * 16 + 8 - chunkcoordinates.posX;
        int l = j * 16 + 8 - chunkcoordinates.posZ;
        int c = 128;
        if (k < -c || k > c || l < -c || l > c) {
            this.field_725_a.add(ChunkCoordIntPair.chunkXZ2Int(i, j));
        }
    }

    public void setSnowy(int x, int z, boolean snow) {
        int k = ChunkCoordIntPair.chunkXZ2Int(x, z);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(k);
        if (chunk != null) {
            chunk.setSnowy(snow);
            chunk.setFrozen(snow);
        }
    }

    public Chunk loadChunk(int i, int j) {
        int k = ChunkCoordIntPair.chunkXZ2Int(i, j);
        this.field_725_a.remove(k);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(k);
        if (chunk == null) {
            chunk = this.func_4063_e(i, j);
            if (chunk == null) {
                if (this.serverChunkGenerator == null) {
                    chunk = this.dummyChunk;
                } else {
                    chunk = this.serverChunkGenerator.provideChunk(i, j);
                    chunk.frozen = this.worldObj.getCurrentSeason() == EnumSeason.winter;
                    chunk.snowy = this.worldObj.experiencedFirstSnow || this.worldObj.getCurrentSeason() == EnumSeason.winter && (this.worldObj.weather == EnumWeather.precipitation || this.worldObj.weather == EnumWeather.seasonal);
                }
            }
            this.id2ChunkMap.put(k, chunk);
            this.field_727_f.add(chunk);
            if (chunk != null) {
                chunk.func_4053_c();
                chunk.onChunkLoad();
            }
            if (!chunk.isTerrainPopulated && this.chunkExists(i + 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j);
            }
            if (this.chunkExists(i - 1, j) && !this.provideChunk((int)(i - 1), (int)j).isTerrainPopulated && this.chunkExists(i - 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j);
            }
            if (this.chunkExists(i, j - 1) && !this.provideChunk((int)i, (int)(j - 1)).isTerrainPopulated && this.chunkExists(i + 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j - 1);
            }
            if (this.chunkExists(i - 1, j - 1) && !this.provideChunk((int)(i - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(i - 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j - 1);
            }
            if (this.worldObj.getCurrentSeason() == EnumSeason.winter && !chunk.frozen) {
                chunk.setFrozen(true);
            } else if (this.worldObj.getCurrentSeason() != EnumSeason.winter && chunk.frozen) {
                chunk.setFrozen(false);
            }
            if (this.worldObj.getCurrentSeason() == EnumSeason.winter && (this.worldObj.experiencedFirstSnow || this.worldObj.weather == EnumWeather.precipitation || this.worldObj.weather == EnumWeather.seasonal) && !chunk.snowy) {
                chunk.setSnowy(true);
            } else if (this.worldObj.getCurrentSeason() != EnumSeason.winter && chunk.snowy) {
                chunk.setSnowy(false);
            }
        }
        return chunk;
    }

    public Chunk provideChunk(int i, int j) {
        Chunk chunk = (Chunk)this.id2ChunkMap.get(ChunkCoordIntPair.chunkXZ2Int(i, j));
        if (chunk == null) {
            if (this.worldObj.worldChunkLoadOverride || this.chunkLoadOverride) {
                return this.loadChunk(i, j);
            }
            return this.dummyChunk;
        }
        return chunk;
    }

    private Chunk func_4063_e(int i, int j) {
        if (this.field_729_d == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_729_d.loadChunk(this.worldObj, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_375_a(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            this.field_729_d.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_373_b(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.field_729_d.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.serverChunkGenerator != null) {
                this.serverChunkGenerator.generateStructures(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        int j = 0;
        while (j < this.field_727_f.size()) {
            Chunk chunk = (Chunk)this.field_727_f.get(j);
            if (flag && !chunk.neverSave) {
                this.func_375_a(chunk);
            }
            if (chunk.needsSaving(flag)) {
                this.func_373_b(chunk);
                chunk.isModified = false;
                if (++i == 24 && !flag) {
                    return false;
                }
            }
            ++j;
        }
        if (flag) {
            if (this.field_729_d == null) {
                return true;
            }
            this.field_729_d.saveExtraData();
        }
        return true;
    }

    public boolean unload100OldestChunks() {
        if (!this.worldObj.levelSaving) {
            int i = 0;
            while (i < 100) {
                if (!this.field_725_a.isEmpty()) {
                    Integer integer = (Integer)this.field_725_a.iterator().next();
                    Chunk chunk = (Chunk)this.id2ChunkMap.get(integer);
                    chunk.onChunkUnload();
                    this.func_373_b(chunk);
                    this.func_375_a(chunk);
                    this.field_725_a.remove(integer);
                    this.id2ChunkMap.remove(integer);
                    this.field_727_f.remove(chunk);
                }
                ++i;
            }
            if (this.field_729_d != null) {
                this.field_729_d.func_814_a();
            }
        }
        return this.serverChunkGenerator.unload100OldestChunks();
    }

    public boolean canSave() {
        return !this.worldObj.levelSaving;
    }
}

