/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.generate.MapGenBase;
import com.mojang.minecraft.level.generate.MapGenCaves;
import com.mojang.minecraft.level.generate.WorldGenCactus;
import com.mojang.minecraft.level.generate.WorldGenClay;
import com.mojang.minecraft.level.generate.WorldGenDungeons;
import com.mojang.minecraft.level.generate.WorldGenFlowers;
import com.mojang.minecraft.level.generate.WorldGenLakes;
import com.mojang.minecraft.level.generate.WorldGenLiquids;
import com.mojang.minecraft.level.generate.WorldGenMinable;
import com.mojang.minecraft.level.generate.WorldGenPumpkin;
import com.mojang.minecraft.level.generate.WorldGenReed;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.generate.noise.NoiseGeneratorOctaves;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.server.BiomeGenBase;
import java.util.Random;

public class ChunkProviderSkyBeta
implements IChunkProvider {
    private Random field_28085_j;
    private NoiseGeneratorOctaves field_28084_k;
    private NoiseGeneratorOctaves field_28083_l;
    private NoiseGeneratorOctaves field_28082_m;
    private NoiseGeneratorOctaves field_28081_n;
    private NoiseGeneratorOctaves field_28080_o;
    public NoiseGeneratorOctaves field_28094_a;
    public NoiseGeneratorOctaves field_28093_b;
    public NoiseGeneratorOctaves field_28092_c;
    private World field_28079_p;
    private double[] field_28078_q;
    private double[] field_28077_r = new double[256];
    private double[] field_28076_s = new double[256];
    private double[] field_28075_t = new double[256];
    private MapGenBase field_28074_u = new MapGenCaves();
    private BiomeGenBase[] field_28073_v;
    double[] field_28091_d;
    double[] field_28090_e;
    double[] field_28089_f;
    double[] field_28088_g;
    double[] field_28087_h;
    int[][] field_28086_i = new int[32][32];
    private double[] field_28072_w;

    public ChunkProviderSkyBeta(World world, long l) {
        this.field_28079_p = world;
        this.field_28085_j = new Random(l);
        this.field_28084_k = new NoiseGeneratorOctaves(this.field_28085_j, 16);
        this.field_28083_l = new NoiseGeneratorOctaves(this.field_28085_j, 16);
        this.field_28082_m = new NoiseGeneratorOctaves(this.field_28085_j, 8);
        this.field_28081_n = new NoiseGeneratorOctaves(this.field_28085_j, 4);
        this.field_28080_o = new NoiseGeneratorOctaves(this.field_28085_j, 4);
        this.field_28094_a = new NoiseGeneratorOctaves(this.field_28085_j, 10);
        this.field_28093_b = new NoiseGeneratorOctaves(this.field_28085_j, 16);
        this.field_28092_c = new NoiseGeneratorOctaves(this.field_28085_j, 8);
    }

    public void func_28070_a(int i, int j, byte[] abyte0, BiomeGenBase[] abiomegenbase, double[] ad) {
        int byte0 = 2;
        int k = byte0 + 1;
        int byte1 = 33;
        int l = byte0 + 1;
        this.field_28078_q = this.func_28071_a(this.field_28078_q, i * byte0, 0, j * byte0, k, byte1, l);
        int i1 = 0;
        while (i1 < byte0) {
            int j1 = 0;
            while (j1 < byte0) {
                int k1 = 0;
                while (k1 < 32) {
                    double d = 0.25;
                    double d1 = this.field_28078_q[((i1 + 0) * l + (j1 + 0)) * byte1 + (k1 + 0)];
                    double d2 = this.field_28078_q[((i1 + 0) * l + (j1 + 1)) * byte1 + (k1 + 0)];
                    double d3 = this.field_28078_q[((i1 + 1) * l + (j1 + 0)) * byte1 + (k1 + 0)];
                    double d4 = this.field_28078_q[((i1 + 1) * l + (j1 + 1)) * byte1 + (k1 + 0)];
                    double d5 = (this.field_28078_q[((i1 + 0) * l + (j1 + 0)) * byte1 + (k1 + 1)] - d1) * d;
                    double d6 = (this.field_28078_q[((i1 + 0) * l + (j1 + 1)) * byte1 + (k1 + 1)] - d2) * d;
                    double d7 = (this.field_28078_q[((i1 + 1) * l + (j1 + 0)) * byte1 + (k1 + 1)] - d3) * d;
                    double d8 = (this.field_28078_q[((i1 + 1) * l + (j1 + 1)) * byte1 + (k1 + 1)] - d4) * d;
                    int l1 = 0;
                    while (l1 < 4) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int i2 = 0;
                        while (i2 < 8) {
                            int j2 = i2 + i1 * 8 << 11 | 0 + j1 * 8 << 7 | k1 * 4 + l1;
                            int c = 128;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            int k2 = 0;
                            while (k2 < 8) {
                                int l2 = 0;
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                abyte0[j2] = (byte)l2;
                                j2 += c;
                                d15 += d16;
                                ++k2;
                            }
                            d10 += d12;
                            d11 += d13;
                            ++i2;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
    }

    public void func_28069_a(int i, int j, byte[] abyte0, BiomeGenBase[] abiomegenbase) {
        double d = 0.03125;
        this.field_28077_r = this.field_28081_n.generateNoiseOctaves(this.field_28077_r, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.field_28076_s = this.field_28081_n.generateNoiseOctaves(this.field_28076_s, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.field_28075_t = this.field_28080_o.generateNoiseOctaves(this.field_28075_t, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                BiomeGenBase biomegenbase = abiomegenbase[k + l * 16];
                int i1 = (int)(this.field_28075_t[k + l * 16] / 3.0 + 3.0 + this.field_28085_j.nextDouble() * 0.25);
                int j1 = -1;
                byte byte0 = biomegenbase.topBlock;
                byte byte1 = biomegenbase.fillerBlock;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    byte byte2 = abyte0[l1];
                    if (byte2 == 0) {
                        j1 = -1;
                    } else if (byte2 == Block.stone.blockID) {
                        if (j1 == -1) {
                            if (i1 <= 0) {
                                byte0 = 0;
                                byte1 = (byte)Block.stone.blockID;
                            }
                            j1 = i1;
                            abyte0[l1] = k1 >= 0 ? byte0 : byte1;
                        } else if (j1 > 0) {
                            abyte0[l1] = byte1;
                            if (--j1 == 0 && byte1 == Block.sand.blockID) {
                                j1 = this.field_28085_j.nextInt(4);
                            }
                        }
                    }
                    --k1;
                }
                ++l;
            }
            ++k;
        }
    }

    public Chunk loadChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    public Chunk provideChunk(int i, int j) {
        this.field_28085_j.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        byte[] abyte0 = new byte[32768];
        Chunk chunk = new Chunk(this.field_28079_p, abyte0, i, j);
        this.field_28073_v = this.field_28079_p.getWorldChunkManager().loadBlockGeneratorData(this.field_28073_v, i * 16, j * 16, 16, 16);
        double[] ad = this.field_28079_p.getWorldChunkManager().temperature;
        this.func_28070_a(i, j, abyte0, this.field_28073_v, ad);
        this.func_28069_a(i, j, abyte0, this.field_28073_v);
        this.field_28074_u.func_867_a(this, this.field_28079_p, i, j, abyte0);
        chunk.func_1024_c();
        return chunk;
    }

    private double[] func_28071_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 684.412;
        double[] ad1 = this.field_28079_p.getWorldChunkManager().temperature;
        double[] ad2 = this.field_28079_p.getWorldChunkManager().humidity;
        this.field_28088_g = this.field_28094_a.func_4103_a(this.field_28088_g, i, k, l, j1, 1.121, 1.121, 0.5);
        this.field_28087_h = this.field_28093_b.func_4103_a(this.field_28087_h, i, k, l, j1, 200.0, 200.0, 0.5);
        this.field_28091_d = this.field_28082_m.generateNoiseOctaves(this.field_28091_d, i, j, k, l, i1, j1, (d *= 2.0) / 80.0, d1 / 160.0, d / 80.0);
        this.field_28090_e = this.field_28084_k.generateNoiseOctaves(this.field_28090_e, i, j, k, l, i1, j1, d, d1, d);
        this.field_28089_f = this.field_28083_l.generateNoiseOctaves(this.field_28089_f, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        int i2 = 16 / l;
        int j2 = 0;
        while (j2 < l) {
            int k2 = j2 * i2 + i2 / 2;
            int l2 = 0;
            while (l2 < j1) {
                double d6;
                int i3 = l2 * i2 + i2 / 2;
                double d2 = ad1[k2 * 16 + i3];
                double d3 = ad2[k2 * 16 + i3] * d2;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.field_28088_g[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.field_28087_h[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)i1 / 16.0;
                ++l1;
                double d7 = (double)i1 / 2.0;
                int j3 = 0;
                while (j3 < i1) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.field_28090_e[k1] / 512.0;
                    double d11 = this.field_28089_f[k1] / 512.0;
                    double d12 = (this.field_28091_d[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > i1 - k3) {
                        double d13 = (float)(j3 - (i1 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    ad[k1] = d8;
                    ++k1;
                    ++j3;
                }
                ++l2;
            }
            ++j2;
        }
        return ad;
    }

    public boolean chunkExists(int i, int j) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase biomegenbase = this.field_28079_p.getWorldChunkManager().getBiomeGenAt(k + 16, l + 16);
        this.field_28085_j.setSeed(this.field_28079_p.getRandomSeed());
        long l1 = this.field_28085_j.nextLong() / 2L * 2L + 1L;
        long l2 = this.field_28085_j.nextLong() / 2L * 2L + 1L;
        this.field_28085_j.setSeed((long)i * l1 + (long)j * l2 ^ this.field_28079_p.getRandomSeed());
        double d = 0.25;
        if (this.field_28085_j.nextInt(4) == 0) {
            int i1 = k + this.field_28085_j.nextInt(16) + 8;
            int l4 = this.field_28085_j.nextInt(128);
            int i8 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenLakes(Block.waterStill.blockID).generate(this.field_28079_p, this.field_28085_j, i1, l4, i8);
        }
        if (this.field_28085_j.nextInt(8) == 0) {
            int j1 = k + this.field_28085_j.nextInt(16) + 8;
            int i5 = this.field_28085_j.nextInt(this.field_28085_j.nextInt(120) + 8);
            int j8 = l + this.field_28085_j.nextInt(16) + 8;
            if (i5 < 64 || this.field_28085_j.nextInt(10) == 0) {
                new WorldGenLakes(Block.lavaStill.blockID).generate(this.field_28079_p, this.field_28085_j, j1, i5, j8);
            }
        }
        int k1 = 0;
        while (k1 < 8) {
            int j5 = k + this.field_28085_j.nextInt(16) + 8;
            int k8 = this.field_28085_j.nextInt(128);
            int i13 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.field_28079_p, this.field_28085_j, j5, k8, i13);
            ++k1;
        }
        int i2 = 0;
        while (i2 < 10) {
            int k5 = k + this.field_28085_j.nextInt(16);
            int l8 = this.field_28085_j.nextInt(128);
            int j13 = l + this.field_28085_j.nextInt(16);
            new WorldGenClay(32).generate(this.field_28079_p, this.field_28085_j, k5, l8, j13);
            ++i2;
        }
        int j2 = 0;
        while (j2 < 20) {
            int l5 = k + this.field_28085_j.nextInt(16);
            int i9 = this.field_28085_j.nextInt(128);
            int k13 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.field_28079_p, this.field_28085_j, l5, i9, k13);
            ++j2;
        }
        int k2 = 0;
        while (k2 < 10) {
            int i6 = k + this.field_28085_j.nextInt(16);
            int j9 = this.field_28085_j.nextInt(128);
            int l13 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.field_28079_p, this.field_28085_j, i6, j9, l13);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 20) {
            int j6 = k + this.field_28085_j.nextInt(16);
            int k9 = this.field_28085_j.nextInt(128);
            int i14 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.field_28079_p, this.field_28085_j, j6, k9, i14);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 20) {
            int k6 = k + this.field_28085_j.nextInt(16);
            int l9 = this.field_28085_j.nextInt(64);
            int j14 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.field_28079_p, this.field_28085_j, k6, l9, j14);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 2) {
            int l6 = k + this.field_28085_j.nextInt(16);
            int i10 = this.field_28085_j.nextInt(32);
            int k14 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.field_28079_p, this.field_28085_j, l6, i10, k14);
            ++k3;
        }
        int l3 = 0;
        while (l3 < 8) {
            int i7 = k + this.field_28085_j.nextInt(16);
            int j10 = this.field_28085_j.nextInt(16);
            int l14 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.field_28079_p, this.field_28085_j, i7, j10, l14);
            ++l3;
        }
        int i4 = 0;
        while (i4 < 1) {
            int j7 = k + this.field_28085_j.nextInt(16);
            int k10 = this.field_28085_j.nextInt(16);
            int i15 = l + this.field_28085_j.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.field_28079_p, this.field_28085_j, j7, k10, i15);
            ++i4;
        }
        d = 0.5;
        int k4 = (int)((this.field_28092_c.func_806_a((double)k * d, (double)l * d) / 8.0 + this.field_28085_j.nextDouble() * 4.0 + 4.0) / 3.0);
        int l7 = 0;
        if (this.field_28085_j.nextInt(10) == 0) {
            ++l7;
        }
        if (biomegenbase == BiomeGenBase.forest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.rainforest) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.seasonalForest) {
            l7 += k4 + 2;
        }
        if (biomegenbase == BiomeGenBase.taiga) {
            l7 += k4 + 5;
        }
        if (biomegenbase == BiomeGenBase.desert) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.tundra) {
            l7 -= 20;
        }
        if (biomegenbase == BiomeGenBase.plains) {
            l7 -= 20;
        }
        int i11 = 0;
        while (i11 < l7) {
            int k15 = k + this.field_28085_j.nextInt(16) + 8;
            int j18 = l + this.field_28085_j.nextInt(16) + 8;
            WorldGenerator worldgenerator = biomegenbase.getRandomWorldGenForTrees(this.field_28085_j);
            worldgenerator.func_517_a(1.0, 1.0, 1.0);
            worldgenerator.generate(this.field_28079_p, this.field_28085_j, k15, this.field_28079_p.getHeightValue(k15, j18), j18);
            ++i11;
        }
        int j11 = 0;
        while (j11 < 2) {
            int l15 = k + this.field_28085_j.nextInt(16) + 8;
            int k18 = this.field_28085_j.nextInt(128);
            int i21 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.field_28079_p, this.field_28085_j, l15, k18, i21);
            ++j11;
        }
        if (this.field_28085_j.nextInt(2) == 0) {
            int k11 = k + this.field_28085_j.nextInt(16) + 8;
            int i16 = this.field_28085_j.nextInt(128);
            int l18 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.field_28079_p, this.field_28085_j, k11, i16, l18);
        }
        if (this.field_28085_j.nextInt(4) == 0) {
            int l11 = k + this.field_28085_j.nextInt(16) + 8;
            int j16 = this.field_28085_j.nextInt(128);
            int i19 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.field_28079_p, this.field_28085_j, l11, j16, i19);
        }
        if (this.field_28085_j.nextInt(8) == 0) {
            int i12 = k + this.field_28085_j.nextInt(16) + 8;
            int k16 = this.field_28085_j.nextInt(128);
            int j19 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.field_28079_p, this.field_28085_j, i12, k16, j19);
        }
        int j12 = 0;
        while (j12 < 10) {
            int l16 = k + this.field_28085_j.nextInt(16) + 8;
            int k19 = this.field_28085_j.nextInt(128);
            int j21 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenReed().generate(this.field_28079_p, this.field_28085_j, l16, k19, j21);
            ++j12;
        }
        if (this.field_28085_j.nextInt(32) == 0) {
            int k12 = k + this.field_28085_j.nextInt(16) + 8;
            int i17 = this.field_28085_j.nextInt(128);
            int l19 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.field_28079_p, this.field_28085_j, k12, i17, l19);
        }
        int l12 = 0;
        if (biomegenbase == BiomeGenBase.desert) {
            l12 += 10;
        }
        int j17 = 0;
        while (j17 < l12) {
            int i20 = k + this.field_28085_j.nextInt(16) + 8;
            int k21 = this.field_28085_j.nextInt(128);
            int k22 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenCactus().generate(this.field_28079_p, this.field_28085_j, i20, k21, k22);
            ++j17;
        }
        int k17 = 0;
        while (k17 < 50) {
            int j20 = k + this.field_28085_j.nextInt(16) + 8;
            int l21 = this.field_28085_j.nextInt(this.field_28085_j.nextInt(120) + 8);
            int l22 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.field_28079_p, this.field_28085_j, j20, l21, l22);
            ++k17;
        }
        int l17 = 0;
        while (l17 < 20) {
            int k20 = k + this.field_28085_j.nextInt(16) + 8;
            int i22 = this.field_28085_j.nextInt(this.field_28085_j.nextInt(this.field_28085_j.nextInt(112) + 8) + 8);
            int i23 = l + this.field_28085_j.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.field_28079_p, this.field_28085_j, k20, i22, i23);
            ++l17;
        }
        this.field_28072_w = this.field_28079_p.getWorldChunkManager().getTemperatures(this.field_28072_w, k + 8, l + 8, 16, 16);
        int i18 = k + 8;
        while (i18 < k + 8 + 16) {
            int l20 = l + 8;
            while (l20 < l + 8 + 16) {
                int j22 = i18 - (k + 8);
                int j23 = l20 - (l + 8);
                int k23 = this.field_28079_p.getTopSolidOrLiquidBlock(i18, l20);
                double d1 = this.field_28072_w[j22 * 16 + j23] - (double)(k23 - 64) / 64.0 * 0.3;
                if (d1 < 0.5 && k23 > 0 && k23 < 128 && this.field_28079_p.isAirBlock(i18, k23, l20) && this.field_28079_p.getMaterialXYZ(i18, k23 - 1, l20).blocksMovement() && this.field_28079_p.getMaterialXYZ(i18, k23 - 1, l20) != Material.ice) {
                    this.field_28079_p.setBlockWithNotify(i18, k23, l20, Block.snow.blockID);
                }
                ++l20;
            }
            ++i18;
        }
        BlockSand.fallInstantly = false;
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean canSave() {
        return true;
    }
}

