/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.chunk.ChunkFile;
import com.mojang.minecraft.level.chunk.ChunkFilePattern;
import com.mojang.minecraft.level.chunk.ChunkFolderPattern;
import com.mojang.minecraft.level.region.RegionFile;
import com.mojang.minecraft.level.region.RegionFileCache;
import com.mojang.minecraft.server.ISaveHandler;
import com.mojang.minecraft.server.SaveFormatOld;
import com.mojang.minecraft.server.SaveOldDir;
import com.mojang.minecraft.server.WorldInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.GZIPInputStream;

public class SaveConverterMcRegion
extends SaveFormatOld {
    public SaveConverterMcRegion(File file) {
        super(file);
    }

    public ISaveHandler func_22105_a(String s, boolean flag) {
        return new SaveOldDir(this.field_22106_a, s, flag);
    }

    public boolean isOldSaveType(String s) {
        WorldInfo worldinfo = this.getWorldInfo(s);
        return worldinfo != null && worldinfo.getVersion() == 0;
    }

    public boolean converMapToMCRegion(String s, IProgressUpdate iprogressupdate) {
        iprogressupdate.setLoadingProgress(0);
        ArrayList arraylist = new ArrayList();
        ArrayList arraylist1 = new ArrayList();
        ArrayList arraylist2 = new ArrayList();
        ArrayList arraylist3 = new ArrayList();
        File file = new File(this.field_22106_a, s);
        File file1 = new File(file, "DIM-1");
        System.out.println("Scanning folders...");
        this.func_22108_a(file, arraylist, arraylist1);
        if (file1.exists()) {
            this.func_22108_a(file1, arraylist2, arraylist3);
        }
        int i = arraylist.size() + arraylist2.size() + arraylist1.size() + arraylist3.size();
        System.out.println("Total conversion count is " + i);
        this.func_22107_a(file, arraylist, 0, i, iprogressupdate);
        this.func_22107_a(file1, arraylist2, arraylist.size(), i, iprogressupdate);
        WorldInfo worldinfo = this.getWorldInfo(s);
        worldinfo.setVersion(19132);
        ISaveHandler isavehandler = this.func_22105_a(s, false);
        isavehandler.func_22094_a(worldinfo);
        this.func_22109_a(arraylist1, arraylist.size() + arraylist2.size(), i, iprogressupdate);
        if (file1.exists()) {
            this.func_22109_a(arraylist3, arraylist.size() + arraylist2.size() + arraylist1.size(), i, iprogressupdate);
        }
        return true;
    }

    private void func_22108_a(File file, ArrayList arraylist, ArrayList arraylist1) {
        File[] afile;
        ChunkFolderPattern chunkfolderpattern = new ChunkFolderPattern(null);
        ChunkFilePattern chunkfilepattern = new ChunkFilePattern(null);
        File[] afile1 = afile = file.listFiles(chunkfolderpattern);
        int i = afile1.length;
        int j = 0;
        while (j < i) {
            File[] afile2;
            File file1 = afile1[j];
            arraylist1.add(file1);
            File[] afile3 = afile2 = file1.listFiles(chunkfolderpattern);
            int k = afile3.length;
            int l = 0;
            while (l < k) {
                File[] afile4;
                File file2 = afile3[l];
                File[] afile5 = afile4 = file2.listFiles(chunkfilepattern);
                int i1 = afile5.length;
                int j1 = 0;
                while (j1 < i1) {
                    File file3 = afile5[j1];
                    arraylist.add(new ChunkFile(file3));
                    ++j1;
                }
                ++l;
            }
            ++j;
        }
    }

    private void func_22107_a(File file, ArrayList arraylist, int i, int j, IProgressUpdate iprogressupdate) {
        Collections.sort(arraylist);
        byte[] abyte0 = new byte[4096];
        for (ChunkFile chunkfile : arraylist) {
            int l;
            int k = chunkfile.func_22205_b();
            RegionFile regionfile = RegionFileCache.func_22123_a(file, k, l = chunkfile.func_22204_c());
            if (!regionfile.isChunkSaved(k & 0x1F, l & 0x1F)) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkfile.func_22207_a())));
                    DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(k & 0x1F, l & 0x1F);
                    int j1 = 0;
                    while ((j1 = datainputstream.read(abyte0)) != -1) {
                        dataoutputstream.write(abyte0, 0, j1);
                    }
                    dataoutputstream.close();
                    datainputstream.close();
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                }
            }
            int i1 = (int)Math.round(100.0 * (double)(++i) / (double)j);
            iprogressupdate.setLoadingProgress(i1);
        }
        RegionFileCache.func_22122_a();
    }

    private void func_22109_a(ArrayList arraylist, int i, int j, IProgressUpdate iprogressupdate) {
        for (File file : arraylist) {
            File[] afile = file.listFiles();
            SaveConverterMcRegion.func_22104_a(afile);
            file.delete();
            int k = (int)Math.round(100.0 * (double)(++i) / (double)j);
            iprogressupdate.setLoadingProgress(k);
        }
    }
}

