/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.Random;

public class WorldGenClay
extends WorldGenerator {
    private ArrayList<Integer> blockIds;
    private int clayBlockId;
    private int numberOfBlocks;

    public WorldGenClay(int i) {
        this.clayBlockId = Block.blockClay.blockID;
        this.numberOfBlocks = i;
        this.blockIds = new ArrayList();
        this.blockIds.add(Block.gravel.blockID);
        this.blockIds.add(Block.sand.blockID);
    }

    public WorldGenClay(int i, int[] b) {
        this.clayBlockId = Block.blockClay.blockID;
        this.numberOfBlocks = i;
        this.blockIds = new ArrayList();
        int x = 0;
        while (x < b.length) {
            this.blockIds.add(b[x]);
            ++x;
        }
    }

    public boolean generate(World world, Random random, int i, int j, int k) {
        if (world.getMaterialXYZ(i, j, k) != Material.water) {
            return false;
        }
        float f = random.nextFloat() * 3.141593f;
        double d = (float)(i + 8) + MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(i + 8) - MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(k + 8) + MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(k + 8) - MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = j + random.nextInt(3) + 2;
        double d5 = j + random.nextInt(3) + 2;
        int l = 0;
        while (l <= this.numberOfBlocks) {
            double d6 = d + (d1 - d) * (double)l / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)l * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)l * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.floor_double(d6 - d10 / 2.0);
            int j1 = MathHelper.floor_double(d6 + d10 / 2.0);
            int k1 = MathHelper.floor_double(d7 - d11 / 2.0);
            int l1 = MathHelper.floor_double(d7 + d11 / 2.0);
            int i2 = MathHelper.floor_double(d8 - d10 / 2.0);
            int j2 = MathHelper.floor_double(d8 + d10 / 2.0);
            int k2 = i1;
            while (k2 <= j1) {
                int l2 = k1;
                while (l2 <= l1) {
                    int i3 = i2;
                    while (i3 <= j2) {
                        double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                        double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 >= 1.0)) {
                            int j3 = world.getBlockId(k2, l2, i3);
                            if (this.blockIds.contains(l1)) {
                                world.setBlock(k2, l2, i3, this.clayBlockId);
                            }
                        }
                        ++i3;
                    }
                    ++l2;
                }
                ++k2;
            }
            ++l;
        }
        return true;
    }
}

