/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class WorldGenDungeons
extends WorldGenerator {
    public boolean generate(World world, Random random, int i, int j, int k) {
        int byte0 = 3;
        int l = random.nextInt(2) + 2;
        int i1 = random.nextInt(2) + 2;
        int j1 = 0;
        int k1 = i - l - 1;
        while (k1 <= i + l + 1) {
            int j2 = j - 1;
            while (j2 <= j + byte0 + 1) {
                int i3 = k - i1 - 1;
                while (i3 <= k + i1 + 1) {
                    Material material = world.getMaterialXYZ(k1, j2, i3);
                    if (j2 == j - 1 && !material.isSolidMaterial()) {
                        return false;
                    }
                    if (j2 == j + byte0 + 1 && !material.isSolidMaterial()) {
                        return false;
                    }
                    if ((k1 == i - l - 1 || k1 == i + l + 1 || i3 == k - i1 - 1 || i3 == k + i1 + 1) && j2 == j && world.isAirBlock(k1, j2, i3) && world.isAirBlock(k1, j2 + 1, i3)) {
                        ++j1;
                    }
                    ++i3;
                }
                ++j2;
            }
            ++k1;
        }
        if (j1 < 1 || j1 > 5) {
            return false;
        }
        int l1 = i - l - 1;
        while (l1 <= i + l + 1) {
            int k2 = j + byte0;
            while (k2 >= j - 1) {
                int j3 = k - i1 - 1;
                while (j3 <= k + i1 + 1) {
                    if (l1 == i - l - 1 || k2 == j - 1 || j3 == k - i1 - 1 || l1 == i + l + 1 || k2 == j + byte0 + 1 || j3 == k + i1 + 1) {
                        if (k2 >= 0 && !world.getMaterialXYZ(l1, k2 - 1, j3).isSolidMaterial()) {
                            world.setBlockWithNotify(l1, k2, j3, 0);
                        } else if (world.getMaterialXYZ(l1, k2, j3).isSolidMaterial()) {
                            if (k2 == j - 1 && random.nextInt(4) != 0) {
                                world.setBlockWithNotify(l1, k2, j3, Block.cobblestoneMossy.blockID);
                            } else {
                                world.setBlockWithNotify(l1, k2, j3, Block.cobblestone.blockID);
                            }
                        }
                    } else {
                        world.setBlockWithNotify(l1, k2, j3, 0);
                    }
                    ++j3;
                }
                --k2;
            }
            ++l1;
        }
        int i2 = 0;
        while (i2 < 2) {
            int l2 = 0;
            while (l2 < 3) {
                int i4;
                int l3;
                int k3 = i + random.nextInt(l * 2 + 1) - l;
                if (world.isAirBlock(k3, l3 = j, i4 = k + random.nextInt(i1 * 2 + 1) - i1)) {
                    int j4 = 0;
                    if (world.getMaterialXYZ(k3 - 1, l3, i4).isSolidMaterial()) {
                        ++j4;
                    }
                    if (world.getMaterialXYZ(k3 + 1, l3, i4).isSolidMaterial()) {
                        ++j4;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 - 1).isSolidMaterial()) {
                        ++j4;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 + 1).isSolidMaterial()) {
                        ++j4;
                    }
                    if (j4 == 1) {
                        world.setBlockWithNotify(k3, l3, i4, Block.crate.blockID);
                        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(k3, l3, i4);
                        for (int k4 = 0; k4 < 8; ++k4) {
                            ItemStack itemstack = this.pickCheckLootItem(random);
                            if (itemstack == null) continue;
                            tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
                        }
                        break;
                    }
                }
                ++l2;
            }
            ++i2;
        }
        world.setBlockWithNotify(i, j, k, Block.mobSpawner.blockID);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(i, j, k);
        tileentitymobspawner.setMobID(this.pickMobSpawner(random));
        return true;
    }

    private ItemStack pickCheckLootItem(Random random) {
        int i = random.nextInt(11);
        if (i == 0) {
            return new ItemStack(Item.saddle);
        }
        if (i == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.bread);
        }
        if (i == 3) {
            return new ItemStack(Item.wheat, random.nextInt(4) + 1);
        }
        if (i == 4) {
            return new ItemStack(Item.gunpowder, random.nextInt(4) + 1);
        }
        if (i == 5) {
            return new ItemStack(Item.silk, random.nextInt(4) + 1);
        }
        if (i == 6) {
            return new ItemStack(Item.bucketEmpty);
        }
        if (i == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.appleGold);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.redstone, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.shiftedIndex + random.nextInt(13)]);
        }
        if (i == 10) {
            return new ItemStack(Item.cocoa);
        }
        return null;
    }

    private String pickMobSpawner(Random random) {
        int i = random.nextInt(4);
        if (i == 0) {
            return "Skeleton";
        }
        if (i == 1) {
            return "Zombie";
        }
        if (i == 2) {
            return "Zombie";
        }
        if (i == 3) {
            return "Spider";
        }
        return "";
    }
}

