/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.region;

import com.mojang.minecraft.level.region.RegionFileChunkBuffer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class RegionFile {
    private static final byte[] emptySector = new byte[4096];
    private final File file;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private ArrayList sectorFree;
    private int sizeDelta;
    private long lastModified = 0L;

    public RegionFile(File path) {
        this.file = path;
        this.debugln("REGION LOAD " + this.file);
        this.sizeDelta = 0;
        try {
            if (path.exists()) {
                this.lastModified = path.lastModified();
            }
            this.dataFile = new RandomAccessFile(path, "rw");
            if (this.dataFile.length() < 4096L) {
                int i = 0;
                while (i < 1024) {
                    this.dataFile.writeInt(0);
                    ++i;
                }
                int j = 0;
                while (j < 1024) {
                    this.dataFile.writeInt(0);
                    ++j;
                }
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int k = 0;
                while ((long)k < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++k;
                }
            }
            int nSectors = (int)this.dataFile.length() / 4096;
            this.sectorFree = new ArrayList(nSectors);
            int i1 = 0;
            while (i1 < nSectors) {
                this.sectorFree.add(true);
                ++i1;
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            int j1 = 0;
            while (j1 < 1024) {
                int l1;
                this.offsets[j1] = l1 = this.dataFile.readInt();
                if (l1 != 0 && (l1 >> 8) + (l1 & 0xFF) <= this.sectorFree.size()) {
                    int j2 = 0;
                    while (j2 < (l1 & 0xFF)) {
                        this.sectorFree.set((l1 >> 8) + j2, false);
                        ++j2;
                    }
                }
                ++j1;
            }
            int k1 = 0;
            while (k1 < 1024) {
                int i2;
                this.chunkTimestamps[k1] = i2 = this.dataFile.readInt();
                ++k1;
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public synchronized int getSizeDelta() {
        int i = this.sizeDelta;
        this.sizeDelta = 0;
        return i;
    }

    private void debug(String s) {
    }

    private void debugln(String s) {
        this.debug(s + "\n");
    }

    private void debug(String s, int i, int j, String s1) {
        this.debug("REGION " + s + " " + this.file.getName() + "[" + i + "," + j + "] = " + s1);
    }

    private void debug(String s, int i, int j, int k, String s1) {
        this.debug("REGION " + s + " " + this.file.getName() + "[" + i + "," + j + "] " + k + "B = " + s1);
    }

    private void debugln(String s, int i, int j, String s1) {
        this.debug(s, i, j, s1 + "\n");
    }

    public synchronized DataInputStream getChunkDataInputStream(int x, int z) {
        int length;
        block10: {
            int numSectors;
            int sectorNumber;
            block9: {
                int offset;
                block8: {
                    if (this.outOfBounds(x, z)) {
                        this.debugln("READ", x, z, "out of bounds");
                        return null;
                    }
                    try {
                        offset = this.getOffset(x, z);
                        if (offset != 0) break block8;
                        return null;
                    }
                    catch (IOException ioexception) {
                        this.debugln("READ", x, z, "exception");
                        return null;
                    }
                }
                sectorNumber = offset >> 8;
                numSectors = offset & 0xFF;
                if (sectorNumber + numSectors <= this.sectorFree.size()) break block9;
                this.debugln("READ", x, z, "invalid sector");
                return null;
            }
            this.dataFile.seek(sectorNumber * 4096);
            length = this.dataFile.readInt();
            if (length <= 4096 * numSectors) break block10;
            this.debugln("READ", x, z, "invalid length: " + length + " > 4096 * " + numSectors);
            return null;
        }
        byte version = this.dataFile.readByte();
        if (version == 1) {
            byte[] data = new byte[length - 1];
            this.dataFile.read(data);
            DataInputStream ret = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data)));
            return ret;
        }
        if (version == 2) {
            byte[] data = new byte[length - 1];
            this.dataFile.read(data);
            DataInputStream datainputstream1 = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
            return datainputstream1;
        }
        this.debugln("READ", x, z, "unknown version " + version);
        return null;
    }

    public DataOutputStream getChunkDataOutputStream(int i, int j) {
        if (this.outOfBounds(i, j)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, i, j)));
    }

    protected synchronized void write(int x, int z, byte[] data, int length) {
        try {
            int offset = this.getOffset(x, z);
            int sectorNumber = offset >> 8;
            int sectorsAllocated = offset & 0xFF;
            int sectorsNeeded = (length + 5) / 4096 + 1;
            if (sectorsNeeded >= 256) {
                return;
            }
            if (sectorNumber != 0 && sectorsAllocated == sectorsNeeded) {
                this.debug("SAVE", x, z, length, "rewrite");
                this.write(sectorNumber, data, length);
            } else {
                int i = 0;
                while (i < sectorsAllocated) {
                    this.sectorFree.set(sectorNumber + i, true);
                    ++i;
                }
                int runStart = this.sectorFree.indexOf(true);
                int runLength = 0;
                if (runStart != -1) {
                    for (int i2 = runStart; i2 < this.sectorFree.size(); ++i2) {
                        if (runLength != 0) {
                            runLength = ((Boolean)this.sectorFree.get(i2)).booleanValue() ? ++runLength : 0;
                        } else if (((Boolean)this.sectorFree.get(i2)).booleanValue()) {
                            runStart = i2;
                            runLength = 1;
                        }
                        if (runLength >= sectorsNeeded) break;
                    }
                }
                if (runLength >= sectorsNeeded) {
                    this.debug("SAVE", x, z, length, "reuse");
                    int j1 = runStart;
                    this.setOffset(x, z, j1 << 8 | sectorsNeeded);
                    int j3 = 0;
                    while (j3 < sectorsNeeded) {
                        this.sectorFree.set(j1 + j3, false);
                        ++j3;
                    }
                    this.write(j1, data, length);
                } else {
                    this.debug("SAVE", x, z, length, "grow");
                    this.dataFile.seek(this.dataFile.length());
                    int k1 = this.sectorFree.size();
                    int k3 = 0;
                    while (k3 < sectorsNeeded) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                        ++k3;
                    }
                    this.sizeDelta += 4096 * sectorsNeeded;
                    this.write(k1, data, length);
                    this.setOffset(x, z, k1 << 8 | sectorsNeeded);
                }
            }
            this.setChunkTimestamp(x, z, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void write(int sectorNumber, byte[] data, int length) throws IOException {
        this.debugln(" " + sectorNumber);
        this.dataFile.seek(sectorNumber * 4096);
        this.dataFile.writeInt(length + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(data, 0, length);
    }

    private boolean outOfBounds(int x, int z) {
        return x < 0 || x >= 32 || z < 0 || z >= 32;
    }

    private int getOffset(int x, int z) {
        return this.offsets[x + z * 32];
    }

    public boolean isChunkSaved(int x, int z) {
        return this.getOffset(x, z) != 0;
    }

    private void setOffset(int x, int z, int offset) throws IOException {
        this.offsets[x + z * 32] = offset;
        this.dataFile.seek((x + z * 32) * 4);
        this.dataFile.writeInt(offset);
    }

    private void setChunkTimestamp(int i, int j, int k) throws IOException {
        this.chunkTimestamps[i + j * 32] = k;
        this.dataFile.seek(4096 + (i + j * 32) * 4);
        this.dataFile.writeInt(k);
    }

    public void close() throws IOException {
        this.dataFile.close();
    }
}

