/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.region;

import com.mojang.minecraft.level.region.RegionFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class RegionFileCache {
    private static final Map field_22125_a = new HashMap();

    private RegionFileCache() {
    }

    public static synchronized RegionFile func_22123_a(File file, int i, int j) {
        RegionFile regionfile;
        File file1 = new File(file, "region");
        File file2 = new File(file1, "r." + (i >> 5) + "." + (j >> 5) + ".mcr");
        Reference reference = (Reference)field_22125_a.get(file2);
        if (reference != null && (regionfile = (RegionFile)reference.get()) != null) {
            return regionfile;
        }
        if (!file1.exists()) {
            file1.mkdirs();
        }
        if (field_22125_a.size() >= 256) {
            RegionFileCache.func_22122_a();
        }
        RegionFile regionfile1 = new RegionFile(file2);
        field_22125_a.put(file2, new SoftReference<RegionFile>(regionfile1));
        return regionfile1;
    }

    public static synchronized void func_22122_a() {
        for (Reference reference : field_22125_a.values()) {
            try {
                RegionFile regionfile = (RegionFile)reference.get();
                if (regionfile == null) continue;
                regionfile.close();
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
        field_22125_a.clear();
    }

    public static int func_22121_b(File file, int i, int j) {
        RegionFile regionfile = RegionFileCache.func_22123_a(file, i, j);
        return regionfile.getSizeDelta();
    }

    public static DataInputStream getChunkDataInputStream(File file, int i, int j) {
        RegionFile regionfile = RegionFileCache.func_22123_a(file, i, j);
        return regionfile.getChunkDataInputStream(i & 0x1F, j & 0x1F);
    }

    public static DataOutputStream func_22120_d(File file, int i, int j) {
        RegionFile regionfile = RegionFileCache.func_22123_a(file, i, j);
        return regionfile.getChunkDataOutputStream(i & 0x1F, j & 0x1F);
    }
}

