/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemBlock;
import com.mojang.minecraft.entity.item.ItemCloth;
import com.mojang.minecraft.entity.item.ItemLeaves;
import com.mojang.minecraft.entity.item.ItemLog;
import com.mojang.minecraft.entity.item.ItemSapling;
import com.mojang.minecraft.entity.item.ItemSlab;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockBleedingObsidian;
import com.mojang.minecraft.level.tile.BlockBookshelf;
import com.mojang.minecraft.level.tile.BlockBurntCloth;
import com.mojang.minecraft.level.tile.BlockButton;
import com.mojang.minecraft.level.tile.BlockCactus;
import com.mojang.minecraft.level.tile.BlockChest;
import com.mojang.minecraft.level.tile.BlockClay;
import com.mojang.minecraft.level.tile.BlockCloth;
import com.mojang.minecraft.level.tile.BlockCrops;
import com.mojang.minecraft.level.tile.BlockDirt;
import com.mojang.minecraft.level.tile.BlockDoor;
import com.mojang.minecraft.level.tile.BlockFarmland;
import com.mojang.minecraft.level.tile.BlockFence;
import com.mojang.minecraft.level.tile.BlockFire;
import com.mojang.minecraft.level.tile.BlockFlower;
import com.mojang.minecraft.level.tile.BlockFlowing;
import com.mojang.minecraft.level.tile.BlockFurnace;
import com.mojang.minecraft.level.tile.BlockGear;
import com.mojang.minecraft.level.tile.BlockGlass;
import com.mojang.minecraft.level.tile.BlockGrass;
import com.mojang.minecraft.level.tile.BlockGravel;
import com.mojang.minecraft.level.tile.BlockIce;
import com.mojang.minecraft.level.tile.BlockJukeBox;
import com.mojang.minecraft.level.tile.BlockLadder;
import com.mojang.minecraft.level.tile.BlockLeaves;
import com.mojang.minecraft.level.tile.BlockLever;
import com.mojang.minecraft.level.tile.BlockLightBulb;
import com.mojang.minecraft.level.tile.BlockLog;
import com.mojang.minecraft.level.tile.BlockMobSpawner;
import com.mojang.minecraft.level.tile.BlockMotor;
import com.mojang.minecraft.level.tile.BlockMushroom;
import com.mojang.minecraft.level.tile.BlockObsidian;
import com.mojang.minecraft.level.tile.BlockOre;
import com.mojang.minecraft.level.tile.BlockOreStorage;
import com.mojang.minecraft.level.tile.BlockPressurePlate;
import com.mojang.minecraft.level.tile.BlockPyramidion;
import com.mojang.minecraft.level.tile.BlockRail;
import com.mojang.minecraft.level.tile.BlockRedstoneOre;
import com.mojang.minecraft.level.tile.BlockRedstoneTorch;
import com.mojang.minecraft.level.tile.BlockRedstoneWire;
import com.mojang.minecraft.level.tile.BlockReed;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.BlockSapling;
import com.mojang.minecraft.level.tile.BlockSign;
import com.mojang.minecraft.level.tile.BlockSnow;
import com.mojang.minecraft.level.tile.BlockSnowBlock;
import com.mojang.minecraft.level.tile.BlockSponge;
import com.mojang.minecraft.level.tile.BlockSpongeInactive;
import com.mojang.minecraft.level.tile.BlockStairs;
import com.mojang.minecraft.level.tile.BlockStationary;
import com.mojang.minecraft.level.tile.BlockStep;
import com.mojang.minecraft.level.tile.BlockStone;
import com.mojang.minecraft.level.tile.BlockTNT;
import com.mojang.minecraft.level.tile.BlockTorch;
import com.mojang.minecraft.level.tile.BlockWeb;
import com.mojang.minecraft.level.tile.BlockWorkbench;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.StepSoundSand;
import com.mojang.minecraft.level.tile.StepSoundStone;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.ArrayList;
import java.util.Random;

public class Block {
    public static final StepSound soundPowderFootstep;
    public static final StepSound soundWoodFootstep;
    public static final StepSound soundGravelFootstep;
    public static final StepSound soundGrassFootstep;
    public static final StepSound soundStoneFootstep;
    public static final StepSound soundMetalFootstep;
    public static final StepSound soundGlassFootstep;
    public static final StepSound soundClothFootstep;
    public static final StepSound soundSandFootstep;
    public static final Block[] allBlocks;
    public static final boolean[] tickOnLoad;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] lightOpacity;
    public static final boolean[] canBlockGrass;
    public static final int[] lightValue;
    public static final boolean[] requiresSelfNotify;
    public static final Block stone;
    public static final BlockGrass grass;
    public static final Block dirt;
    public static final Block cobblestone;
    public static final Block planks;
    public static final Block sapling;
    public static final Block bedrock;
    public static final Block waterMoving;
    public static final Block waterStill;
    public static final Block lavaMoving;
    public static final Block lavaStill;
    public static final Block sand;
    public static final Block gravel;
    public static final Block oreGold;
    public static final Block oreIron;
    public static final Block oreCoal;
    public static final Block wood;
    public static final BlockLeaves leaves;
    public static final Block sponge;
    public static final Block glass;
    public static final Block cloth_red;
    public static final Block cloth_orange;
    public static final Block cloth_yellow;
    public static final Block cloth_lime;
    public static final Block cloth_green;
    public static final Block cloth_teal;
    public static final Block cloth_cyan;
    public static final Block cloth_blue;
    public static final Block cloth_indigo;
    public static final Block cloth_violet;
    public static final Block cloth_lilac;
    public static final Block cloth_pink;
    public static final Block cloth_magenta;
    public static final Block cloth_darkgray;
    public static final Block cloth;
    public static final Block cloth_lightgray;
    public static final BlockFlower plantYellow;
    public static final BlockFlower plantRed;
    public static final BlockFlower mushroomBrown;
    public static final BlockFlower mushroomRed;
    public static final Block blockGold;
    public static final Block blockSteel;
    public static final Block stepDouble;
    public static final Block stepSingle;
    public static final Block brick;
    public static final Block tnt;
    public static final Block bookShelf;
    public static final Block cobblestoneMossy;
    public static final Block obsidian;
    public static final Block torchWood;
    public static final BlockFire fire;
    public static final Block mobSpawner;
    public static final Block stairCompactPlanks;
    public static final Block crate;
    public static final Block redstoneWire;
    public static final Block oreDiamond;
    public static final Block blockDiamond;
    public static final Block workbench;
    public static final Block crops;
    public static final Block tilledField;
    public static final Block stoneOvenIdle;
    public static final Block stoneOvenActive;
    public static final Block signPost;
    public static final Block doorWood;
    public static final Block ladder;
    public static final Block minecartTrack;
    public static final Block stairCompactStone;
    public static final Block signWall;
    public static final Block lever;
    public static final Block pressurePlateStone;
    public static final Block doorSteel;
    public static final Block pressurePlateWood;
    public static final Block oreRed;
    public static final Block oreRedstoneGlowing;
    public static final Block torchRedstoneIdle;
    public static final Block torchRedstoneActive;
    public static final Block button;
    public static final Block snow;
    public static final Block ice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block reed;
    public static final Block jukebox;
    public static final Block fence;
    public static final Block gear;
    public static final Block spongeInactive;
    public static final BlockFlower plantBlue;
    public static final Block oreCopper;
    public static final Block motor;
    public static final Block generator;
    public static final Block blockCopper;
    public static final Block brickMossy;
    public static final Block bleedingObsidian;
    public static final Block web;
    public static final Block pressurePlateSteel;
    public static final Block lightBulb;
    public static final Block lightBulbOn;
    public static final Block pyramidion;
    public static final Block stoneSand;
    public static final Block brickBlue;
    public static final Block brickFlint;
    public static final Block blockClayRed;
    public static final Block cloth_tekheles;
    public static final Block cloth_burnt;
    public static final Block cloth_burnt_hot;
    public int blockIndexInTexture;
    public final int blockID;
    protected float blockHardness;
    protected float blockResistance;
    protected boolean blockConstructorCalled = true;
    protected boolean enableStats = true;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = soundPowderFootstep;
    public float blockParticleGravity = 1.0f;
    public final Material blockMaterial;
    public float slipperiness = 0.6f;
    private String blockName;

    static {
        tickOnLoad = new boolean[256];
        opaqueCubeLookup = new boolean[256];
        isBlockContainer = new boolean[256];
        lightOpacity = new int[256];
        lightValue = new int[256];
        requiresSelfNotify = new boolean[256];
        soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
        soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
        soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
        soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
        soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
        soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
        soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
        allBlocks = new Block[256];
        canBlockGrass = new boolean[256];
        stone = new BlockStone(1, 1).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stone");
        grass = (BlockGrass)new BlockGrass(2).setHardness(0.6f).setStepSound(soundGrassFootstep).setBlockName("grass");
        dirt = new BlockDirt(3, 2).setHardness(0.5f).setStepSound(soundGravelFootstep).setBlockName("dirt");
        cobblestone = new Block(4, 16, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stonebrick");
        planks = new Block(5, 4, Material.wood).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setBlockName("wood").setRequiresSelfNotify();
        sapling = new BlockSapling(6, 15).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("sapling").setRequiresSelfNotify();
        bedrock = new Block(7, 17, Material.rock).setBlockUnbreakable().setResistance(6000000.0f).setStepSound(soundStoneFootstep).setBlockName("bedrock").disableStats();
        waterMoving = new BlockFlowing(8, Material.water).setHardness(100.0f).setLightOpacity(3).setBlockName("water").disableStats().setRequiresSelfNotify();
        waterStill = new BlockStationary(9, Material.water).setHardness(100.0f).setLightOpacity(3).setBlockName("water").disableStats().setRequiresSelfNotify();
        lavaMoving = new BlockFlowing(10, Material.lava).setHardness(0.0f).setLightValue(1.0f).setLightOpacity(255).setBlockName("lava").disableStats().setRequiresSelfNotify();
        lavaStill = new BlockStationary(11, Material.lava).setHardness(100.0f).setLightValue(1.0f).setLightOpacity(255).setBlockName("lava").disableStats().setRequiresSelfNotify();
        sand = new BlockSand(12, 18).setHardness(0.5f).setStepSound(soundSandFootstep).setBlockName("sand");
        gravel = new BlockGravel(13, 19).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("gravel");
        oreGold = new BlockOre(14, 32).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreGold");
        oreIron = new BlockOre(15, 33).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreIron");
        oreCoal = new BlockOre(16, 34).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreCoal");
        wood = new BlockLog(17).setHardness(2.0f).setStepSound(soundWoodFootstep).setBlockName("log").setRequiresSelfNotify();
        leaves = (BlockLeaves)new BlockLeaves(18, 52).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).setBlockName("leaves").disableStats().setRequiresSelfNotify();
        sponge = new BlockSponge(19).setHardness(0.6f).setStepSound(soundGrassFootstep).setBlockName("sponge");
        glass = new BlockGlass(20, 49, Material.glass, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setBlockName("glass");
        cloth_red = new Block(21, 144, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_red");
        cloth_orange = new Block(22, 145, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_orange");
        cloth_yellow = new Block(23, 146, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_yellow");
        cloth_lime = new Block(24, 147, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_lime");
        cloth_green = new Block(25, 148, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_green");
        cloth_teal = new Block(26, 149, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_teal");
        cloth_cyan = new Block(27, 150, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_cyan");
        cloth_blue = new Block(28, 151, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_blue");
        cloth_indigo = new Block(29, 152, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_indigo");
        cloth_violet = new Block(30, 153, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_violet");
        cloth_lilac = new Block(31, 154, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_lilac");
        cloth_pink = new Block(32, 155, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_pink");
        cloth_magenta = new Block(33, 156, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_magenta");
        cloth_darkgray = new Block(34, 157, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_darkgray");
        cloth = new BlockCloth().setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth").setRequiresSelfNotify();
        cloth_lightgray = new Block(36, 158, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setBlockName("cloth_lightgray");
        plantYellow = (BlockFlower)new BlockFlower(37, 13).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("flower");
        plantRed = (BlockFlower)new BlockFlower(38, 12).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("rose");
        mushroomBrown = (BlockFlower)new BlockMushroom(39, 29).setHardness(0.0f).setStepSound(soundGrassFootstep).setLightValue(0.125f).setBlockName("mushroom");
        mushroomRed = (BlockFlower)new BlockMushroom(40, 28).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("mushroom");
        blockGold = new BlockOreStorage(41, 23).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockGold");
        blockSteel = new BlockOreStorage(42, 22).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockIron");
        stepDouble = new BlockStep(43, true).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneSlab");
        stepSingle = new BlockStep(44, false).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneSlab");
        brick = new Block(45, 7, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("brick");
        tnt = new BlockTNT(46, 8).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("tnt");
        bookShelf = new BlockBookshelf(47, 35).setHardness(1.5f).setStepSound(soundWoodFootstep).setBlockName("bookshelf");
        cobblestoneMossy = new Block(48, 36, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("stoneMoss");
        obsidian = new BlockObsidian(49, 37).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep).setBlockName("obsidian");
        torchWood = new BlockTorch(50, 80).setHardness(0.0f).setLightValue(0.9375f).setStepSound(soundWoodFootstep).setBlockName("torch").setRequiresSelfNotify();
        fire = (BlockFire)new BlockFire(51, 31).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep).setBlockName("fire").disableStats().setRequiresSelfNotify();
        mobSpawner = new BlockMobSpawner(52, 65).setHardness(5.0f).setStepSound(soundMetalFootstep).setBlockName("mobSpawner").disableStats();
        stairCompactPlanks = new BlockStairs(53, planks).setBlockName("stairsWood").setRequiresSelfNotify();
        crate = new BlockChest(54).setHardness(2.5f).setStepSound(soundWoodFootstep).setBlockName("chest").setRequiresSelfNotify();
        redstoneWire = new BlockRedstoneWire(55, 164).setHardness(0.0f).setStepSound(soundPowderFootstep).setBlockName("redstoneDust").disableStats().setRequiresSelfNotify();
        oreDiamond = new BlockOre(56, 50).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreDiamond");
        blockDiamond = new BlockOreStorage(57, 24).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setBlockName("blockDiamond");
        workbench = new BlockWorkbench(58).setHardness(2.5f).setStepSound(soundWoodFootstep).setBlockName("workbench");
        crops = new BlockCrops(59, 88).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("crops").disableStats().setRequiresSelfNotify();
        tilledField = new BlockFarmland(60).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("farmland");
        stoneOvenIdle = new BlockFurnace(61, false).setHardness(3.5f).setStepSound(soundStoneFootstep).setBlockName("furnace").setRequiresSelfNotify();
        stoneOvenActive = new BlockFurnace(62, true).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f).setBlockName("furnace").setRequiresSelfNotify();
        signPost = new BlockSign(63, TileEntitySign.class, true).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("sign").disableStats().setRequiresSelfNotify();
        doorWood = new BlockDoor(64, Material.wood).setHardness(3.0f).setStepSound(soundWoodFootstep).setBlockName("doorWood").disableStats().setRequiresSelfNotify();
        ladder = new BlockLadder(65, 83).setHardness(0.4f).setStepSound(soundWoodFootstep).setBlockName("ladder").setRequiresSelfNotify();
        minecartTrack = new BlockRail(66, 128, false).setHardness(0.7f).setStepSound(soundMetalFootstep).setBlockName("rail").setRequiresSelfNotify();
        stairCompactStone = new BlockStairs(67, cobblestone).setBlockName("stairsStone").setRequiresSelfNotify();
        signWall = new BlockSign(68, TileEntitySign.class, false).setHardness(1.0f).setStepSound(soundWoodFootstep).setBlockName("sign").disableStats().setRequiresSelfNotify();
        lever = new BlockLever(69, 96).setHardness(0.5f).setStepSound(soundWoodFootstep).setBlockName("lever").setRequiresSelfNotify();
        pressurePlateStone = new BlockPressurePlate(70, Block.stone.blockIndexInTexture, EnumMobType.mobs, Material.rock).setHardness(0.5f).setStepSound(soundStoneFootstep).setBlockName("pressurePlate").setRequiresSelfNotify();
        doorSteel = new BlockDoor(71, Material.iron).setHardness(5.0f).setStepSound(soundMetalFootstep).setBlockName("doorIron").disableStats().setRequiresSelfNotify();
        pressurePlateWood = new BlockPressurePlate(72, Block.planks.blockIndexInTexture, EnumMobType.everything, Material.wood).setHardness(0.5f).setStepSound(soundWoodFootstep).setBlockName("pressurePlate").setRequiresSelfNotify();
        oreRed = new BlockRedstoneOre(73, 51, false).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreRedstone").setRequiresSelfNotify();
        oreRedstoneGlowing = new BlockRedstoneOre(74, 51, true).setLightValue(0.625f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setBlockName("oreRedstone").setRequiresSelfNotify();
        torchRedstoneIdle = new BlockRedstoneTorch(75, 115, false).setHardness(0.0f).setStepSound(soundWoodFootstep).setBlockName("notGate").setRequiresSelfNotify();
        torchRedstoneActive = new BlockRedstoneTorch(76, 99, true).setHardness(0.0f).setLightValue(0.5f).setStepSound(soundWoodFootstep).setBlockName("notGate").setRequiresSelfNotify();
        button = new BlockButton(77, Block.stone.blockIndexInTexture).setHardness(0.5f).setStepSound(soundStoneFootstep).setBlockName("button").setRequiresSelfNotify();
        snow = new BlockSnow(78, 66).setHardness(0.1f).setStepSound(soundClothFootstep).setBlockName("snow");
        ice = new BlockIce(79, 67).setHardness(0.5f).setLightOpacity(3).setStepSound(soundGlassFootstep).setBlockName("ice");
        blockSnow = new BlockSnowBlock(80, 66).setHardness(0.2f).setStepSound(soundClothFootstep).setBlockName("snow");
        cactus = new BlockCactus(81, 70).setHardness(0.4f).setStepSound(soundClothFootstep).setBlockName("cactus");
        blockClay = new BlockClay(82, 72).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("clay");
        reed = new BlockReed(83, 73).setHardness(0.0f).setStepSound(soundGrassFootstep).setBlockName("reeds").disableStats();
        jukebox = new BlockJukeBox(84, 74).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setBlockName("jukebox").setRequiresSelfNotify();
        fence = new BlockFence(85, 4).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setBlockName("fence").setRequiresSelfNotify();
        gear = new BlockGear(86, 62).setHardness(0.5f).setStepSound(soundPowderFootstep);
        spongeInactive = new BlockSpongeInactive(87).setHardness(0.6f).setStepSound(soundGrassFootstep);
        plantBlue = (BlockFlower)new BlockFlower(88, 14).setHardness(0.0f).setStepSound(soundGrassFootstep);
        Item.itemsList[Block.cloth.blockID] = new ItemCloth(Block.cloth.blockID - 256).setItemName("cloth");
        Item.itemsList[Block.wood.blockID] = new ItemLog(Block.wood.blockID - 256).setItemName("log");
        Item.itemsList[Block.stepSingle.blockID] = new ItemSlab(Block.stepSingle.blockID - 256).setItemName("stoneSlab");
        Item.itemsList[Block.sapling.blockID] = new ItemSapling(Block.sapling.blockID - 256).setItemName("sapling");
        Item.itemsList[Block.leaves.blockID] = new ItemLeaves(Block.leaves.blockID - 256).setItemName("leaves");
        oreCopper = new BlockOre(89, 76).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        motor = new BlockMotor(90, 113, Material.iron, true, 30).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        generator = new BlockMotor(91, 114, Material.iron, false, -1).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        blockCopper = new BlockOre(92, 176).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        brickMossy = new Block(93, 77, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        bleedingObsidian = new BlockBleedingObsidian(94, 116).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep);
        web = new BlockWeb(95, 11).setHardness(2.0f).setStepSound(soundClothFootstep);
        pressurePlateSteel = new BlockPressurePlate(96, Block.blockSteel.blockIndexInTexture, EnumMobType.players, Material.iron).setHardness(0.5f).setStepSound(soundMetalFootstep);
        lightBulb = new BlockLightBulb(97).setHardness(0.5f).setStepSound(soundGlassFootstep);
        lightBulbOn = new BlockLightBulb(98).setHardness(0.5f).setStepSound(soundGlassFootstep).setLightValue(1.0f);
        pyramidion = new BlockPyramidion(99, 104).setHardness(0.5f).setStepSound(soundMetalFootstep).setLightValue(1.0f);
        stoneSand = new Block(100, 118, Material.rock).setHardness(0.75f).setStepSound(soundStoneFootstep);
        brickBlue = new Block(101, 117, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickFlint = new Block(102, 119, Material.rock).setHardness(3.0f).setResistance(20.0f).setStepSound(soundStoneFootstep);
        blockClayRed = new BlockClay(103, 120).setHardness(0.6f).setStepSound(soundGravelFootstep);
        cloth_tekheles = new Block(104, 159, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_burnt = new BlockBurntCloth(105).setHardness(0.8f).setStepSound(soundGrassFootstep);
        cloth_burnt_hot = new BlockBurntCloth(106).setHardness(0.8f).setStepSound(soundGrassFootstep).setLightValue(0.25f);
        int i = 0;
        while (i < 256) {
            if (allBlocks[i] != null && Item.itemsList[i] == null) {
                Item.itemsList[i] = new ItemBlock(i - 256);
                allBlocks[i].setFireBurnRates();
            }
            ++i;
        }
        Block.canBlockGrass[0] = true;
    }

    protected Block(int i, Material material) {
        if (allBlocks[i] != null) {
            throw new IllegalArgumentException("Slot " + i + " is already occupied by " + allBlocks[i] + " when adding " + this);
        }
        this.blockMaterial = material;
        Block.allBlocks[i] = this;
        this.blockID = i;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[i] = this.isOpaqueCube();
        Block.lightOpacity[i] = this.isOpaqueCube() ? 255 : 0;
        Block.canBlockGrass[i] = !material.getCanBlockGrass();
        Block.isBlockContainer[i] = false;
    }

    protected Block setRequiresSelfNotify() {
        Block.requiresSelfNotify[this.blockID] = true;
        return this;
    }

    protected void setFireBurnRates() {
    }

    protected Block(int i, int j, Material material) {
        this(i, material);
        this.blockIndexInTexture = j;
    }

    protected Block setStepSound(StepSound stepsound) {
        this.stepSound = stepsound;
        return this;
    }

    protected Block setLightOpacity(int i) {
        Block.lightOpacity[this.blockID] = i;
        return this;
    }

    protected Block setLightValue(float f) {
        Block.lightValue[this.blockID] = (int)(15.0f * f);
        return this;
    }

    protected Block setResistance(float f) {
        this.blockResistance = f * 3.0f;
        return this;
    }

    public boolean isACube() {
        return true;
    }

    protected Block setHardness(float f) {
        this.blockHardness = f;
        if (this.blockResistance < f * 5.0f) {
            this.blockResistance = f * 5.0f;
        }
        return this;
    }

    protected Block setBlockUnbreakable() {
        this.setHardness(-1.0f);
        return this;
    }

    public float getHardness() {
        return this.blockHardness;
    }

    protected Block setTickOnLoad(boolean flag) {
        Block.tickOnLoad[this.blockID] = flag;
        return this;
    }

    public void setBlockBounds(float f, float f1, float f2, float f3, float f4, float f5) {
        this.minX = f;
        this.minY = f1;
        this.minZ = f2;
        this.maxX = f3;
        this.maxY = f4;
        this.maxZ = f5;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return iblockaccess.getMaterialXYZ(i, j, k).isSolidMaterial();
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.getBlockTextureFromSide(i);
    }

    public int getBlockTextureFromSide(int i) {
        return this.blockIndexInTexture;
    }

    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb.intersectsWith(axisalignedbb1)) {
            arraylist.add(axisalignedbb1);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean canCollideCheck(int i, boolean flag) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int idDropped(int i, Random random) {
        return this.blockID;
    }

    public float blockStrength(EntityPlayer entityplayer) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!entityplayer.canHarvestBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return entityplayer.getCurrentPlayerStrVsBlock(this) / this.blockHardness / 30.0f;
    }

    public final void dropBlockAsItem(World world, int i, int j, int k, int l) {
        this.dropBlockAsItemWithChance(world, i, j, k, l, 1.0f);
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.singleplayerWorld) {
            return;
        }
        int i1 = this.quantityDropped(world.rand);
        int j1 = 0;
        while (j1 < i1) {
            int k1;
            if (!(world.rand.nextFloat() > f) && (k1 = this.idDropped(l, world.rand)) > 0) {
                this.dropBlockAsItem_do(world, i, j, k, new ItemStack(k1, 1, this.damageDropped(l)));
            }
            ++j1;
        }
    }

    public void dropBlockGoldTouch(World world, int i, int j, int k, int l, float f) {
        int i1 = 1;
        int j1 = 0;
        while (j1 < i1) {
            if (!(world.rand.nextFloat() > f)) {
                int k1 = this.blockID;
                if (k1 > 0 && k1 != Block.crops.blockID && k1 != Block.signPost.blockID && k1 != Block.signWall.blockID && k1 != Block.doorWood.blockID && k1 != Block.doorSteel.blockID && k1 != Block.lightBulbOn.blockID && k1 != Block.pyramidion.blockID) {
                    this.dropBlockAsItem_do(world, i, j, k, new ItemStack(k1, 1, this.damageDropped(l)));
                } else if (k1 == Block.crops.blockID || k1 == Block.signPost.blockID || k1 == Block.signWall.blockID || k1 == Block.doorWood.blockID || k1 == Block.doorSteel.blockID || k1 == Block.lightBulbOn.blockID) {
                    this.dropBlockAsItem(world, i, j, k, l);
                }
            }
            ++j1;
        }
    }

    protected void dropBlockAsItem_do(World world, int i, int j, int k, ItemStack itemstack) {
        if (world.singleplayerWorld) {
            return;
        }
        float f = 0.7f;
        double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, itemstack);
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    protected int damageDropped(int i) {
        return 0;
    }

    public float getExplosionResistance(Entity entity) {
        return this.blockResistance / 5.0f;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        vec3d = vec3d.addVector(-i, -j, -k);
        vec3d1 = vec3d1.addVector(-i, -j, -k);
        Vec3D vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, this.minX);
        Vec3D vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, this.maxX);
        Vec3D vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, this.minY);
        Vec3D vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, this.maxY);
        Vec3D vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, this.minZ);
        Vec3D vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.distanceTo(vec3d2) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.distanceTo(vec3d3) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.distanceTo(vec3d4) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.distanceTo(vec3d5) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.distanceTo(vec3d6) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.distanceTo(vec3d7) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(i, j, k, byte0, vec3d8.addVector(i, j, k));
    }

    private boolean isVecInsideYZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }

    public boolean canPlaceBlockOnSide(World world, int i, int j, int k, int l) {
        return this.canPlace(world, i, j, k);
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == 0 || Block.allBlocks[l].blockMaterial.func_27090_g();
    }

    public boolean canPlaceSnowy(World worldObj, int i, int j4, int j) {
        return false;
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
    }

    public void onBlockPlaced(World world, int i, int j, int k, int l) {
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return false;
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        this.dropBlockAsItem(world, i, j, k, l);
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return true;
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
    }

    public Block setBlockName(String s) {
        this.blockName = "tile." + s;
        return this;
    }

    public String getNameLocalizedForStats() {
        return "";
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void playBlock(World world, int i, int j, int k, int l, int i1) {
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block disableStats() {
        this.enableStats = false;
        return this;
    }

    public int getMobilityFlag() {
        return this.blockMaterial.getMaterialMobility();
    }

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public void onBlockPlacedByAt(World world, int i, int j, int k, int l, EntityPlayer entityplayer) {
    }
}

