/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockBurntCloth
extends Block {
    static final byte radius = 2;

    public BlockBurntCloth(int i) {
        super(i, Material.cloth);
        this.blockIndexInTexture = i + 56;
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public void onBlockAdded(World world, int a, int b, int c) {
        super.onBlockAdded(world, a, b, c);
        int x = a - 2;
        while (x <= a + 2) {
            int y = b - 2;
            while (y <= b + 2) {
                int z = c - 2;
                while (z <= c + 2) {
                    if (world.getBlockId(x, y, z) == Block.snow.blockID || world.getBlockId(x, y, z) == Block.ice.blockID) {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean power = this.isReceivingRedPower(world, i, j, k, l);
        if (power) {
            world.setBlock(i, j, k, 106);
        } else {
            world.setBlock(i, j, k, 105);
        }
    }

    public int idDropped(int i, Random random) {
        return Block.cloth_burnt.blockID;
    }

    public static boolean isPowered(int i) {
        return (i & 8) != 0;
    }

    public void updateTick(World world, int a, int b, int c, Random random) {
        super.updateTick(world, a, b, c, random);
    }

    private boolean isReceivingRedPower(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }

    public void onBlockDestroyedByPlayer(World world, int a, int b, int c, int bid) {
        super.onBlockDestroyedByPlayer(world, a, b, c, bid);
    }

    public static boolean getSurroundHotBlock(World world, int x, int y, int z) {
        int x1 = x - 2;
        while (x1 <= x + 2) {
            int y1 = y - 2;
            while (y1 <= y + 2) {
                int z1 = z - 2;
                while (z1 <= z + 2) {
                    if (world.getBlockId(x1, y1, z1) == Block.cloth_burnt_hot.blockID) {
                        return true;
                    }
                    ++z1;
                }
                ++y1;
            }
            ++x1;
        }
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (float)(j + 1) - f, (float)(k + 1) - f);
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, j + 1, (float)(k + 1) - f);
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (world.getBlockId(i, j, k) == 106 && !(entity instanceof EntityItem)) {
            entity.attackEntityFrom(null, 1);
        }
    }
}

