/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockCactus
extends Block {
    protected BlockCactus(int i, int j) {
        super(i, j, Material.cactus);
        this.setTickOnLoad(true);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isAirBlock(i, j + 1, k)) {
            int l = 1;
            while (world.getBlockId(i, j - l, k) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockMetadata(i, j, k);
                if (i1 == 15) {
                    world.setBlockWithNotify(i, j + 1, k, this.blockID);
                    world.setBlockMetadataWithNotify(i, j, k, 0);
                } else {
                    world.setBlockMetadataWithNotify(i, j, k, i1 + 1);
                }
            }
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (float)(j + 1) - f, (float)(k + 1) - f);
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 0) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public boolean isACube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (!super.canPlace(world, i, j, k)) {
            return false;
        }
        return this.canBlockStay(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        if (world.getMaterialXYZ(i - 1, j, k).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i + 1, j, k).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i, j, k - 1).isSolidMaterial()) {
            return false;
        }
        if (world.getMaterialXYZ(i, j, k + 1).isSolidMaterial()) {
            return false;
        }
        int l = world.getBlockId(i, j - 1, k);
        return l == Block.cactus.blockID || l == Block.sand.blockID;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        entity.attackEntityFrom(null, 1);
    }
}

