/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.player.inventory.InventoryLargeChest;
import java.util.Random;

public class BlockChest
extends BlockContainer {
    private Random random = new Random();

    protected BlockChest(int i) {
        super(i, Material.wood);
        this.blockIndexInTexture = 26;
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 0) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 3) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = 0;
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID) {
            ++l;
        }
        if (l > 1) {
            return false;
        }
        if (this.isThereANeighborChest(world, i - 1, j, k)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i + 1, j, k)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i, j, k - 1)) {
            return false;
        }
        return !this.isThereANeighborChest(world, i, j, k + 1);
    }

    private boolean isThereANeighborChest(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return false;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            return true;
        }
        return world.getBlockId(i, j, k + 1) == this.blockID;
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        int l = 0;
        while (l < tileentitychest.getSizeInventory()) {
            ItemStack itemstack = tileentitychest.getStackInSlot(l);
            if (itemstack != null) {
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.random.nextGaussian() * f3;
                    entityitem.motionY = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
            ++l;
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        IInventory obj = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        if (world.isBlockNormalCube(i, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID && world.isBlockNormalCube(i - 1, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID && world.isBlockNormalCube(i + 1, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID && world.isBlockNormalCube(i, j + 1, k - 1)) {
            return true;
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID && world.isBlockNormalCube(i, j + 1, k + 1)) {
            return true;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i - 1, j, k), obj);
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i + 1, j, k));
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i, j, k - 1), obj);
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i, j, k + 1));
        }
        if (world.singleplayerWorld) {
            return true;
        }
        entityplayer.displayGUIChest(obj);
        return true;
    }

    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

