/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockFarmland
extends Block {
    protected BlockFarmland(int i) {
        super(i, Material.ground);
        this.blockIndexInTexture = 87;
        this.setTickOnLoad(true);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightOpacity(255);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i + 0, j + 0, k + 0, i + 1, j + 1, k + 1);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1 && j > 0) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 1) {
            return this.blockIndexInTexture;
        }
        return 2;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (random.nextInt(5) == 0) {
            if (this.isWaterNearby(world, i, j, k) || world.canLightningStrikeAt(i, j + 1, k)) {
                world.setBlockMetadataWithNotify(i, j, k, 7);
            } else {
                int l = world.getBlockMetadata(i, j, k);
                if (l > 0) {
                    world.setBlockMetadataWithNotify(i, j, k, l - 1);
                } else if (!this.isCropsNearby(world, i, j, k)) {
                    world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
                }
            }
        }
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        if (world.rand.nextInt(4) == 0) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    private boolean isCropsNearby(World world, int i, int j, int k) {
        int l = 0;
        int i1 = i - l;
        while (i1 <= i + l) {
            int j1 = k - l;
            while (j1 <= k + l) {
                if (world.getBlockId(i1, j + 1, j1) == Block.crops.blockID) {
                    return true;
                }
                ++j1;
            }
            ++i1;
        }
        return false;
    }

    private boolean isWaterNearby(World world, int i, int j, int k) {
        int l = i - 4;
        while (l <= i + 4) {
            int i1 = j;
            while (i1 <= j + 1) {
                int j1 = k - 4;
                while (j1 <= k + 4) {
                    if (world.getMaterialXYZ(l, i1, j1) == Material.water) {
                        return true;
                    }
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        Material material = world.getMaterialXYZ(i, j + 1, k);
        if (material.isSolidMaterial()) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    public int idDropped(int i, Random random) {
        return Block.dirt.idDropped(0, random);
    }
}

