/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockFire
extends Block {
    private int[] chanceToEncourageFire = new int[256];
    private int[] abilityToCatchFire = new int[256];

    protected BlockFire(int i, int j) {
        super(i, j, Material.fire);
        this.setTickOnLoad(true);
    }

    public void setFireBurnRates() {
        this.setBurnRate(Block.planks.blockID, 5, 20);
        this.setBurnRate(Block.wood.blockID, 5, 5);
        this.setBurnRate(Block.leaves.blockID, 30, 60);
        this.setBurnRate(Block.bookShelf.blockID, 30, 20);
        this.setBurnRate(Block.tnt.blockID, 15, 100);
        this.setBurnRate(Block.cloth.blockID, 30, 60);
    }

    private void setBurnRate(int i, int j, int k) {
        this.chanceToEncourageFire[i] = j;
        this.abilityToCatchFire[i] = k;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public int tickRate() {
        return 40;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        if (l < 15) {
            world.setBlockMetadataWithNotify(i, j, k, l + 1);
            world.scheduleUpdateTick(i, j, k, this.blockID, 1);
        }
        if (!this.func_263_h(world, i, j, k)) {
            if (!world.isBlockNormalCube(i, j - 1, k) || l > 3) {
                world.setBlockWithNotify(i, j, k, 0);
            }
            return;
        }
        if (!this.canBlockCatchFire(world, i, j - 1, k) && l == 15 && random.nextInt(4) == 0) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        if (l % 2 == 0 && l > 2) {
            this.tryToCatchBlockOnFire(world, i + 1, j, k, 300, random);
            this.tryToCatchBlockOnFire(world, i - 1, j, k, 300, random);
            this.tryToCatchBlockOnFire(world, i, j - 1, k, 200, random);
            this.tryToCatchBlockOnFire(world, i, j + 1, k, 250, random);
            this.tryToCatchBlockOnFire(world, i, j, k - 1, 300, random);
            this.tryToCatchBlockOnFire(world, i, j, k + 1, 300, random);
            int i1 = i - 1;
            while (i1 <= i + 1) {
                int j1 = k - 1;
                while (j1 <= k + 1) {
                    int k1 = j - 1;
                    while (k1 <= j + 4) {
                        if (i1 != i || k1 != j || j1 != k) {
                            int i2;
                            int l1 = 100;
                            if (k1 > j + 1) {
                                l1 += (k1 - (j + 1)) * 100;
                            }
                            if ((i2 = this.getChanceOfNeighborsEncouragingFire(world, i1, k1, j1)) > 0 && random.nextInt(l1) <= i2) {
                                world.setBlockWithNotify(i1, k1, j1, this.blockID);
                            }
                        }
                        ++k1;
                    }
                    ++j1;
                }
                ++i1;
            }
        }
    }

    public void updateTick(World world, int i, int j, int k, Random random, int cancel) {
        boolean flag = false;
        if (!this.canPlace(world, i, j, k)) {
            world.setBlockWithNotify(i, j, k, 0);
        }
        if (!flag && world.func_27068_v() && (world.canLightningStrikeAt(i, j, k) || world.canLightningStrikeAt(i - 1, j, k) || world.canLightningStrikeAt(i + 1, j, k) || world.canLightningStrikeAt(i, j, k - 1) || world.canLightningStrikeAt(i, j, k + 1))) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        if (l < 15) {
            world.setBlockMetadata(i, j, k, l + random.nextInt(3) / 2);
        }
        world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
        if (!flag && !this.func_263_h(world, i, j, k)) {
            if (!world.isBlockNormalCube(i, j - 1, k) || l > 3) {
                world.setBlockWithNotify(i, j, k, 0);
            }
            return;
        }
        if (!flag && !this.canBlockCatchFire(world, i, j - 1, k) && l == 15 && random.nextInt(4) == 0) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        this.tryToCatchBlockOnFire(world, i + 1, j, k, 300, random, l);
        this.tryToCatchBlockOnFire(world, i - 1, j, k, 300, random, l);
        this.tryToCatchBlockOnFire(world, i, j - 1, k, 250, random, l);
        this.tryToCatchBlockOnFire(world, i, j + 1, k, 250, random, l);
        this.tryToCatchBlockOnFire(world, i, j, k - 1, 300, random, l);
        this.tryToCatchBlockOnFire(world, i, j, k + 1, 300, random, l);
        int i1 = i - 1;
        while (i1 <= i + 1) {
            int j1 = k - 1;
            while (j1 <= k + 1) {
                int k1 = j - 1;
                while (k1 <= j + 4) {
                    if (i1 != i || k1 != j || j1 != k) {
                        int j2;
                        int i2;
                        int l1 = 100;
                        if (k1 > j + 1) {
                            l1 += (k1 - (j + 1)) * 100;
                        }
                        if (!((i2 = this.getChanceOfNeighborsEncouragingFire(world, i1, k1, j1)) <= 0 || (j2 = (i2 + 40) / (l + 30)) <= 0 || random.nextInt(l1) > j2 || world.func_27068_v() && world.canLightningStrikeAt(i1, k1, j1) || world.canLightningStrikeAt(i1 - 1, k1, k) || world.canLightningStrikeAt(i1 + 1, k1, j1) || world.canLightningStrikeAt(i1, k1, j1 - 1) || world.canLightningStrikeAt(i1, k1, j1 + 1))) {
                            int k2 = l + random.nextInt(5) / 4;
                            if (k2 > 15) {
                                k2 = 15;
                            }
                            world.setBlockAndMetadataWithNotify(i1, k1, j1, this.blockID, k2);
                        }
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
    }

    private void tryToCatchBlockOnFire(World world, int i, int j, int k, int l, Random random) {
        int i1 = this.abilityToCatchFire[world.getBlockId(i, j, k)];
        if (random.nextInt(l) < i1) {
            boolean flag;
            boolean bl = flag = world.getBlockId(i, j, k) == Block.tnt.blockID;
            if (random.nextInt(2) == 0) {
                world.setBlockWithNotify(i, j, k, this.blockID);
            } else {
                world.setBlockWithNotify(i, j, k, 0);
            }
            if (flag) {
                Block.tnt.onBlockDestroyedByPlayer(world, i, j, k, 0);
            }
        }
    }

    private void tryToCatchBlockOnFire(World world, int i, int j, int k, int l, Random random, int i1) {
        int j1 = this.abilityToCatchFire[world.getBlockId(i, j, k)];
        if (random.nextInt(l) < j1) {
            boolean flag;
            boolean bl = flag = world.getBlockId(i, j, k) == Block.tnt.blockID;
            if (random.nextInt(i1 + 10) < 5 && !world.canLightningStrikeAt(i, j, k)) {
                int k1 = i1 + random.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, k1);
            } else {
                world.setBlockWithNotify(i, j, k, 0);
            }
            if (flag) {
                Block.tnt.onBlockDestroyedByPlayer(world, i, j, k, 1);
            }
        }
    }

    private boolean func_263_h(World world, int i, int j, int k) {
        if (this.canBlockCatchFire(world, i + 1, j, k)) {
            return true;
        }
        if (this.canBlockCatchFire(world, i - 1, j, k)) {
            return true;
        }
        if (this.canBlockCatchFire(world, i, j - 1, k)) {
            return true;
        }
        if (this.canBlockCatchFire(world, i, j + 1, k)) {
            return true;
        }
        if (this.canBlockCatchFire(world, i, j, k - 1)) {
            return true;
        }
        return this.canBlockCatchFire(world, i, j, k + 1);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int i, int j, int k) {
        int l = 0;
        if (!world.isAirBlock(i, j, k)) {
            return 0;
        }
        l = this.getChanceToEncourageFire(world, i + 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i - 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i, j - 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j + 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j, k - 1, l);
        l = this.getChanceToEncourageFire(world, i, j, k + 1, l);
        return l;
    }

    public boolean isCollidable() {
        return false;
    }

    public boolean canBlockCatchFire(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.chanceToEncourageFire[iblockaccess.getBlockId(i, j, k)] > 0;
    }

    public int getChanceToEncourageFire(World world, int i, int j, int k, int l) {
        int i1 = this.chanceToEncourageFire[world.getBlockId(i, j, k)];
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k) || this.func_263_h(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!world.isBlockNormalCube(i, j - 1, k) && !this.func_263_h(world, i, j, k)) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.isBlockNormalCube(i, j - 1, k) && !this.func_263_h(world, i, j, k)) {
            world.setBlockWithNotify(i, j, k, 0);
            return;
        }
        world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
    }
}

