/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluid;
import com.mojang.minecraft.level.tile.BlockSponge;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockFlowing
extends BlockFluid {
    int field_659_a = 0;
    boolean[] field_658_b = new boolean[4];
    int[] field_660_c = new int[4];

    protected BlockFlowing(int i, Material material) {
        super(i, material);
    }

    private void func_30004_i(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.setBlockAndMetadata(i, j, k, this.blockID + 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.markBlockNeedsUpdate(i, j, k);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        int l = this.func_301_g(world, i, j, k);
        int byte0 = 1;
        if (this.blockMaterial == Material.lava && !world.worldProvider.isHellWorld) {
            byte0 = 2;
        }
        boolean flag = true;
        if (l > 0) {
            int i1 = -100;
            this.field_659_a = 0;
            i1 = this.func_307_e(world, i - 1, j, k, i1);
            i1 = this.func_307_e(world, i + 1, j, k, i1);
            i1 = this.func_307_e(world, i, j, k - 1, i1);
            int j1 = (i1 = this.func_307_e(world, i, j, k + 1, i1)) + byte0;
            if (j1 >= 8 || i1 < 0) {
                j1 = -1;
            }
            if (this.func_301_g(world, i, j + 1, k) >= 0) {
                int l1 = this.func_301_g(world, i, j + 1, k);
                j1 = l1 >= 8 ? l1 : l1 + 8;
            }
            if (this.field_659_a >= 2 && this.blockMaterial == Material.water) {
                if (world.getMaterialXYZ(i, j - 1, k).isSolidMaterial() || world.isWater(i, j - 1, k)) {
                    j1 = 0;
                } else if (world.getMaterialXYZ(i, j - 1, k) == this.blockMaterial && world.getBlockMetadata(i, j, k) == 0 && !BlockSponge.getSurroundSponge(world, i, j, k)) {
                    j1 = 0;
                }
            }
            if (this.blockMaterial == Material.lava && l < 8 && j1 < 8 && j1 > l && random.nextInt(4) != 0) {
                j1 = l;
                flag = false;
            }
            if (j1 != l) {
                l = j1;
                if (l < 0) {
                    world.setBlockWithNotify(i, j, k, 0);
                } else {
                    world.setBlockMetadataWithNotify(i, j, k, l);
                    world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
                    world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
                }
            } else if (flag) {
                this.func_30004_i(world, i, j, k);
            }
        } else {
            this.func_30004_i(world, i, j, k);
        }
        if (this.func_312_l(world, i, j - 1, k)) {
            if (l >= 8) {
                world.setBlockAndMetadataWithNotify(i, j - 1, k, this.blockID, l);
            } else {
                world.setBlockAndMetadataWithNotify(i, j - 1, k, this.blockID, l + 8);
            }
        } else if (l >= 0 && (l == 0 || this.func_309_k(world, i, j - 1, k))) {
            boolean[] aflag = this.func_4035_j(world, i, j, k);
            int k1 = l + byte0;
            if (l >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (aflag[0]) {
                this.func_311_f(world, i - 1, j, k, k1);
            }
            if (aflag[1]) {
                this.func_311_f(world, i + 1, j, k, k1);
            }
            if (aflag[2]) {
                this.func_311_f(world, i, j, k - 1, k1);
            }
            if (aflag[3]) {
                this.func_311_f(world, i, j, k + 1, k1);
            }
        }
    }

    private void func_311_f(World world, int i, int j, int k, int l) {
        if (this.func_312_l(world, i, j, k)) {
            int i1 = world.getBlockId(i, j, k);
            if (i1 > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.func_300_h(world, i, j, k);
                } else {
                    Block.allBlocks[i1].dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                }
            }
            world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, l);
        }
    }

    private int func_4034_a(World world, int i, int j, int k, int l, int i1) {
        int j1 = 1000;
        int k1 = 0;
        while (k1 < 4) {
            if (!(k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2)) {
                int l1 = i;
                int i2 = j;
                int j2 = k;
                if (k1 == 0) {
                    --l1;
                }
                if (k1 == 1) {
                    ++l1;
                }
                if (k1 == 2) {
                    --j2;
                }
                if (k1 == 3) {
                    ++j2;
                }
                if (!(this.func_309_k(world, l1, i2, j2) || world.getMaterialXYZ(l1, i2, j2) == this.blockMaterial && world.getBlockMetadata(l1, i2, j2) == 0)) {
                    int k2;
                    if (!this.func_309_k(world, l1, i2 - 1, j2)) {
                        return l;
                    }
                    if (l < 4 && (k2 = this.func_4034_a(world, l1, i2, j2, l + 1, k1)) < j1) {
                        j1 = k2;
                    }
                }
            }
            ++k1;
        }
        return j1;
    }

    private boolean[] func_4035_j(World world, int i, int j, int k) {
        int l = 0;
        while (l < 4) {
            this.field_660_c[l] = 1000;
            int j1 = i;
            int i2 = j;
            int j2 = k;
            if (l == 0) {
                --j1;
            }
            if (l == 1) {
                ++j1;
            }
            if (l == 2) {
                --j2;
            }
            if (l == 3) {
                ++j2;
            }
            if (!(this.func_309_k(world, j1, i2, j2) || world.getMaterialXYZ(j1, i2, j2) == this.blockMaterial && world.getBlockMetadata(j1, i2, j2) == 0)) {
                this.field_660_c[l] = !this.func_309_k(world, j1, i2 - 1, j2) ? 0 : this.func_4034_a(world, j1, i2, j2, 1, l);
            }
            ++l;
        }
        int i1 = this.field_660_c[0];
        int k1 = 1;
        while (k1 < 4) {
            if (this.field_660_c[k1] < i1) {
                i1 = this.field_660_c[k1];
            }
            ++k1;
        }
        int l1 = 0;
        while (l1 < 4) {
            this.field_658_b[l1] = this.field_660_c[l1] == i1;
            ++l1;
        }
        return this.field_658_b;
    }

    private boolean func_309_k(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        if (l == Block.doorWood.blockID || BlockSponge.getSurroundSponge(world, i, j, k) || l == Block.doorSteel.blockID || l == Block.signPost.blockID || l == Block.ladder.blockID || l == Block.reed.blockID) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        Material material = Block.allBlocks[l].blockMaterial;
        return material.blocksMovement();
    }

    protected int func_307_e(World world, int i, int j, int k, int l) {
        int i1 = this.func_301_g(world, i, j, k);
        if (i1 < 0) {
            return l;
        }
        if (i1 == 0) {
            ++this.field_659_a;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return l >= 0 && i1 >= l ? l : i1;
    }

    private boolean func_312_l(World world, int i, int j, int k) {
        Material material = world.getMaterialXYZ(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.func_309_k(world, i, j, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.getBlockId(i, j, k) == this.blockID) {
            world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
        }
    }
}

