/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public abstract class BlockFluid
extends Block {
    protected BlockFluid(int i, Material material) {
        super(i, (material != Material.lava ? 12 : 14) * 16 + 13, material);
        float f = 0.0f;
        float f1 = 0.0f;
        this.setBlockBounds(0.0f + f1, 0.0f + f, 0.0f + f1, 1.0f + f1, 1.0f + f, 1.0f + f1);
        this.setTickOnLoad(true);
    }

    public static float setFluidHeight(int i) {
        if (i >= 8) {
            i = 0;
        }
        float f = (float)(i + 1) / 9.0f;
        return f;
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 0 || i == 1) {
            return this.blockIndexInTexture;
        }
        return this.blockIndexInTexture + 1;
    }

    protected int func_301_g(World world, int i, int j, int k) {
        if (world.getMaterialXYZ(i, j, k) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(i, j, k);
    }

    protected int func_303_b(IBlockAccess iblockaccess, int i, int j, int k) {
        if (iblockaccess.getMaterialXYZ(i, j, k) != this.blockMaterial) {
            return -1;
        }
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public boolean isACube() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canCollideCheck(int i, boolean flag) {
        return flag && i == 0;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getMaterialXYZ(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public int idDropped(int i, Random random) {
        return 0;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    private Vec3D func_298_c(IBlockAccess iblockaccess, int i, int j, int k) {
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int l = this.func_303_b(iblockaccess, i, j, k);
        int i1 = 0;
        while (i1 < 4) {
            int i2;
            int j1 = i;
            int k1 = j;
            int l1 = k;
            if (i1 == 0) {
                --j1;
            }
            if (i1 == 1) {
                --l1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++l1;
            }
            if ((i2 = this.func_303_b(iblockaccess, j1, k1, l1)) < 0) {
                if (!iblockaccess.getMaterialXYZ(j1, k1, l1).blocksMovement() && (i2 = this.func_303_b(iblockaccess, j1, k1 - 1, l1)) >= 0) {
                    int j2 = i2 - (l - 8);
                    vec3d = vec3d.addVector((j1 - i) * j2, (k1 - j) * j2, (l1 - k) * j2);
                }
            } else if (i2 >= 0) {
                int k2 = i2 - l;
                vec3d = vec3d.addVector((j1 - i) * k2, (k1 - j) * k2, (l1 - k) * k2);
            }
            ++i1;
        }
        if (iblockaccess.getBlockMetadata(i, j, k) >= 8) {
            boolean flag = false;
            if (flag || this.shouldSideBeRendered(iblockaccess, i, j, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i, j, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i - 1, j, k, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i + 1, j, k, 5)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i, j + 1, k - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i, j + 1, k + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i - 1, j + 1, k, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, i + 1, j + 1, k, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.normalize();
        return vec3d;
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        Vec3D vec3d1 = this.func_298_c(world, i, j, k);
        vec3d.xCoord += vec3d1.xCoord;
        vec3d.yCoord += vec3d1.yCoord;
        vec3d.zCoord += vec3d1.zCoord;
    }

    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        this.checkForHarden(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.checkForHarden(world, i, j, k);
    }

    private void checkForHarden(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            boolean flag = false;
            if (flag || world.getMaterialXYZ(i, j, k - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j, k + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i - 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i + 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j + 1, k) == Material.water) {
                flag = true;
            }
            if (flag) {
                int l = world.getBlockMetadata(i, j, k);
                if (l == 0) {
                    world.setBlockWithNotify(i, j, k, Block.obsidian.blockID);
                    if (new Random().nextInt(500) == 1) {
                        world.setBlockWithNotify(i, j, k, Block.bleedingObsidian.blockID);
                    }
                } else if (l <= 4) {
                    world.setBlockWithNotify(i, j, k, Block.cobblestone.blockID);
                }
                this.func_300_h(world, i, j, k);
            }
        }
    }

    protected void func_300_h(World world, int i, int j, int k) {
        world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        int l = 0;
        while (l < 8) {
            world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + 1.2, (double)k + Math.random(), 0.0, 0.0, 0.0);
            ++l;
        }
    }
}

