/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MathHelper;
import java.util.Random;

public class BlockFurnace
extends BlockContainer {
    private Random field_28033_a = new Random();
    private final boolean isActive;
    private static boolean field_28034_c = false;

    protected BlockFurnace(int i, boolean flag) {
        super(i, Material.rock);
        this.isActive = flag;
        this.blockIndexInTexture = 45;
    }

    public int idDropped(int i, Random random) {
        return Block.stoneOvenIdle.blockID;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    private void setDefaultDirection(World world, int i, int j, int k) {
        if (world.singleplayerWorld) {
            return;
        }
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, byte0);
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 1) {
            return this.blockIndexInTexture + 17;
        }
        if (i == 0) {
            return this.blockIndexInTexture + 17;
        }
        if (i == 3) {
            return this.blockIndexInTexture - 1;
        }
        return this.blockIndexInTexture;
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.singleplayerWorld) {
            return true;
        }
        TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i, j, k);
        entityplayer.displayGUIFurnace(tileentityfurnace);
        return true;
    }

    public static void updateFurnaceBlockState(boolean flag, World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        TileEntity tileentity = world.getBlockTileEntity(i, j, k);
        field_28034_c = true;
        if (flag) {
            world.setBlockWithNotify(i, j, k, Block.stoneOvenActive.blockID);
        } else {
            world.setBlockWithNotify(i, j, k, Block.stoneOvenIdle.blockID);
        }
        field_28034_c = false;
        world.setBlockMetadataWithNotify(i, j, k, l);
        tileentity.validate();
        world.setBlockTileEntity(i, j, k, tileentity);
    }

    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (l == 0) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        }
        if (l == 1) {
            world.setBlockMetadataWithNotify(i, j, k, 5);
        }
        if (l == 2) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        }
        if (l == 3) {
            world.setBlockMetadataWithNotify(i, j, k, 4);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        if (!field_28034_c) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(i, j, k);
            int l = 0;
            while (l < tileentityfurnace.getSizeInventory()) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(l);
                if (itemstack != null) {
                    float f = this.field_28033_a.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.field_28033_a.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.field_28033_a.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.stackSize > 0) {
                        int i1 = this.field_28033_a.nextInt(21) + 10;
                        if (i1 > itemstack.stackSize) {
                            i1 = itemstack.stackSize;
                        }
                        itemstack.stackSize -= i1;
                        EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.getItemDamage()));
                        float f3 = 0.05f;
                        entityitem.motionX = (float)this.field_28033_a.nextGaussian() * f3;
                        entityitem.motionY = (float)this.field_28033_a.nextGaussian() * f3 + 0.2f;
                        entityitem.motionZ = (float)this.field_28033_a.nextGaussian() * f3;
                        world.entityJoinedWorld(entityitem);
                    }
                }
                ++l;
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }
}

