/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockBreakable;
import com.mojang.minecraft.level.tile.BlockBurntCloth;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockIce
extends BlockBreakable {
    public BlockIce(int i, int j) {
        super(i, j, Material.ice, false);
        this.slipperiness = 0.98f;
        this.setTickOnLoad(true);
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        super.harvestBlock(world, entityplayer, i, j, k, l);
        Material material = world.getMaterialXYZ(i, j - 1, k);
        if (material.blocksMovement() || material.getIsLiquid()) {
            world.setBlockWithNotify(i, j, k, Block.waterMoving.blockID);
        }
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (BlockBurntCloth.getSurroundHotBlock(world, i, j, k)) {
            return false;
        }
        return super.canPlace(world, i, j, k);
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.getSavedLightValue(EnumSkyBlock.Block, i, j, k) > 11 - Block.lightOpacity[this.blockID]) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, Block.waterStill.blockID);
        }
    }

    public int getMobilityFlag() {
        return 0;
    }
}

