/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityRecordPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;

public class BlockJukeBox
extends BlockContainer {
    protected BlockJukeBox(int i, int j) {
        super(i, j, Material.wood);
    }

    public int getBlockTextureFromSide(int i) {
        return this.blockIndexInTexture + (i != 1 ? 0 : 1);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        this.func_28035_b_(world, i, j, k);
        return true;
    }

    public void ejectRecord(World world, int i, int j, int k, int l) {
        if (world.singleplayerWorld) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
        tileentityrecordplayer.field_28009_a = l;
        tileentityrecordplayer.onInventoryChanged();
        world.setBlockMetadataWithNotify(i, j, k, 1);
    }

    public void func_28035_b_(World world, int i, int j, int k) {
        if (world.singleplayerWorld) {
            return;
        }
        TileEntityRecordPlayer tileentityrecordplayer = (TileEntityRecordPlayer)world.getBlockTileEntity(i, j, k);
        int l = tileentityrecordplayer.field_28009_a;
        if (l == 0) {
            return;
        }
        world.func_28097_e(1005, i, j, k, 0);
        world.playRecord(null, i, j, k);
        tileentityrecordplayer.field_28009_a = 0;
        tileentityrecordplayer.onInventoryChanged();
        world.setBlockMetadataWithNotify(i, j, k, 0);
        int i1 = l;
        float f = 0.7f;
        double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
        double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        this.func_28035_b_(world, i, j, k);
        super.onBlockRemoval(world, i, j, k);
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.singleplayerWorld) {
            return;
        }
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
    }

    protected TileEntity getBlockEntity() {
        return new TileEntityRecordPlayer();
    }
}

