/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.enums.EnumSeason;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockLeavesBase;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockLeaves
extends BlockLeavesBase {
    public static final int radius = 4;
    private int baseIndexInPNG;
    int[] adjacentTreeBlocks;

    protected BlockLeaves(int i, int j) {
        super(i, j, Material.leaves, false);
        this.baseIndexInPNG = j;
        this.setTickOnLoad(true);
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        int l = 1;
        int i1 = l + 1;
        if (world.checkChunksExist(i - i1, j - i1, k - i1, i + i1, j + i1, k + i1)) {
            int j1 = -l;
            while (j1 <= l) {
                int k1 = -l;
                while (k1 <= l) {
                    int l1 = -l;
                    while (l1 <= l) {
                        int i2 = world.getBlockId(i + j1, j + k1, k + l1);
                        if (i2 == Block.leaves.blockID) {
                            int j2 = world.getBlockMetadata(i + j1, j + k1, k + l1);
                            world.setBlockMetadata(i + j1, j + k1, k + l1, j2 | 8);
                        }
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
        }
    }

    public boolean getConnectLog(World world, int x, int y, int z) {
        int x1 = x - 4;
        while (x1 <= x + 4) {
            int z1 = z - 4;
            while (z1 <= z + 4) {
                int y1 = y - 4;
                while (y1 <= y + 4) {
                    if (world.getBlockId(x1, y1, z1) == Block.wood.blockID || world.getBlockId(x1, y1, z1) == Block.brickMossy.blockID) {
                        return true;
                    }
                    ++y1;
                }
                ++z1;
            }
            ++x1;
        }
        return false;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (!this.getConnectLog(world, i, j, k)) {
            EntityItem entityitem;
            world.setBlockWithNotify(i, j, k, 0);
            if (random.nextInt(10) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            if (random.nextInt(128) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            if (random.nextInt(10000) == 0) {
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
        }
    }

    private void removeLeaves(World world, int i, int j, int k) {
        this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
        world.setBlockWithNotify(i, j, k, 0);
    }

    public int idDropped(int i, Random random) {
        return 0;
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l) {
        EntityItem entityitem;
        super.dropBlockAsItemWithChance(world, i, j, k, l, 1.0f);
        Random random = new Random();
        if (random.nextInt(this.dropChance(world, 0)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
        if (random.nextInt(this.dropChance(world, 0)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
        if (random.nextInt(this.dropChance(world, 0)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    private int dropChance(World world, int item) {
        int chance = 0;
        if (item == 0) {
            chance = 40;
        }
        if (item == 1) {
            chance = 128;
        }
        if (item == 2) {
            chance = 10000;
        }
        if (world.season == EnumSeason.cycle) {
            if (world.getCurrentSeason() == EnumSeason.summer) {
                if (item == 0) {
                    chance = 40;
                }
                if (item == 1) {
                    chance = 256;
                }
                if (item == 2) {
                    chance = 20000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.fall) {
                if (item == 0) {
                    chance = 60;
                }
                if (item == 1) {
                    chance = 128;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.winter) {
                if (item == 0) {
                    chance = 100;
                }
                if (item == 1) {
                    chance = 512;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.spring) {
                if (item == 0) {
                    chance = 30;
                }
                if (item == 1) {
                    chance = 512;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
        }
        return chance;
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        super.harvestBlock(world, entityplayer, i, j, k, l);
    }

    protected int damageDropped(int i) {
        return i & 3;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if ((j & 3) == 1) {
            return this.blockIndexInTexture + 80;
        }
        return this.blockIndexInTexture;
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        super.onEntityWalking(world, i, j, k, entity);
    }
}

