/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockLog
extends Block {
    protected BlockLog(int i) {
        super(i, Material.wood);
        this.blockIndexInTexture = 20;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int idDropped(int i, Random random) {
        return Block.wood.blockID;
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        super.harvestBlock(world, entityplayer, i, j, k, l);
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        int byte0 = 4;
        int l = byte0 + 1;
        if (world.checkChunksExist(i - l, j - l, k - l, i + l, j + l, k + l)) {
            int i1 = -byte0;
            while (i1 <= byte0) {
                int j1 = -byte0;
                while (j1 <= byte0) {
                    int k1 = -byte0;
                    while (k1 <= byte0) {
                        int i2;
                        int l1 = world.getBlockId(i + i1, j + j1, k + k1);
                        if (l1 == Block.leaves.blockID && ((i2 = world.getBlockMetadata(i + i1, j + j1, k + k1)) & 8) == 0) {
                            world.setBlockMetadata(i + i1, j + j1, k + k1, i2 | 8);
                        }
                        ++k1;
                    }
                    ++j1;
                }
                ++i1;
            }
        }
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1) {
            return 21;
        }
        if (i == 0) {
            return 21;
        }
        if (j == 1) {
            return 116;
        }
        return j != 2 ? 20 : 117;
    }

    protected int damageDropped(int i) {
        return i;
    }
}

