/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockMushroom
extends BlockFlower {
    protected BlockMushroom(int i, int j) {
        super(i, j);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTickOnLoad(true);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int l;
        if (random.nextInt(100) == 0 && world.isAirBlock(l = i + random.nextInt(3) - 1, i1 = j + random.nextInt(2) - random.nextInt(2), j1 = k + random.nextInt(3) - 1) && this.canBlockStay(world, l, i1, j1)) {
            i += random.nextInt(3) - 1;
            k += random.nextInt(3) - 1;
            if (world.isAirBlock(l, i1, j1) && this.canBlockStay(world, l, i1, j1)) {
                world.setBlockWithNotify(l, i1, j1, this.blockID);
            }
        }
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return Block.opaqueCubeLookup[i];
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        if (j < 0 || j >= 128) {
            return false;
        }
        return world.getBlockLightValueNoChecks(i, j, k) < 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(i, j - 1, k));
    }
}

