/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.List;
import java.util.Random;

public class BlockPressurePlate
extends Block {
    private EnumMobType triggerMobType;

    protected BlockPressurePlate(int i, int j, EnumMobType enummobtype, Material material) {
        super(i, j, material);
        this.triggerMobType = enummobtype;
        this.setTickOnLoad(true);
        float f = 0.0625f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    public int tickRate() {
        return 20;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k) || world.getBlockId(i, j - 1, k) == Block.fence.blockID || world.getBlockId(i, j - 1, k) == Block.glass.blockID;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k) && world.getBlockId(i, j - 1, k) != Block.fence.blockID) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.singleplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i, j, k) == 0) {
            return;
        }
        this.setStateIfMobInteractsWithPlate(world, i, j, k);
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (world.singleplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i, j, k) == 1) {
            return;
        }
        this.setStateIfMobInteractsWithPlate(world, i, j, k);
    }

    private void setStateIfMobInteractsWithPlate(World world, int i, int j, int k) {
        boolean flag = world.getBlockMetadata(i, j, k) == 1;
        boolean flag1 = false;
        float f = 0.125f;
        List list = null;
        if (this.triggerMobType == EnumMobType.everything) {
            list = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.mobs) {
            list = world.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.players) {
            list = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l > 0) {
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        boolean flag = iblockaccess.getBlockMetadata(i, j, k) == 1;
        float f = 0.0625f;
        if (flag) {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return iblockaccess.getBlockMetadata(i, j, k) > 0;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        return l == 1;
    }

    public boolean canProvidePower() {
        return true;
    }

    public int getMobilityFlag() {
        return 1;
    }
}

