/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MathHelper;

public class BlockPumpkin
extends Block {
    private boolean blockType;

    protected BlockPumpkin(int i, int j, boolean flag) {
        super(i, Material.pumpkin);
        this.blockIndexInTexture = j;
        this.setTickOnLoad(true);
        this.blockType = flag;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1) {
            return this.blockIndexInTexture;
        }
        if (i == 0) {
            return this.blockIndexInTexture;
        }
        int k = this.blockIndexInTexture + 1 + 16;
        if (this.blockType) {
            ++k;
        }
        if (j == 2 && i == 2) {
            return k;
        }
        if (j == 3 && i == 5) {
            return k;
        }
        if (j == 0 && i == 3) {
            return k;
        }
        if (j == 1 && i == 4) {
            return k;
        }
        return this.blockIndexInTexture + 16;
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 1) {
            return this.blockIndexInTexture;
        }
        if (i == 0) {
            return this.blockIndexInTexture;
        }
        if (i == 3) {
            return this.blockIndexInTexture + 1 + 16;
        }
        return this.blockIndexInTexture + 16;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return (l == 0 || Block.allBlocks[l].blockMaterial.func_27090_g()) && world.isBlockNormalCube(i, j - 1, k);
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 2.5) & 3;
        world.setBlockMetadataWithNotify(i, j, k, l);
    }
}

