/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.RailLogic;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockRail
extends Block {
    private final boolean field_27034_a;

    public static final boolean func_27029_g(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == Block.minecartTrack.blockID;
    }

    public static final boolean func_27030_c(int i) {
        return i == Block.minecartTrack.blockID;
    }

    protected BlockRail(int i, int j, boolean flag) {
        super(i, j, Material.circuits);
        this.field_27034_a = flag;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public boolean func_27028_d() {
        return this.field_27034_a;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (!this.field_27034_a && j >= 6) {
            return this.blockIndexInTexture - 16;
        }
        return this.blockIndexInTexture;
    }

    public boolean isACube() {
        return false;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.singleplayerWorld) {
            this.func_4038_g(world, i, j, k, true);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1;
        if (world.singleplayerWorld) {
            return;
        }
        int j1 = i1 = world.getBlockMetadata(i, j, k);
        if (this.field_27034_a) {
            j1 &= 7;
        }
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k)) {
            flag = true;
        }
        if (j1 == 2 && !world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (j1 == 3 && !world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (j1 == 4 && !world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (j1 == 5 && !world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        } else if (l > 0 && Block.allBlocks[l].canProvidePower() && !this.field_27034_a && RailLogic.getNAdjacentTracks(new RailLogic(this, world, i, j, k)) == 3) {
            this.func_4038_g(world, i, j, k, false);
        }
    }

    private void func_4038_g(World world, int i, int j, int k, boolean flag) {
        if (world.singleplayerWorld) {
            return;
        }
        new RailLogic(this, world, i, j, k).func_596_a(world.isBlockIndirectlyGettingPowered(i, j, k), flag);
    }

    private boolean func_27032_a(World world, int i, int j, int k, int l, boolean flag, int i1) {
        if (i1 >= 8) {
            return false;
        }
        int j1 = l & 7;
        boolean flag1 = true;
        switch (j1) {
            case 0: {
                if (flag) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (flag) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (flag) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag1 = false;
                }
                j1 = 1;
                break;
            }
            case 3: {
                if (flag) {
                    --i;
                    ++j;
                    flag1 = false;
                } else {
                    ++i;
                }
                j1 = 1;
                break;
            }
            case 4: {
                if (flag) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag1 = false;
                }
                j1 = 0;
                break;
            }
            case 5: {
                if (flag) {
                    ++k;
                    ++j;
                    flag1 = false;
                } else {
                    --k;
                }
                j1 = 0;
            }
        }
        if (this.func_27031_a(world, i, j, k, flag, i1, j1)) {
            return true;
        }
        return flag1 && this.func_27031_a(world, i, j - 1, k, flag, i1, j1);
    }

    private boolean func_27031_a(World world, int i, int j, int k, boolean flag, int l, int i1) {
        int j1 = world.getBlockId(i, j, k);
        return false;
    }

    public int getMobilityFlag() {
        return 0;
    }

    static boolean func_27033_a(BlockRail blockrail) {
        return blockrail.field_27034_a;
    }
}

