/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockTorch;
import com.mojang.minecraft.level.tile.RedstoneUpdateInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockRedstoneTorch
extends BlockTorch {
    private boolean torchActive = false;
    private static List torchUpdates = new ArrayList();

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1) {
            return Block.redstoneWire.getBlockTextureFromSideAndMetadata(i, j);
        }
        return super.getBlockTextureFromSideAndMetadata(i, j);
    }

    private boolean checkForBurnout(World world, int i, int j, int k, boolean flag) {
        if (flag) {
            torchUpdates.add(new RedstoneUpdateInfo(i, j, k, world.getWorldTime()));
        }
        int l = 0;
        int i1 = 0;
        while (i1 < torchUpdates.size()) {
            RedstoneUpdateInfo redstoneupdateinfo = (RedstoneUpdateInfo)torchUpdates.get(i1);
            if (redstoneupdateinfo.x == i && redstoneupdateinfo.y == j && redstoneupdateinfo.z == k && ++l >= 8) {
                return true;
            }
            ++i1;
        }
        return false;
    }

    protected BlockRedstoneTorch(int i, int j, boolean flag) {
        super(i, j);
        this.torchActive = flag;
        this.setTickOnLoad(true);
    }

    public int tickRate() {
        return 2;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            super.onBlockAdded(world, i, j, k);
        }
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        }
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (!this.torchActive) {
            return false;
        }
        int i1 = iblockaccess.getBlockMetadata(i, j, k);
        if (i1 == 5 && l == 1) {
            return false;
        }
        if (i1 == 3 && l == 3) {
            return false;
        }
        if (i1 == 4 && l == 2) {
            return false;
        }
        if (i1 == 1 && l == 5) {
            return false;
        }
        return i1 != 2 || l != 4;
    }

    private boolean func_30003_g(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 5 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l == 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l == 4 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l == 1 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return l == 2 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        boolean flag = this.func_30003_g(world, i, j, k);
        while (torchUpdates.size() > 0 && world.getWorldTime() - ((RedstoneUpdateInfo)BlockRedstoneTorch.torchUpdates.get((int)0)).updateTime > 100L) {
            torchUpdates.remove(0);
        }
        if (this.torchActive) {
            if (flag) {
                world.setBlockAndMetadataWithNotify(i, j, k, Block.torchRedstoneIdle.blockID, world.getBlockMetadata(i, j, k));
                if (this.checkForBurnout(world, i, j, k, true)) {
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                    int l = 0;
                    while (l < 5) {
                        double d = (double)i + random.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)j + random.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)k + random.nextDouble() * 0.6 + 0.2;
                        world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
                        ++l;
                    }
                }
            }
        } else if (!flag && !this.checkForBurnout(world, i, j, k, false)) {
            world.setBlockAndMetadataWithNotify(i, j, k, Block.torchRedstoneActive.blockID, world.getBlockMetadata(i, j, k));
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        world.scheduleUpdateTick(i, j, k, this.blockID, this.tickRate());
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (l == 0) {
            return this.isPoweringTo(world, i, j, k, l);
        }
        return false;
    }

    public int idDropped(int i, Random random) {
        return Block.torchRedstoneActive.blockID;
    }

    public boolean canProvidePower() {
        return true;
    }
}

