/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;
    private Set field_21032_b = new HashSet();

    public BlockRedstoneWire(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.blockIndexInTexture;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    private void updateAndPropagateCurrentStrength(World world, int i, int j, int k) {
        this.func_21031_a(world, i, j, k, i, j, k);
        ArrayList arraylist = new ArrayList(this.field_21032_b);
        this.field_21032_b.clear();
        int l = 0;
        while (l < arraylist.size()) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l);
            world.notifyBlocksOfNeighborChange(chunkposition.x, chunkposition.y, chunkposition.z, this.blockID);
            ++l;
        }
    }

    private void func_21031_a(World world, int i, int j, int k, int l, int i1, int j1) {
        int k1 = world.getBlockMetadata(i, j, k);
        int l1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k);
        this.wiresProvidePower = true;
        if (flag) {
            l1 = 15;
        } else {
            int i2 = 0;
            while (i2 < 4) {
                int k2 = i;
                int i3 = k;
                if (i2 == 0) {
                    --k2;
                }
                if (i2 == 1) {
                    ++k2;
                }
                if (i2 == 2) {
                    --i3;
                }
                if (i2 == 3) {
                    ++i3;
                }
                if (k2 != l || j != i1 || i3 != j1) {
                    l1 = this.getMaxCurrentStrength(world, k2, j, i3, l1);
                }
                if (world.isBlockNormalCube(k2, j, i3) && !world.isBlockNormalCube(i, j + 1, k)) {
                    if (k2 != l || j + 1 != i1 || i3 != j1) {
                        l1 = this.getMaxCurrentStrength(world, k2, j + 1, i3, l1);
                    }
                } else if (!(world.isBlockNormalCube(k2, j, i3) || k2 == l && j - 1 == i1 && i3 == j1)) {
                    l1 = this.getMaxCurrentStrength(world, k2, j - 1, i3, l1);
                }
                ++i2;
            }
            l1 = l1 > 0 ? --l1 : 0;
        }
        if (k1 != l1) {
            world.editingBlocks = true;
            world.setBlockMetadataWithNotify(i, j, k, l1);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.editingBlocks = false;
            int j2 = 0;
            while (j2 < 4) {
                int l2 = i;
                int j3 = k;
                int k3 = j - 1;
                if (j2 == 0) {
                    --l2;
                }
                if (j2 == 1) {
                    ++l2;
                }
                if (j2 == 2) {
                    --j3;
                }
                if (j2 == 3) {
                    ++j3;
                }
                if (world.isBlockNormalCube(l2, j, j3)) {
                    k3 += 2;
                }
                int l3 = 0;
                l3 = this.getMaxCurrentStrength(world, l2, j, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21031_a(world, l2, j, j3, i, j, k);
                }
                l3 = this.getMaxCurrentStrength(world, l2, k3, j3, -1);
                l1 = world.getBlockMetadata(i, j, k);
                if (l1 > 0) {
                    --l1;
                }
                if (l3 >= 0 && l3 != l1) {
                    this.func_21031_a(world, l2, k3, j3, i, j, k);
                }
                ++j2;
            }
            if (k1 == 0 || l1 == 0) {
                this.field_21032_b.add(new ChunkPosition(i, j, k));
                this.field_21032_b.add(new ChunkPosition(i - 1, j, k));
                this.field_21032_b.add(new ChunkPosition(i + 1, j, k));
                this.field_21032_b.add(new ChunkPosition(i, j - 1, k));
                this.field_21032_b.add(new ChunkPosition(i, j + 1, k));
                this.field_21032_b.add(new ChunkPosition(i, j, k - 1));
                this.field_21032_b.add(new ChunkPosition(i, j, k + 1));
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.singleplayerWorld) {
            return;
        }
        this.updateAndPropagateCurrentStrength(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        super.onBlockRemoval(world, i, j, k);
        if (world.singleplayerWorld) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.updateAndPropagateCurrentStrength(world, i, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return l;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.singleplayerWorld) {
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = this.canPlace(world, i, j, k);
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        } else {
            this.updateAndPropagateCurrentStrength(world, i, j, k);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    public int idDropped(int i, Random random) {
        return Item.redstone.shiftedIndex;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, i, j, k, l);
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j, k, 1) || !iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j - 1, k, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j, k, 3) || !iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j - 1, k, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j, k - 1, 2) || !iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j, k + 1, 0) || !iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k + 1, -1);
        if (!iblockaccess.isBlockNormalCube(i, j + 1, k)) {
            if (iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i - 1, j + 1, k, -1)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i + 1, j + 1, k, -1)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k - 1, -1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k + 1, -1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l < 2 || l > 5)) {
            return true;
        }
        if (l == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l == 5 && flag1 && !flag2 && !flag3;
    }

    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    public static boolean isPowerProviderOrWire(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int i1 = iblockaccess.getBlockId(i, j, k);
        if (i1 == Block.redstoneWire.blockID) {
            return true;
        }
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].canProvidePower();
    }
}

