/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.enums.EnumSeason;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenBigTree;
import com.mojang.minecraft.level.generate.WorldGenForest;
import com.mojang.minecraft.level.generate.WorldGenTaiga2;
import com.mojang.minecraft.level.generate.WorldGenTrees;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockSapling
extends BlockFlower {
    protected BlockSapling(int i, int j) {
        super(i, j);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.singleplayerWorld) {
            return;
        }
        super.updateTick(world, i, j, k, random);
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && random.nextInt(this.growthChance(world)) == 0) {
            int l = world.getBlockMetadata(i, j, k);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(i, j, k, l | 8);
            } else {
                this.growTree(world, i, j, k, random);
            }
        }
    }

    private int growthChance(World world) {
        int chance = 5;
        if (world.season == EnumSeason.cycle) {
            if (world.getCurrentSeason() == EnumSeason.fall) {
                chance = 15;
            }
            if (world.getCurrentSeason() == EnumSeason.winter) {
                chance = 50;
            }
            if (world.getCurrentSeason() == EnumSeason.spring) {
                chance = 3;
            }
        }
        return chance;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if ((j &= 3) == 1) {
            return 63;
        }
        if (j == 2) {
            return 79;
        }
        return super.getBlockTextureFromSideAndMetadata(i, j);
    }

    public void growTree(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k) & 3;
        world.setBlock(i, j, k, 0);
        WorldGenerator obj = null;
        if (l == 1) {
            obj = new WorldGenTaiga2();
        } else if (l == 2) {
            obj = new WorldGenForest();
        } else {
            obj = new WorldGenTrees();
            if (random.nextInt(10) == 0) {
                obj = new WorldGenBigTree();
            }
        }
        if (!((WorldGenerator)obj).generate(world, random, i, j, k)) {
            world.setBlockAndMetadata(i, j, k, this.blockID, l);
        }
    }

    protected int damageDropped(int i) {
        return i & 3;
    }
}

