/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockBurntCloth;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockSnow
extends Block {
    protected BlockSnow(int i, int j) {
        super(i, j, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k) & 7;
        if (l >= 3) {
            return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (float)j + 0.5f, (double)k + this.maxZ);
        }
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockMetadata(i, j, k) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if ((l == 0 || !Block.allBlocks[l].isOpaqueCube() || BlockBurntCloth.getSurroundHotBlock(world, i, j, k)) && l != Block.leaves.blockID) {
            return false;
        }
        return world.getMaterialXYZ(i, j - 1, k).blocksMovement();
    }

    public boolean canPlaceSnowy(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if (!(l != 0 && Block.allBlocks[l].isOpaqueCube() || l == Block.leaves.blockID)) {
            return false;
        }
        return world.getMaterialXYZ(i, j - 1, k).blocksMovement();
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_275_g(world, i, j, k);
    }

    private boolean func_275_g(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        int i1 = Item.snowball.shiftedIndex;
        float f = 0.7f;
        double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1, 1, 0));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
        world.setBlockWithNotify(i, j, k, 0);
    }

    public int idDropped(int i, Random random) {
        return Item.snowball.shiftedIndex;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.getSavedLightValue(EnumSkyBlock.Block, i, j, k) > 11) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }
}

