/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSponge
extends Block {
    static final byte radius = 2;

    protected BlockSponge(int i) {
        super(i, Material.sponge);
        this.blockIndexInTexture = 48;
    }

    public void onBlockAdded(World world, int a, int b, int c) {
        super.onBlockAdded(world, a, b, c);
        int x = a - 2;
        while (x <= a + 2) {
            int y = b - 2;
            while (y <= b + 2) {
                int z = c - 2;
                while (z <= c + 2) {
                    if (world.getBlockId(x, y, z) == Block.waterMoving.blockID || world.getBlockId(x, y, z) == Block.waterStill.blockID) {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this.isReceivingRedstonePower(world, i, j, k, l)) {
            this.dropBlockAsItemWithChance(world, i, j, k, 19, 0.0f);
            world.setBlockWithNotify(i, j, k, 87);
        }
    }

    private boolean isReceivingRedstonePower(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }

    public void dropWater(World world, int x, int y, int z) {
        int i = y;
        while (i > y - 3) {
            if (world.getBlockId(x, i, z) != 0 && world.getBlockId(x, i, z) != Block.waterStill.blockID || !BlockSponge.getSurroundSponge(world, x, i, z)) break;
            --i;
        }
    }

    public void flowWater(World world, int x, int y, int z, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlockId(x, y, z) != 0 && world.getBlockId(x, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z))) {
            this.dropWater(world, x, y, z);
            if (!(x + 1 >= sx + radius || world.getBlockId(x + 1, y, z) != 0 && world.getBlockId(x + 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x + 1, y, z))) {
                world.notifyBlocksOfNeighborChange(x + 1, y, z, 1);
            }
            if (!(z + 1 >= sz + radius || world.getBlockId(x, y, z + 1) != 0 && world.getBlockId(x, y, z + 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z + 1))) {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, 1);
            }
            if (!(x - 1 <= sx - radius || world.getBlockId(x - 1, y, z) != 0 && world.getBlockId(x - 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x - 1, y, z))) {
                world.notifyBlocksOfNeighborChange(x - 1, y, z, 1);
            }
            if (!(z - 1 <= sz - radius || world.getBlockId(x, y, z - 1) != 0 && world.getBlockId(x, y, z - 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z - 1))) {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, 1);
            }
        }
    }

    public void updateTick(World world, int a, int b, int c, Random random) {
        super.updateTick(world, a, b, c, random);
        int x = a - 2;
        while (x <= a + 2) {
            int y = b - 2;
            while (y <= b + 2) {
                int z = c - 2;
                while (z <= c + 2) {
                    if (world.getBlockId(x, y, z) == Block.waterMoving.blockID || world.getBlockId(x, y, z) == Block.waterStill.blockID) {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void fillWater(World world, int x, int y, int z) {
        int radius = 3;
        int x1 = x - radius;
        while (x1 <= x + radius) {
            int y1 = y;
            while (y1 > y - radius) {
                int z1 = z - radius;
                while (z1 <= z + radius) {
                    if (!(world.getBlockId(x1, y1, z1) != 0 && world.getBlockId(x1, y1, z1) != Block.waterStill.blockID && world.getBlockId(x1, y1, z1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x, y, z))) {
                        world.setBlockWithNotify(x1, y1, z1, Block.waterMoving.blockID);
                    }
                    ++z1;
                }
                --y1;
            }
            ++x1;
        }
    }

    public static boolean getSurroundSponge(World world, int x, int y, int z) {
        int x1 = x - 2;
        while (x1 <= x + 2) {
            int y1 = y - 2;
            while (y1 <= y + 2) {
                int z1 = z - 2;
                while (z1 <= z + 2) {
                    if (world.getBlockId(x1, y1, z1) == Block.sponge.blockID) {
                        return true;
                    }
                    ++z1;
                }
                ++y1;
            }
            ++x1;
        }
        return false;
    }

    public void onBlockDestroyedByPlayer(World world, int a, int b, int c, int bid) {
        super.onBlockDestroyedByPlayer(world, a, b, c, bid);
        int radius = 3;
        int x = a - radius;
        while (x <= a + radius) {
            int y = b + radius;
            while (y > b - radius) {
                int z = c - radius;
                while (z <= c + radius) {
                    if (world.getBlockId(x, y, z) == Block.waterMoving.blockID || world.getBlockId(x, y, z) == Block.waterStill.blockID) {
                        this.flowWater(world, x, y, z, a, b, c);
                    }
                    ++z;
                }
                --y;
            }
            ++x;
        }
    }
}

