/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSpongeInactive
extends Block {
    static final byte radius = 3;

    protected BlockSpongeInactive(int i) {
        super(i, Material.sponge);
    }

    public int createBlockEntity(int i, Random random) {
        return Block.sponge.blockID;
    }

    public int idDropped(int i, Random random) {
        return Block.sponge.blockID;
    }

    public void onBlockAdded(World world, int a, int b, int c) {
        super.onBlockAdded(world, a, b, c);
        int x = a - 3;
        while (x <= a + 3) {
            int y = b - 3;
            while (y <= b + 3) {
                int z = c - 3;
                while (z <= c + 3) {
                    if (world.getBlockId(x, y, z) == Block.waterMoving.blockID || world.getBlockId(x, y, z) == Block.waterStill.blockID) {
                        world.setBlockAndMetadataWithNotify(x, y, z, Block.waterMoving.blockID, world.getBlockMetadata(x, y, z));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!this.isReceivingRedstonePower(world, i, j, k, l)) {
            this.onBlockDestroyedByPlayer(world, i, j, k, 19);
            world.setBlockWithNotify(i, j, k, 19);
        }
    }

    private boolean isReceivingRedstonePower(World world, int i, int j, int k, int l) {
        if (l != 0 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l != 1 && world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (l != 2 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l != 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l != 5 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5)) {
            return true;
        }
        if (l != 4 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j, k, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 2, k, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i, j + 1, k + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i - 1, j + 1, k, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i + 1, j + 1, k, 5);
    }
}

