/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluid;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockStationary
extends BlockFluid {
    protected BlockStationary(int i, Material material) {
        super(i, material);
        this.setTickOnLoad(false);
        if (material == Material.lava) {
            this.setTickOnLoad(true);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        if (world.getBlockId(i, j, k) == this.blockID) {
            this.func_30005_i(world, i, j, k);
        }
    }

    private void func_30005_i(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.editingBlocks = true;
        world.setBlockAndMetadata(i, j, k, this.blockID - 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.scheduleUpdateTick(i, j, k, this.blockID - 1, this.tickRate());
        world.editingBlocks = false;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.blockMaterial == Material.lava) {
            int l = random.nextInt(3);
            int i1 = 0;
            while (i1 < l) {
                int j1 = world.getBlockId(i += random.nextInt(3) - 1, ++j, k += random.nextInt(3) - 1);
                if (j1 == 0) {
                    if (this.func_4033_j(world, i - 1, j, k) || this.func_4033_j(world, i + 1, j, k) || this.func_4033_j(world, i, j, k - 1) || this.func_4033_j(world, i, j, k + 1) || this.func_4033_j(world, i, j - 1, k) || this.func_4033_j(world, i, j + 1, k)) {
                        world.setBlockWithNotify(i, j, k, Block.fire.blockID);
                        return;
                    }
                } else if (Block.allBlocks[j1].blockMaterial.blocksMovement()) {
                    return;
                }
                ++i1;
            }
        }
    }

    private boolean func_4033_j(World world, int i, int j, int k) {
        return world.getMaterialXYZ(i, j, k).getBurning();
    }
}

