/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockStep
extends Block {
    public static final String[] field_22027_a = new String[]{"stone", "sand", "wood", "cobble"};
    private boolean isDouble;

    public BlockStep(int i, boolean flag) {
        super(i, 6, Material.rock);
        this.isDouble = flag;
        if (!flag) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightOpacity(255);
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j == 0) {
            return i > 1 ? 5 : 6;
        }
        if (j == 1) {
            if (i == 0) {
                return 208;
            }
            return i != 1 ? 192 : 176;
        }
        if (j == 2) {
            return 4;
        }
        return j != 3 ? 6 : 16;
    }

    public int getBlockTextureFromSide(int i) {
        return this.getBlockTextureFromSideAndMetadata(i, 0);
    }

    public boolean isOpaqueCube() {
        return this.isDouble;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblock, int i, int j, int k) {
        if (this.isDouble) {
            return;
        }
        int orientation = iblock.getBlockMetadata(i, j, k);
        switch (orientation) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public void onBlockPlacedByAt(World world, int i, int j, int k, int face, EntityPlayer player) {
        int orientation = world.getBlockMetadata(i, j, k);
        orientation = face;
        if (face == 1) {
            orientation = 0;
        } else if (face == 0) {
            orientation = 1;
        }
        if (player.isSneaking()) {
            orientation = 0;
        }
        if (player.isRunning()) {
            orientation = 1;
        }
        world.setBlockMetadataWithNotify(i, j, k, orientation);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (this != Block.stepSingle) {
            super.onBlockAdded(world, i, j, k);
        }
        int l = world.getBlockId(i, j - 1, k);
        int orientation = world.getBlockMetadata(i, j, k);
        int orientationBelow = world.getBlockMetadata(i, j - 1, k);
    }

    public int idDropped(int i, Random random) {
        return Block.stepSingle.blockID;
    }

    public int quantityDropped(Random random) {
        return !this.isDouble ? 1 : 2;
    }

    public boolean isACube() {
        return this.isDouble;
    }
}

