/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockTNT
extends Block {
    public BlockTNT(int i, int j) {
        super(i, j, Material.tnt);
    }

    public int getBlockTextureFromSide(int i) {
        if (i == 0) {
            return this.blockIndexInTexture + 2;
        }
        if (i == 1) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.isBlockIndirectlyGettingPowered(i, j, k)) {
            this.onBlockDestroyedByPlayer(world, i, j, k, 1);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.allBlocks[l].canProvidePower() && world.isBlockIndirectlyGettingPowered(i, j, k)) {
            this.onBlockDestroyedByPlayer(world, i, j, k, 1);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
        entitytntprimed.fuse = world.rand.nextInt(entitytntprimed.fuse / 4) + entitytntprimed.fuse / 8;
        world.entityJoinedWorld(entitytntprimed);
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        if (world.singleplayerWorld) {
            return;
        }
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
        world.entityJoinedWorld(entitytntprimed);
        world.playSoundAtEntity(entitytntprimed, "random.fuse", 1.0f, 1.0f);
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.striker.shiftedIndex) {
            world.setBlockMetadata(i, j, k, 1);
        }
        super.onBlockClicked(world, i, j, k, entityplayer);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return super.blockActivated(world, i, j, k, entityplayer);
    }
}

