/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network;

import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.NetServerHandler;
import com.mojang.minecraft.network.NetworkManager;
import com.mojang.minecraft.network.ThreadLoginVerifier;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet1Login;
import com.mojang.minecraft.network.packet.Packet255KickDisconnect;
import com.mojang.minecraft.network.packet.Packet2Handshake;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.network.packet.Packet62CompassPosition;
import com.mojang.minecraft.network.packet.Packet6SpawnPosition;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.WorldServer;
import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import java.util.logging.Logger;

public class NetLoginHandler
extends NetHandler {
    public static Logger logger = Logger.getLogger("Minecraft");
    private static Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private Packet1Login packet1login = null;
    private String serverId = "";

    public NetLoginHandler(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this);
        this.netManager.chunkDataSendCounter = 0;
    }

    public void tryLogin() {
        if (this.packet1login != null) {
            this.doLogin(this.packet1login);
            this.packet1login = null;
        }
        if (this.loginTimer++ == 600) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        try {
            logger.info("Disconnecting " + this.getUserAndIPString() + ": " + s);
            this.netManager.addToSendQueue(new Packet255KickDisconnect(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleHandshake(Packet2Handshake packet2handshake) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new Packet2Handshake(this.serverId));
        } else {
            this.netManager.addToSendQueue(new Packet2Handshake("-"));
        }
    }

    public void handleLogin(Packet1Login packet1login) {
        this.username = packet1login.username;
        if (packet1login.protocolVersion != 1112) {
            if (packet1login.protocolVersion > 1112) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(packet1login);
        } else {
            new ThreadLoginVerifier(this, packet1login).start();
        }
    }

    public void doLogin(Packet1Login packet1login) {
        EntityPlayerMP entityplayermp = this.mcServer.configManager.login(this, packet1login.username);
        if (entityplayermp != null) {
            this.mcServer.configManager.readPlayerDataFromFile(entityplayermp);
            entityplayermp.setWorldHandler(this.mcServer.getWorldManager(entityplayermp.dimension));
            logger.info(this.getUserAndIPString() + " logged in with entity id " + entityplayermp.entityId + " at (" + entityplayermp.posX + ", " + entityplayermp.posY + ", " + entityplayermp.posZ + ")");
            WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            if (entityplayermp.getSpawnChunk() != null) {
                chunkcoordinates = entityplayermp.getSpawnChunk();
            }
            NetServerHandler netserverhandler = new NetServerHandler(this.mcServer, this.netManager, entityplayermp);
            netserverhandler.sendPacket(new Packet1Login("", entityplayermp.entityId, worldserver.getRandomSeed(), (byte)worldserver.worldProvider.worldObj.difficultySetting, (byte)worldserver.worldProvider.worldObj.season.ordinal(), (byte)worldserver.worldProvider.worldObj.weather.ordinal()));
            netserverhandler.sendPacket(new Packet6SpawnPosition(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ));
            netserverhandler.sendPacket(new Packet62CompassPosition(entityplayermp.getMeasuredBlock()[0], entityplayermp.getMeasuredBlock()[1], entityplayermp.getMeasuredBlock()[2]));
            this.mcServer.configManager.func_28170_a(entityplayermp, worldserver);
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("\u00a7e" + entityplayermp.username + " joined the game."));
            this.mcServer.configManager.playerLoggedIn(entityplayermp);
            netserverhandler.teleportTo(entityplayermp.posX, entityplayermp.posY, entityplayermp.posZ, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            this.mcServer.networkServer.addPlayer(netserverhandler);
            netserverhandler.sendPacket(new Packet4UpdateTime(worldserver.getWorldTime()));
            this.mcServer.addToPlayerList(entityplayermp.username, entityplayermp.score);
            netserverhandler.handlePlayerScore();
            entityplayermp.func_20057_k();
        }
        this.finishedProcessing = true;
    }

    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info(this.getUserAndIPString() + " lost connection");
        this.finishedProcessing = true;
    }

    public void registerPacket(Packet packet) {
        this.kickUser("Protocol error");
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    public boolean isServerHandler() {
        return true;
    }

    static String getServerId(NetLoginHandler netloginhandler) {
        return netloginhandler.serverId;
    }

    static Packet1Login setLoginPacket(NetLoginHandler netloginhandler, Packet1Login packet1login) {
        netloginhandler.packet1login = packet1login;
        return netloginhandler.packet1login;
    }
}

