/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.ICommandListener;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.NetworkManager;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet0KeepAlive;
import com.mojang.minecraft.network.packet.Packet101CloseWindow;
import com.mojang.minecraft.network.packet.Packet102WindowClick;
import com.mojang.minecraft.network.packet.Packet103SetSlot;
import com.mojang.minecraft.network.packet.Packet106Transaction;
import com.mojang.minecraft.network.packet.Packet10Flying;
import com.mojang.minecraft.network.packet.Packet130UpdateSign;
import com.mojang.minecraft.network.packet.Packet13PlayerLookMove;
import com.mojang.minecraft.network.packet.Packet14BlockDig;
import com.mojang.minecraft.network.packet.Packet15Place;
import com.mojang.minecraft.network.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.network.packet.Packet18Animation;
import com.mojang.minecraft.network.packet.Packet19EntityAction;
import com.mojang.minecraft.network.packet.Packet255KickDisconnect;
import com.mojang.minecraft.network.packet.Packet27Position;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet53BlockChange;
import com.mojang.minecraft.network.packet.Packet69PlayerScore;
import com.mojang.minecraft.network.packet.Packet7UseEntity;
import com.mojang.minecraft.network.packet.Packet9Respawn;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.WorldServer;
import com.mojang.minecraft.util.MathHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class NetServerHandler
extends NetHandler
implements ICommandListener {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    public static Logger logger = Logger.getLogger("Minecraft");
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    public MinecraftServer mcServer;
    private EntityPlayerMP playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private boolean field_22003_h;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private Map field_10_k = new HashMap();
    String field_1_color;
    public static TreeMap<String, String> customColors = new TreeMap();

    public NetServerHandler(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayerMP entityplayermp) {
        this.mcServer = minecraftserver;
        this.netManager = networkmanager;
        networkmanager.setNetHandler(this);
        this.playerEntity = entityplayermp;
        entityplayermp.playerNetServerHandler = this;
        this.grabCustomColors();
        this.field_1_color = NetServerHandler.computePlayerColor(entityplayermp.username);
    }

    public void grabCustomColors() {
        try {
            URL capeDownload = new URL("http://androdome.com/nsss/capes.txt");
            File capeFile = File.createTempFile("nsss-capes", null);
            HttpURLConnection con = (HttpURLConnection)capeDownload.openConnection();
            con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = in.readLine();
            customColors.clear();
            while (line != null) {
                String[] data = line.split(";");
                if (!data[3].equals("n")) {
                    customColors.put(data[0], data[3]);
                }
                line = in.readLine();
            }
            in.close();
            if (capeFile.exists()) {
                try {
                    capeFile.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static String computePlayerColor(String name) {
        String custom = customColors.get(name);
        if (custom != null) {
            return custom;
        }
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i = 0;
        while (i < length) {
            byte by = pName[i];
            int rev = length - (i + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by) : (value += by);
            ++i;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    public void handlePlayerScore() {
        int i = 0;
        while (i < this.mcServer.players.size()) {
            this.sendPacket(new Packet69PlayerScore(this.mcServer.players.get((int)i).playerName, this.mcServer.players.get((int)i).playerScore, true));
            ++i;
        }
    }

    public void handlePackets() {
        this.field_22003_h = false;
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new Packet0KeepAlive());
        }
    }

    public void kickPlayer(String s) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new Packet255KickDisconnect(s));
        this.netManager.serverShutdown();
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("\u00a7e" + this.playerEntity.username + " left the game."));
        this.mcServer.removeFromPlayerList(this.playerEntity.username);
        this.mcServer.configManager.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
    }

    public void handleMovementTypePacket(Packet27Position packet27position) {
        this.playerEntity.setMovementType(packet27position.func_22031_c(), packet27position.func_22028_e(), packet27position.func_22032_g(), packet27position.func_22030_h(), packet27position.func_22029_d(), packet27position.func_22033_f());
    }

    public void handleFlying(Packet10Flying packet10flying) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        this.field_22003_h = true;
        if (!this.hasMoved) {
            double d = packet10flying.yPosition - this.lastPosY;
            if (packet10flying.xPosition == this.lastPosX && d * d < 0.01 && packet10flying.zPosition == this.lastPosZ) {
                this.hasMoved = true;
            }
        }
        if (this.hasMoved) {
            boolean flag2;
            if (this.playerEntity.ridingEntity != null) {
                float f = this.playerEntity.rotationYaw;
                float f1 = this.playerEntity.rotationPitch;
                this.playerEntity.ridingEntity.updateRiderPosition();
                double d2 = this.playerEntity.posX;
                double d4 = this.playerEntity.posY;
                double d6 = this.playerEntity.posZ;
                double d8 = 0.0;
                double d9 = 0.0;
                if (packet10flying.rotating) {
                    f = packet10flying.yaw;
                    f1 = packet10flying.pitch;
                }
                if (packet10flying.moving && packet10flying.yPosition == -999.0 && packet10flying.stance == -999.0) {
                    d8 = packet10flying.xPosition;
                    d9 = packet10flying.zPosition;
                }
                this.playerEntity.onGround = packet10flying.onGround;
                this.playerEntity.onUpdateEntity(true);
                this.playerEntity.moveEntity(d8, 0.0, d9);
                this.playerEntity.setPositionAndRotation(d2, d4, d6, f, f1);
                this.playerEntity.motionX = d8;
                this.playerEntity.motionZ = d9;
                if (this.playerEntity.ridingEntity != null) {
                    worldserver.func_12017_b(this.playerEntity.ridingEntity, true);
                }
                if (this.playerEntity.ridingEntity != null) {
                    this.playerEntity.ridingEntity.updateRiderPosition();
                }
                this.mcServer.configManager.func_613_b(this.playerEntity);
                this.lastPosX = this.playerEntity.posX;
                this.lastPosY = this.playerEntity.posY;
                this.lastPosZ = this.playerEntity.posZ;
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            if (this.playerEntity.func_22057_E()) {
                this.playerEntity.onUpdateEntity(true);
                this.playerEntity.setPositionAndRotation(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            double d1 = this.playerEntity.posY;
            this.lastPosX = this.playerEntity.posX;
            this.lastPosY = this.playerEntity.posY;
            this.lastPosZ = this.playerEntity.posZ;
            double d3 = this.playerEntity.posX;
            double d5 = this.playerEntity.posY;
            double d7 = this.playerEntity.posZ;
            float f2 = this.playerEntity.rotationYaw;
            float f3 = this.playerEntity.rotationPitch;
            if (packet10flying.moving && packet10flying.yPosition == -999.0 && packet10flying.stance == -999.0) {
                packet10flying.moving = false;
            }
            if (packet10flying.moving) {
                d3 = packet10flying.xPosition;
                d5 = packet10flying.yPosition;
                d7 = packet10flying.zPosition;
                double d10 = packet10flying.stance - packet10flying.yPosition;
                if (!this.playerEntity.func_22057_E() && (d10 > 1.65 || d10 < 0.1)) {
                    this.kickPlayer("Illegal stance");
                    logger.warning(this.playerEntity.username + " had an illegal stance: " + d10);
                    return;
                }
                if (Math.abs(packet10flying.xPosition) > 3.2E7 || Math.abs(packet10flying.zPosition) > 3.2E7) {
                    this.kickPlayer("Illegal position");
                    return;
                }
            }
            if (packet10flying.rotating) {
                f2 = packet10flying.yaw;
                f3 = packet10flying.pitch;
            }
            this.playerEntity.onUpdateEntity(true);
            this.playerEntity.ySize = 0.0f;
            this.playerEntity.setPositionAndRotation(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
            if (!this.hasMoved) {
                return;
            }
            double d11 = d3 - this.playerEntity.posX;
            double d12 = d5 - this.playerEntity.posY;
            double d13 = d7 - this.playerEntity.posZ;
            double d14 = d11 * d11 + d12 * d12 + d13 * d13;
            if (d14 > 100.0) {
                logger.warning(this.playerEntity.username + " moved too quickly!");
                this.kickPlayer("You moved too quickly :( (Hacking?)");
                return;
            }
            float f4 = 0.0625f;
            boolean flag = worldserver.getCollidingBoundingBoxes(this.playerEntity, this.playerEntity.boundingBox.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            this.playerEntity.moveEntity(d11, d12, d13);
            d11 = d3 - this.playerEntity.posX;
            d12 = d5 - this.playerEntity.posY;
            if (d12 > -0.5 || d12 < 0.5) {
                d12 = 0.0;
            }
            d13 = d7 - this.playerEntity.posZ;
            d14 = d11 * d11 + d12 * d12 + d13 * d13;
            boolean flag1 = false;
            if (d14 > 0.0625 && !this.playerEntity.func_22057_E()) {
                flag1 = true;
                logger.warning(this.playerEntity.username + " moved wrongly!");
                System.out.println("Got position " + d3 + ", " + d5 + ", " + d7);
                System.out.println("Expected " + this.playerEntity.posX + ", " + this.playerEntity.posY + ", " + this.playerEntity.posZ);
            }
            this.playerEntity.setPositionAndRotation(d3, d5, d7, f2, f3);
            boolean bl = flag2 = worldserver.getCollidingBoundingBoxes(this.playerEntity, this.playerEntity.boundingBox.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            if (flag && (flag1 || !flag2) && !this.playerEntity.func_22057_E()) {
                this.teleportTo(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            AxisAlignedBB axisalignedbb = this.playerEntity.boundingBox.copy().expand(f4, f4, f4).addCoord(0.0, -0.55, 0.0);
            if (!this.mcServer.allowFlight && !worldserver.func_27069_b(axisalignedbb)) {
                if (d12 >= -0.03125) {
                    ++this.playerInAirTime;
                    if (this.playerInAirTime > 80) {
                        logger.warning(this.playerEntity.username + " was kicked for floating too long!");
                        this.kickPlayer("Flying is not enabled on this server");
                        return;
                    }
                }
            } else {
                this.playerInAirTime = 0;
            }
            this.playerEntity.onGround = packet10flying.onGround;
            this.mcServer.configManager.func_613_b(this.playerEntity);
            this.playerEntity.handleFalling(this.playerEntity.posY - d1, packet10flying.onGround);
        }
    }

    public void teleportTo(double d, double d1, double d2, float f, float f1) {
        this.hasMoved = false;
        this.lastPosX = d;
        this.lastPosY = d1;
        this.lastPosZ = d2;
        this.playerEntity.setPositionAndRotation(d, d1, d2, f, f1);
        this.playerEntity.playerNetServerHandler.sendPacket(new Packet13PlayerLookMove(d, d1 + (double)1.62f, d1, d2, f, f1, false));
    }

    public void handleBlockDig(Packet14BlockDig packet14blockdig) {
        double d6;
        double d4;
        double d2;
        double d7;
        int i1;
        double d3;
        double d1;
        double d;
        double d5;
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        if (packet14blockdig.status == 4) {
            this.playerEntity.dropCurrentItem();
            return;
        }
        worldserver.field_819_z = worldserver.worldProvider.worldType != 0 || this.mcServer.configManager.isOp(this.playerEntity.username);
        boolean flag = worldserver.field_819_z;
        boolean flag1 = false;
        if (packet14blockdig.status == 0) {
            flag1 = true;
        }
        if (packet14blockdig.status == 2) {
            flag1 = true;
        }
        int i = packet14blockdig.xPosition;
        int j = packet14blockdig.yPosition;
        int k = packet14blockdig.zPosition;
        if (flag1 && (d5 = (d = this.playerEntity.posX - ((double)i + 0.5)) * d + (d1 = this.playerEntity.posY - ((double)j + 0.5)) * d1 + (d3 = this.playerEntity.posZ - ((double)k + 0.5)) * d3) > 36.0) {
            return;
        }
        ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
        int l = (int)MathHelper.abs(i - chunkcoordinates.posX);
        if (l > (i1 = (int)MathHelper.abs(k - chunkcoordinates.posZ))) {
            i1 = l;
        }
        if (packet14blockdig.status == 0) {
            if (i1 > 16 || flag) {
                this.playerEntity.itemInWorldManager.itemDoAClickABlock(i, j, k, packet14blockdig.face);
            } else {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i, j, k, worldserver));
            }
        } else if (packet14blockdig.status == 2) {
            this.playerEntity.itemInWorldManager.itemDoADigABlock(i, j, k);
            if (worldserver.getBlockId(i, j, k) != 0) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i, j, k, worldserver));
            }
        } else if (packet14blockdig.status == 3 && (d7 = (d2 = this.playerEntity.posX - ((double)i + 0.5)) * d2 + (d4 = this.playerEntity.posY - ((double)j + 0.5)) * d4 + (d6 = this.playerEntity.posZ - ((double)k + 0.5)) * d6) < 256.0) {
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i, j, k, worldserver));
        }
        worldserver.field_819_z = false;
    }

    public void handlePlace(Packet15Place packet15place) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        worldserver.field_819_z = worldserver.worldProvider.worldType != 0 || this.mcServer.configManager.isOp(this.playerEntity.username);
        boolean flag = worldserver.field_819_z;
        if (packet15place.direction == 255) {
            if (itemstack == null) {
                return;
            }
            this.playerEntity.itemInWorldManager.startUsingItem(this.playerEntity, worldserver, itemstack);
        } else if (packet15place.direction == 254) {
            if (itemstack == null) {
                return;
            }
            System.out.println("UNCLICK!");
            this.playerEntity.onPlayerStoppedUsing();
        } else {
            int j1;
            int i = packet15place.xPosition;
            int j = packet15place.yPosition;
            int k = packet15place.zPosition;
            int l = packet15place.direction;
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            int i1 = (int)MathHelper.abs(i - chunkcoordinates.posX);
            if (i1 > (j1 = (int)MathHelper.abs(k - chunkcoordinates.posZ))) {
                j1 = i1;
            }
            if (this.hasMoved && this.playerEntity.getDistanceSq((double)i + 0.5, (double)j + 0.5, (double)k + 0.5) < 64.0 && (j1 > 16 || flag)) {
                this.playerEntity.itemInWorldManager.activeBlockOrUseItem(this.playerEntity, worldserver, itemstack, i, j, k, l);
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i, j, k, worldserver));
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i, j, k, worldserver));
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize == 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = ItemStack.func_20117_a(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem]);
        Slot slot = this.playerEntity.currentCraftingInventory.func_20127_a(this.playerEntity.inventory, this.playerEntity.inventory.currentItem);
        this.playerEntity.currentCraftingInventory.updateCraftingMatrix();
        this.playerEntity.isChangingQuantityOnly = false;
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet15place.itemStack)) {
            this.sendPacket(new Packet103SetSlot(this.playerEntity.currentCraftingInventory.windowId, slot.id, this.playerEntity.inventory.getCurrentItem()));
        }
        worldserver.field_819_z = false;
    }

    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info(this.playerEntity.username + " lost connection: " + s);
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("\u00a7e" + this.playerEntity.username + " left the game."));
        this.mcServer.removeFromPlayerList(this.playerEntity.username);
        this.mcServer.configManager.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
    }

    public void registerPacket(Packet packet) {
        logger.warning(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    public void handleBlockItemSwitch(Packet16BlockItemSwitch packet16blockitemswitch) {
        if (packet16blockitemswitch.id < 0 || packet16blockitemswitch.id > InventoryPlayer.func_25054_e()) {
            logger.warning(this.playerEntity.username + " tried to set an invalid carried item");
            return;
        }
        this.playerEntity.inventory.currentItem = packet16blockitemswitch.id;
    }

    public void handleChat(Packet3Chat packet3chat) {
        String s = packet3chat.message;
        if (s.length() > 256) {
            this.kickPlayer("Chat message too long");
            return;
        }
        s = s.trim();
        int i = 0;
        while (i < s.length()) {
            ChatAllowedCharacters.allowedCharacters.indexOf(s.charAt(i));
            ++i;
        }
        if (s.startsWith("/")) {
            this.handleSlashCommand(s);
        } else {
            s = "<\u00a7" + this.field_1_color + this.playerEntity.username + "\u00a7f> " + s;
            logger.info(s);
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(s));
        }
    }

    private void handleSlashCommand(String s) {
        if (s.toLowerCase().startsWith("/me ")) {
            s = "* " + this.playerEntity.username + " " + s.substring(s.indexOf(" ")).trim();
            logger.info(s);
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(s));
        } else if (s.toLowerCase().startsWith("/billnye ")) {
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("<\u00a7cBill Nye\u00a7f> DID YOU KNOW THAT"));
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("<\u00a7cBill Nye\u00a7f> " + s.replaceFirst("/billnye ", "")));
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("<\u00a7cBill Nye\u00a7f> NOW YOU KNOW!"));
        }
        if (s.toLowerCase().startsWith("/kill")) {
            this.playerEntity.attackEntityFrom(null, 1000);
        } else if (s.toLowerCase().startsWith("/tell ")) {
            String[] as = s.split(" ");
            if (as.length >= 3) {
                s = s.substring(s.indexOf(" ")).trim();
                s = s.substring(s.indexOf(" ")).trim();
                s = "\u00a77" + this.playerEntity.username + " whispers " + s;
                logger.info(s + " to " + as[1]);
                if (!this.mcServer.configManager.sendPacketToPlayer(as[1], new Packet3Chat(s))) {
                    this.sendPacket(new Packet3Chat("\u00a7cThere's no player by that name online."));
                }
            }
        } else if (s.toLowerCase().startsWith("/cleanup ")) {
            String[] as = s.split(" ");
            if (as.length >= 2) {
                s = s.substring(s.indexOf(" ")).trim();
                if (as[1].equals("0")) {
                    this.mcServer.cleanSpawnChunks(false);
                }
                if (as[1].equals("1")) {
                    this.mcServer.cleanSpawnChunks(true);
                }
            }
        } else if (this.mcServer.configManager.isOp(this.playerEntity.username)) {
            String s1 = s.substring(1);
            logger.info(this.playerEntity.username + " issued server command: " + s1);
            this.mcServer.addCommand(s1, this);
        } else {
            String s2 = s.substring(1);
            logger.info(this.playerEntity.username + " tried command: " + s2);
        }
    }

    public void handleArmAnimation(Packet18Animation packet18animation) {
        if (packet18animation.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    public void handleEntityAction(Packet19EntityAction packet19entityaction) {
        if (packet19entityaction.state == 1) {
            this.playerEntity.setSneaking(true);
        } else if (packet19entityaction.state == 2) {
            this.playerEntity.setSneaking(false);
        }
        if (packet19entityaction.state == 3) {
            this.playerEntity.setRunning(true);
        } else if (packet19entityaction.state == 4) {
            this.playerEntity.setRunning(false);
        }
    }

    public void handleKickDisconnect(Packet255KickDisconnect packet255kickdisconnect) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
        this.mcServer.removeFromPlayerList(this.playerEntity.username);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    public void log(String s) {
        this.sendPacket(new Packet3Chat("\u00a77" + s));
    }

    public String getUsername() {
        return this.playerEntity.username;
    }

    public void func_6006_a(Packet7UseEntity packet7useentity) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        Entity entity = worldserver.func_6158_a(packet7useentity.targetEntity);
        if (entity != null && this.playerEntity.canEntityBeSeen(entity) && this.playerEntity.getDistanceSqToEntity(entity) < 36.0) {
            if (packet7useentity.isLeftClick == 0) {
                this.playerEntity.useCurrentItemOnEntity(entity);
            } else if (packet7useentity.isLeftClick == 1) {
                this.playerEntity.attackTargetEntityWithCurrentItem(entity);
            }
        }
    }

    public void handleRespawnPacket(Packet9Respawn packet9respawn) {
        if (this.playerEntity.health > 0) {
            return;
        }
        this.playerEntity = this.mcServer.configManager.recreatePlayerEntity(this.playerEntity, 0);
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        try {
            worldserver.addLightningBolt(new EntityLightningBolt(worldserver, this.playerEntity.getSpawnChunk().posX, this.playerEntity.getSpawnChunk().posY, this.playerEntity.getSpawnChunk().posZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleCraftingGuiClosedPacked(Packet101CloseWindow packet101closewindow) {
        this.playerEntity.closeCraftingGui();
    }

    public void func_20007_a(Packet102WindowClick packet102windowclick) {
        if (this.playerEntity.currentCraftingInventory.windowId == packet102windowclick.window_Id && this.playerEntity.currentCraftingInventory.getCanCraft(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.currentCraftingInventory.func_27085_a(packet102windowclick.inventorySlot, packet102windowclick.mouseClick, packet102windowclick.field_27039_f, this.playerEntity);
            if (ItemStack.areItemStacksEqual(packet102windowclick.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(packet102windowclick.window_Id, packet102windowclick.action, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.currentCraftingInventory.updateCraftingMatrix();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.field_10_k.put(this.playerEntity.currentCraftingInventory.windowId, packet102windowclick.action);
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(packet102windowclick.window_Id, packet102windowclick.action, false));
                this.playerEntity.currentCraftingInventory.setCanCraft(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                int i = 0;
                while (i < this.playerEntity.currentCraftingInventory.inventorySlots.size()) {
                    arraylist.add(((Slot)this.playerEntity.currentCraftingInventory.inventorySlots.get(i)).getStack());
                    ++i;
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.currentCraftingInventory, arraylist);
            }
        }
    }

    public void func_20008_a(Packet106Transaction packet106transaction) {
        Short short1 = (Short)this.field_10_k.get(this.playerEntity.currentCraftingInventory.windowId);
        if (short1 != null && packet106transaction.shortWindowId == short1 && this.playerEntity.currentCraftingInventory.windowId == packet106transaction.windowId && !this.playerEntity.currentCraftingInventory.getCanCraft(this.playerEntity)) {
            this.playerEntity.currentCraftingInventory.setCanCraft(this.playerEntity, true);
        }
    }

    public void handleUpdateSign(Packet130UpdateSign packet130updatesign) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        if (worldserver.blockExists(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition)) {
            TileEntitySign tileentitysign;
            TileEntity tileentity = worldserver.getBlockTileEntity(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition);
            if (tileentity instanceof TileEntitySign && !(tileentitysign = (TileEntitySign)tileentity).getIsEditAble()) {
                this.mcServer.logWarning("Player " + this.playerEntity.username + " just tried to change non-editable sign");
                return;
            }
            int i = 0;
            while (i < 4) {
                boolean flag = true;
                if (packet130updatesign.signLines[i].length() > 15) {
                    flag = false;
                } else {
                    int l = 0;
                    while (l < packet130updatesign.signLines[i].length()) {
                        ChatAllowedCharacters.allowedCharacters.indexOf(packet130updatesign.signLines[i].charAt(l));
                        ++l;
                    }
                }
                if (!flag) {
                    packet130updatesign.signLines[i] = "!?";
                }
                ++i;
            }
            if (tileentity instanceof TileEntitySign) {
                int j = packet130updatesign.xPosition;
                int k = packet130updatesign.yPosition;
                int i1 = packet130updatesign.zPosition;
                TileEntitySign tileentitysign1 = (TileEntitySign)tileentity;
                int j1 = 0;
                while (j1 < 4) {
                    tileentitysign1.signText[j1] = packet130updatesign.signLines[j1];
                    ++j1;
                }
                tileentitysign1.func_32001_a(false);
                tileentitysign1.onInventoryChanged();
                worldserver.markBlockNeedsUpdate(j, k, i1);
            }
        }
    }

    public boolean isServerHandler() {
        return true;
    }
}

